<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\MenuService;
use Illuminate\Support\Facades\Cache;

class ClearMenuCacheCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'menu:clear-cache {--lang= : Clear cache for specific language}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear menu and header settings cache';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $languageCode = $this->option('lang');
        
        $this->info('Clearing menu cache...');
        
        try {
            $menuService = app(MenuService::class);
            
            if ($languageCode) {
                $menuService->clearCache($languageCode);
                $this->info("Menu cache cleared for language: {$languageCode}");
            } else {
                $menuService->clearCache();
                $this->info('Menu cache cleared for all languages');
            }
            
            // Clear additional caches
            Cache::forget('menu_statistics');
            Cache::forget('site_navigation');
            
            // Clear view cache
            $this->call('view:clear');
            
            $this->info('✅ Menu cache cleared successfully!');
            
            return Command::SUCCESS;
            
        } catch (\Exception $e) {
            $this->error('❌ Failed to clear menu cache: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
