<?php

namespace App\Helpers;

use App\Services\SiteSettingService;

if (!function_exists('site_setting')) {
    /**
     * دریافت مقدار یک تنظیم خاص
     * 
     * @param string $key کلید تنظیم
     * @param mixed $default مقدار پیش‌فرض
     * @param string $language_code کد زبان (اختیاری)
     * @return mixed مقدار تنظیم
     */
    function site_setting($key, $default = null, $language_code = null)
    {
        return app(SiteSettingService::class)->getSetting($key, $language_code, $default);
    }
}

if (!function_exists('getSiteSetting')) {
    /**
     * دریافت مقدار یک تنظیم خاص (نام جایگزین)
     * 
     * @param string $key کلید تنظیم
     * @param mixed $default مقدار پیش‌فرض
     * @param string $language_code کد زبان (اختیاری)
     * @return mixed مقدار تنظیم
     */
    function getSiteSetting($key, $default = null, $language_code = null)
    {
        return site_setting($key, $default, $language_code);
    }
} 