<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class SessionTimeout
{
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $maxLifetime = config('session.lifetime', 120) * 60; // Convert to seconds
            $lastActivity = session('last_activity');

            if ($lastActivity && (time() - $lastActivity) > $maxLifetime) {
                Auth::logout();
                $request->session()->invalidate();
                $request->session()->regenerateToken();

                return redirect()->route('login')
                    ->with('error', 'نشست شما به دلیل عدم فعالیت منقضی شده است. لطفاً مجدداً وارد شوید.');
            }

            session(['last_activity' => time()]);
        }

        return $next($request);
    }
}
