<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AmenityType extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'amenity_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'type_key',
        'type_name',
        'type_section',
        'display_order',
    ];

    /**
     * Get the amenities for this type.
     */
    public function amenities()
    {
        return $this->hasMany(Amenity::class, 'type_id');
    }

    /**
     * دریافت نام ترجمه‌شده نوع امکانات بر اساس زبان فعال
     * 
     * @param string $languageCode کد زبان (fa, en, ...)
     * @return string نام ترجمه‌شده
     */
    public function getTranslatedName($languageCode = 'fa')
    {
        // استفاده از کش برای بهبود عملکرد
        $cacheKey = "amenity_type_{$this->id}_name_{$languageCode}";
        
        return cache()->remember($cacheKey, now()->addHours(24), function () use ($languageCode) {
            // اولویت اول: ترجمه در جدول translations
            $translation = $this->translations()
                ->where('language_code', $languageCode)
                ->first();
            
            if ($translation && !empty($translation->name)) {
                return $translation->name;
            }
            
            // اولویت دوم: نام اصلی
            return $this->name;
        });
    }
}
