<?php

namespace App\Services;

use App\Models\DisplaySetting;
use Illuminate\Support\Facades\Cache;

class DisplaySettingService
{
    /**
     * دریافت تنظیمات نمایش برای یک صفحه و بخش خاص
     */
    public function getSettings(string $pageKey, string $sectionKey)
    {
        $cacheKey = "display_settings_{$pageKey}_{$sectionKey}";

        return Cache::remember($cacheKey, 3600, function () use ($pageKey, $sectionKey) {
            return DisplaySetting::where('page_key', $pageKey)
                ->where('section_key', $sectionKey)
                ->where('is_active', true)
                ->first();
        });
    }

    /**
     * دریافت تعداد آیتم‌های نمایشی بر اساس نوع دستگاه
     */
    public function getItemsPerPage(string $pageKey, string $sectionKey, bool $isMobile = false)
    {
        $settings = $this->getSettings($pageKey, $sectionKey);

        if (! $settings) {
            return $isMobile ? 9 : 9; // مقادیر پیش‌فرض
        }

        return $isMobile ? $settings->mobile_items : $settings->desktop_items;
    }

    /**
     * دریافت متن دکمه نمایش بیشتر
     */
    public function getLoadMoreText(string $pageKey, string $sectionKey)
    {
        $settings = $this->getSettings($pageKey, $sectionKey);

        if ($settings && trim($settings->load_more_text ?? '') !== '') {
            return $settings->load_more_text;
        }
        return __("messages.load_more");
    }
}
