<?php

namespace App\Traits;

trait HasTranslatedName
{
    /**
     * دریافت نام ترجمه‌شده بر اساس زبان فعال با پشتیبانی از fallback
     * 
     * @param string|null $lang کد زبان (fa, en, ...)
     * @return string نام ترجمه‌شده
     */
    public function getTranslatedName($lang = null)
    {
        $lang = $lang ?: app()->getLocale();

        // ۱. مقدار ستون زبان فعلی
        $langColumn = $lang === 'fa' ? 'name' : 'name_' . $lang;
        $val = $this->getAttribute($langColumn);
        if (is_string($val) && trim($val) !== '') {
            return $val;
        }

        // ۲. مقدار ستون انگلیسی
        $en = $this->getAttribute('name_en');
        if (is_string($en) && trim($en) !== '') {
            return $en;
        }

        // ۳. مقدار ستون فارسی (name)
        $fa = $this->getAttribute('name');
        if (is_string($fa) && trim($fa) !== '') {
            return $fa;
        }

        // اگر هیچ مقداری نبود، حتماً رشته خالی برگردان
        return '';
    }
} 