# راهنمای سیستم چندزبانه

## مقدمه
این سیستم امکان مدیریت چندزبانه‌ای وب‌سایت را فراهم می‌کند. با استفاده از این سیستم می‌توانید:
- زبان‌های مختلف را مدیریت کنید
- از فایل‌های زبان استاندارد لاراول استفاده کنید
- پشتیبانی از RTL/LTR را مدیریت کنید

## ساختار پایگاه داده

### جدول languages
- `id`: شناسه یکتا
- `name`: نام زبان (به انگلیسی)
- `code`: کد زبان (مطابق با ISO 639-1)
- `native_name`: نام زبان به زبان اصلی
- `is_active`: وضعیت فعال بودن
- `is_default`: زبان پیش‌فرض
- `direction`: جهت متن (rtl یا ltr)
- `flag`: آیکون پرچم
- `order`: ترتیب نمایش

> **توجه:** جدول translations و مدل Translation حذف شده‌اند و فقط از فایل‌های زبان استفاده می‌شود.

## نحوه استفاده

### تنظیم زبان
```php
// تنظیم زبان فعلی
app()->setLocale('fa');

// دریافت زبان فعلی
$locale = app()->getLocale();
```

### استفاده از ترجمه‌ها
```php
// استفاده از تابع استاندارد لاراول
__('welcome.message');
```

### مدیریت RTL/LTR
```php
// در ویوها
@if(config('laravellocalization.supportedLocales')[app()->getLocale()]['dir'] === 'rtl')
    <div class="rtl">
@else
    <div class="ltr">
@endif
```

## کش‌گذاری
لاراول به صورت خودکار کش فایل‌های زبان را مدیریت می‌کند. نیازی به کش‌گذاری دستی نیست.

## نکات مهم
- برای افزودن یا ویرایش ترجمه‌ها، فقط فایل‌های موجود در مسیر `resources/lang/{locale}` را ویرایش کنید.
- برای افزودن زبان جدید، یک پوشه جدید با کد زبان (مثلاً `fa` یا `en`) در مسیر `resources/lang` ایجاد کنید و فایل‌های ترجمه را قرار دهید.
- از پکیج [mcamara/laravel-localization](https://github.com/mcamara/laravel-localization) برای مدیریت مسیرها و سوییچ زبان استفاده کنید.



## خطاهای رایج
1. **خطای کش**: اگر کش‌ها به درستی پاک نشوند، از دستور زیر استفاده کنید:
```bash
php artisan cache:clear
```

2. **خطای زبان**: اگر زبان مورد نظر یافت نشد، از زبان پیش‌فرض استفاده می‌شود

3. **خطای RTL**: اگر جهت متن درست نمایش داده نمی‌شود، فیلد `direction` را در جدول `languages` بررسی کنید

## بهینه‌سازی
1. از کش‌گذاری Redis استفاده کنید
2. ترجمه‌ها را به صورت گروهی بارگذاری کنید
3. از فایل‌های زبان برای ترجمه‌های ثابت استفاده کنید
4. از ترجمه‌های پویا برای محتوای متغیر استفاده کنید 