<?php
/**
 * Alu Dubai Tourism Guide - Auto Installer
 * این فایل برای نصب خودکار پروژه در هاست سی پنل طراحی شده است
 */

// تنظیمات خطا
error_reporting(E_ALL);
ini_set('display_errors', 1);

// بررسی وجود Composer
if (!file_exists('vendor/autoload.php')) {
    die('خطا: فایل vendor/autoload.php یافت نشد. لطفاً ابتدا composer install را اجرا کنید.');
}

// بررسی وجود فایل .env
if (!file_exists('.env')) {
    die('خطا: فایل .env یافت نشد. لطفاً فایل .env را ایجاد کنید.');
}

// بررسی دسترسی نوشتن در پوشه‌ها
$writable_dirs = ['storage', 'bootstrap/cache'];
foreach ($writable_dirs as $dir) {
    if (!is_writable($dir)) {
        echo "خطا: پوشه $dir قابل نوشتن نیست. لطفاً دسترسی‌ها را تنظیم کنید.<br>";
    }
}

// بررسی اتصال به دیتابیس
try {
    $env = file_get_contents('.env');
    preg_match('/DB_HOST=(.+)/', $env, $host);
    preg_match('/DB_DATABASE=(.+)/', $env, $database);
    preg_match('/DB_USERNAME=(.+)/', $env, $username);
    preg_match('/DB_PASSWORD=(.+)/', $env, $password);
    
    $host = trim($host[1] ?? 'localhost');
    $database = trim($database[1] ?? '');
    $username = trim($username[1] ?? '');
    $password = trim($password[1] ?? '');
    
    if (empty($database) || empty($username)) {
        die('خطا: اطلاعات دیتابیس در فایل .env کامل نیست.');
    }
    
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    echo "✓ اتصال به دیتابیس موفقیت‌آمیز بود<br>";
    
} catch (PDOException $e) {
    die('خطا در اتصال به دیتابیس: ' . $e->getMessage());
}

// اجرای دستورات Laravel
echo "<h2>مراحل نصب:</h2>";

// 1. پاک کردن کش
echo "1. پاک کردن کش...<br>";
exec('php artisan cache:clear 2>&1', $output);
echo implode('<br>', $output) . '<br>';

// 2. پاک کردن کش config
echo "2. پاک کردن کش config...<br>";
exec('php artisan config:clear 2>&1', $output);
echo implode('<br>', $output) . '<br>';

// 3. پاک کردن کش route
echo "3. پاک کردن کش route...<br>";
exec('php artisan route:clear 2>&1', $output);
echo implode('<br>', $output) . '<br>';

// 4. پاک کردن کش view
echo "4. پاک کردن کش view...<br>";
exec('php artisan view:clear 2>&1', $output);
echo implode('<br>', $output) . '<br>';

// 5. بهینه‌سازی autoload
echo "5. بهینه‌سازی autoload...<br>";
exec('composer dump-autoload --optimize 2>&1', $output);
echo implode('<br>', $output) . '<br>';

// 6. تنظیم دسترسی‌ها
echo "6. تنظیم دسترسی‌ها...<br>";
$chmod_dirs = [
    'storage' => '775',
    'bootstrap/cache' => '775',
    'public' => '755'
];

foreach ($chmod_dirs as $dir => $perm) {
    if (is_dir($dir)) {
        chmod($dir, octdec($perm));
        echo "✓ دسترسی $perm برای $dir تنظیم شد<br>";
    }
}

// 7. بررسی فایل‌های مهم
echo "7. بررسی فایل‌های مهم...<br>";
$important_files = [
    'public/index.php',
    'public/.htaccess',
    '.env',
    'composer.json'
];

foreach ($important_files as $file) {
    if (file_exists($file)) {
        echo "✓ $file موجود است<br>";
    } else {
        echo "✗ $file یافت نشد<br>";
    }
}

echo "<h2>نصب با موفقیت تکمیل شد!</h2>";
echo "<p>پروژه شما آماده استفاده است. لطفاً فایل install.php را حذف کنید.</p>";
echo "<p><a href='/' target='_blank'>مشاهده سایت</a></p>";
?>
