@extends('admin.layouts.app')

@section('title', 'مدیریت زون‌های نمایش تبلیغات')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت زون‌های نمایش تبلیغات</h1>
        <div>
            <a href="{{ route('admin.ads.manage-zone-ads') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm mr-2">
                <i class="fas fa-list fa-sm text-white-50"></i> مدیریت آگهی‌های زون‌ها
            </a>
            <button class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" data-toggle="modal" data-target="#createZoneModal">
                <i class="fas fa-plus fa-sm text-white-50"></i> ایجاد زون جدید
            </button>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">لیست زون‌های نمایش تبلیغات</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>کلید زون</th>
                            <th>عنوان نمایشی</th>
                            <th>توضیحات</th>
                            <th>تعداد آگهی (دسکتاپ)</th>
                            <th>تعداد آگهی (موبایل)</th>
                            <th>نحوه نمایش</th>
                            <th>ترتیب نمایش</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($displayZones as $zone)
                            <tr>
                                <td>{{ $zone->zone_key }}</td>
                                <td>{{ $zone->zone_name }}</td>
                                <td>{{ Str::limit($zone->description, 50) }}</td>
                                <td>{{ $zone->max_desktop_cards }}</td>
                                <td>{{ $zone->max_mobile_cards }}</td>
                                <td>
                                    @if($zone->card_layout == 'carousel')
                                        <span class="badge badge-info">اسلایدر</span>
                                    @elseif($zone->card_layout == 'grid')
                                        <span class="badge badge-primary">شبکه‌ای</span>
                                    @else
                                        <span class="badge badge-secondary">{{ $zone->card_layout }}</span>
                                    @endif
                                </td>
                                <td>{{ $zone->display_order }}</td>
                                <td>
                                    @if($zone->is_active)
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-info edit-zone" 
                                        data-id="{{ $zone->id }}"
                                        data-key="{{ $zone->zone_key }}"
                                        data-title="{{ $zone->zone_name }}"
                                        data-description="{{ $zone->description }}"
                                        data-desktop="{{ $zone->max_desktop_cards }}"
                                        data-mobile="{{ $zone->max_mobile_cards }}"
                                        data-type="{{ $zone->card_layout }}"
                                        data-order="{{ $zone->display_order }}"
                                        data-active="{{ $zone->is_active }}"
                                        data-toggle="modal" data-target="#editZoneModal">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    
                                    <button class="btn btn-sm btn-danger delete-zone" 
                                        data-id="{{ $zone->id }}" 
                                        data-toggle="modal" data-target="#deleteZoneModal">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Create Zone Modal -->
<div class="modal fade" id="createZoneModal" tabindex="-1" role="dialog" aria-labelledby="createZoneModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createZoneModalLabel">ایجاد زون نمایش جدید</h5>
                <button type="button" class="close mr-auto ml-0" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('admin.ads.create-zone') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label for="zone_key">کلید زون <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="zone_key" name="zone_key" required 
                                   placeholder="مثال: home_featured" pattern="[a-z0-9_]+" 
                                   title="فقط حروف انگلیسی کوچک، اعداد و خط زیر مجاز است">
                            <small class="form-text text-muted">این کلید باید منحصر به فرد و فقط شامل حروف انگلیسی کوچک، اعداد و خط زیر باشد.</small>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="title">عنوان نمایشی <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" required
                                   placeholder="مثال: مکان‌های ویژه در صفحه اصلی">
                        </div>
                        
                        <div class="col-md-12 form-group">
                            <label for="description">توضیحات</label>
                            <textarea class="form-control" id="description" name="description" rows="3" 
                                      placeholder="توضیحات مختصر درباره این زون نمایش و کاربرد آن"></textarea>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="desktop_ad_count">تعداد آگهی در دسکتاپ <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="desktop_ad_count" name="desktop_ad_count" 
                                   required min="1" max="20" value="4">
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="mobile_ad_count">تعداد آگهی در موبایل <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="mobile_ad_count" name="mobile_ad_count" 
                                   required min="1" max="10" value="2">
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="display_type">نحوه نمایش <span class="text-danger">*</span></label>
                            <select class="form-control" id="display_type" name="display_type" required>
                                <option value="carousel">اسلایدر</option>
                                <option value="grid">شبکه‌ای</option>
                                <option value="banner">بنر</option>
                                <option value="list">لیستی</option>
                            </select>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="display_order">ترتیب نمایش <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="display_order" name="display_order" 
                                   required min="1" value="10">
                            <small class="form-text text-muted">زون‌ها به ترتیب صعودی نمایش داده می‌شوند.</small>
                        </div>
                        
                        <div class="col-md-12 form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" checked>
                                <label class="custom-control-label mr-3" for="is_active">زون فعال باشد</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">ذخیره زون</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Zone Modal -->
<div class="modal fade" id="editZoneModal" tabindex="-1" role="dialog" aria-labelledby="editZoneModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editZoneModalLabel">ویرایش زون نمایش</h5>
                <button type="button" class="close mr-auto ml-0" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('admin.ads.update-zone') }}" method="POST" id="editZoneForm">
                @csrf
                <input type="hidden" name="zone_id" id="edit_zone_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label for="edit_zone_key">کلید زون <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="edit_zone_key" name="zone_key" required 
                                   placeholder="مثال: home_featured" pattern="[a-z0-9_]+" 
                                   title="فقط حروف انگلیسی کوچک، اعداد و خط زیر مجاز است">
                            <small class="form-text text-muted">این کلید باید منحصر به فرد و فقط شامل حروف انگلیسی کوچک، اعداد و خط زیر باشد.</small>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="edit_title">عنوان نمایشی <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="edit_title" name="title" required
                                   placeholder="مثال: مکان‌های ویژه در صفحه اصلی">
                        </div>
                        
                        <div class="col-md-12 form-group">
                            <label for="edit_description">توضیحات</label>
                            <textarea class="form-control" id="edit_description" name="description" rows="3" 
                                      placeholder="توضیحات مختصر درباره این زون نمایش و کاربرد آن"></textarea>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="edit_desktop_ad_count">تعداد آگهی در دسکتاپ <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="edit_desktop_ad_count" name="desktop_ad_count" 
                                   required min="1" max="20">
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="edit_mobile_ad_count">تعداد آگهی در موبایل <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="edit_mobile_ad_count" name="mobile_ad_count" 
                                   required min="1" max="10">
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="edit_display_type">نحوه نمایش <span class="text-danger">*</span></label>
                            <select class="form-control" id="edit_display_type" name="display_type" required>
                                <option value="carousel">اسلایدر</option>
                                <option value="grid">شبکه‌ای</option>
                                <option value="banner">بنر</option>
                                <option value="list">لیستی</option>
                            </select>
                        </div>
                        
                        <div class="col-md-6 form-group">
                            <label for="edit_display_order">ترتیب نمایش <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="edit_display_order" name="display_order" 
                                   required min="1">
                            <small class="form-text text-muted">زون‌ها به ترتیب صعودی نمایش داده می‌شوند.</small>
                        </div>
                        
                        <div class="col-md-12 form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="edit_is_active" name="is_active" value="1">
                                <label class="custom-control-label mr-3" for="edit_is_active">زون فعال باشد</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">به‌روزرسانی زون</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Zone Modal -->
<div class="modal fade" id="deleteZoneModal" tabindex="-1" role="dialog" aria-labelledby="deleteZoneModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteZoneModalLabel">حذف زون نمایش</h5>
                <button type="button" class="close mr-auto ml-0" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>آیا از حذف این زون نمایش اطمینان دارید؟</p>
                <p class="text-danger">توجه: با حذف زون، ممکن است تبلیغات مربوط به آن نمایش داده نشوند.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                <form action="{{ route('admin.ads.delete-zone') }}" method="POST" id="deleteZoneForm">
                    @csrf
                    @method('DELETE')
                    <input type="hidden" name="zone_id" id="delete_zone_id">
                    <button type="submit" class="btn btn-danger">حذف زون</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.edit-zone').click(function() {
            var id = $(this).data('id');
            var key = $(this).data('key');
            var title = $(this).data('title');
            var description = $(this).data('description');
            var desktop = $(this).data('desktop');
            var mobile = $(this).data('mobile');
            var type = $(this).data('type');
            var order = $(this).data('order');
            var active = $(this).data('active');
            
            $('#edit_zone_id').val(id);
            $('#edit_zone_key').val(key);
            $('#edit_title').val(title);
            $('#edit_description').val(description);
            $('#edit_desktop_ad_count').val(desktop);
            $('#edit_mobile_ad_count').val(mobile);
            $('#edit_display_type').val(type);
            $('#edit_display_order').val(order);
            $('#edit_is_active').prop('checked', active == 1);
            
            $('#editZoneModal').modal('show');
        });
        
        $('.delete-zone').click(function() {
            var id = $(this).data('id');
            $('#delete_zone_id').val(id);
            $('#deleteZoneModal').modal('show');
        });
    });
</script>
@endpush 