@extends('admin.layouts.app')

@section('title', 'ویرایش نوع امکان')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">ویرایش نوع امکان</h1>
        <a href="{{ route('admin.amenity-types.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50 ml-2"></i> بازگشت به لیست
        </a>
    </div>

    <!-- Content Row -->
    <div class="row">
        <div class="col-xl-12 col-md-12 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">ویرایش اطلاعات نوع امکان</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.amenity-types.update', $amenityType->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="key">کلید <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('key') is-invalid @enderror" id="key" name="key" 
                                        value="{{ old('key', $amenityType->key) }}" placeholder="به عنوان مثال: wifi" required>
                                    <small class="form-text text-muted">کلید باید منحصر به فرد و بدون فاصله باشد (مانند: wifi, breakfast, pool)</small>
                                    @error('key')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">نام <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" 
                                        value="{{ old('name', $amenityType->name) }}" placeholder="به عنوان مثال: وای فای رایگان" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="section">بخش <span class="text-danger">*</span></label>
                                    <select class="form-control @error('section') is-invalid @enderror" id="section" name="section" required>
                                        <option value="">انتخاب کنید</option>
                                        <option value="key_info" {{ old('section', $amenityType->section) == 'key_info' ? 'selected' : '' }}>اطلاعات کلیدی</option>
                                        <option value="room_feature" {{ old('section', $amenityType->section) == 'room_feature' ? 'selected' : '' }}>ویژگی اتاق</option>
                                        <option value="hotel_facility" {{ old('section', $amenityType->section) == 'hotel_facility' ? 'selected' : '' }}>امکانات هتل</option>
                                    </select>
                                    @error('section')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="display_order">ترتیب نمایش</label>
                                    <input type="number" class="form-control @error('display_order') is-invalid @enderror" id="display_order" name="display_order" 
                                        value="{{ old('display_order', $amenityType->display_order) }}" placeholder="به عنوان مثال: 10">
                                    <small class="form-text text-muted">اختیاری - موارد با ترتیب کمتر، بالاتر نمایش داده می‌شوند</small>
                                    @error('display_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save ml-1"></i> بروزرسانی
                            </button>
                            <a href="{{ route('admin.amenity-types.index') }}" class="btn btn-secondary mr-2">انصراف</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 