@extends('admin.layouts.app')

@section('title', 'مقایسه زمانی داده‌ها')

@section('content')
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">مقایسه زمانی داده‌ها</h1>
    <div>
        <a href="{{ route('admin.analytics.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm ml-2">
            <i class="fas fa-chart-bar fa-sm text-white-50 ml-1"></i> بازگشت به داشبورد تحلیلی
        </a>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-success shadow-sm" id="printReport">
            <i class="fas fa-download fa-sm text-white-50 ml-1"></i> دریافت گزارش
        </a>
    </div>
</div>

<!-- Time Period Selection -->
<div class="row mb-4">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">انتخاب بازه‌های زمانی مقایسه</h6>
                <button class="btn btn-sm btn-primary" id="applyComparison">
                    <i class="fas fa-check fa-sm ml-1"></i>
                    اعمال مقایسه
                </button>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card border-left-primary">
                            <div class="card-body">
                                <h5 class="text-primary">بازه زمانی اول</h5>
                                <div class="form-group">
                                    <label for="period1Type">نوع بازه:</label>
                                    <select class="form-control" id="period1Type">
                                        <option value="preset">بازه از پیش تعیین شده</option>
                                        <option value="custom">بازه دلخواه</option>
                                    </select>
                                </div>
                                <div class="form-group period1-preset">
                                    <label for="period1Preset">بازه زمانی:</label>
                                    <select class="form-control" id="period1Preset">
                                        <option value="this_month">ماه جاری</option>
                                        <option value="last_month">ماه گذشته</option>
                                        <option value="this_quarter">فصل جاری</option>
                                        <option value="last_quarter">فصل گذشته</option>
                                        <option value="this_year">سال جاری</option>
                                        <option value="last_year">سال گذشته</option>
                                    </select>
                                </div>
                                <div class="form-group period1-custom" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="period1StartDate">از تاریخ:</label>
                                            <input type="date" class="form-control" id="period1StartDate">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="period1EndDate">تا تاریخ:</label>
                                            <input type="date" class="form-control" id="period1EndDate">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-left-success">
                            <div class="card-body">
                                <h5 class="text-success">بازه زمانی دوم</h5>
                                <div class="form-group">
                                    <label for="period2Type">نوع بازه:</label>
                                    <select class="form-control" id="period2Type">
                                        <option value="preset">بازه از پیش تعیین شده</option>
                                        <option value="custom">بازه دلخواه</option>
                                    </select>
                                </div>
                                <div class="form-group period2-preset">
                                    <label for="period2Preset">بازه زمانی:</label>
                                    <select class="form-control" id="period2Preset">
                                        <option value="this_month">ماه جاری</option>
                                        <option value="last_month" selected>ماه گذشته</option>
                                        <option value="this_quarter">فصل جاری</option>
                                        <option value="last_quarter">فصل گذشته</option>
                                        <option value="this_year">سال جاری</option>
                                        <option value="last_year">سال گذشته</option>
                                    </select>
                                </div>
                                <div class="form-group period2-custom" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="period2StartDate">از تاریخ:</label>
                                            <input type="date" class="form-control" id="period2StartDate">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="period2EndDate">تا تاریخ:</label>
                                            <input type="date" class="form-control" id="period2EndDate">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="metricsToCompare">شاخص‌های مورد مقایسه:</label>
                            <select multiple class="form-control" id="metricsToCompare" size="4">
                                <option value="locations" selected>تعداد مکان‌های جدید</option>
                                <option value="ratings" selected>تعداد نظرات</option>
                                <option value="avg_rating" selected>میانگین امتیازات</option>
                                <option value="active_locations">درصد مکان‌های فعال</option>
                                <option value="user_registrations">ثبت‌نام کاربران</option>
                                <option value="user_logins">ورود کاربران</option>
                                <option value="ad_views">نمایش تبلیغات</option>
                                <option value="ad_clicks">کلیک تبلیغات</option>
                            </select>
                            <small class="form-text text-muted">با نگه‌داشتن کلید Ctrl یا Shift می‌توانید چند گزینه را انتخاب کنید.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Comparison Results -->
<div class="row mb-4" id="comparisonResults" style="display: none;">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">نتایج مقایسه</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="comparisonTable">
                        <thead>
                            <tr>
                                <th>شاخص</th>
                                <th class="text-primary">بازه اول</th>
                                <th class="text-success">بازه دوم</th>
                                <th>تغییر</th>
                                <th>درصد تغییر</th>
                            </tr>
                        </thead>
                        <tbody id="comparisonTableBody">
                            <!-- Results will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Comparison Charts -->
<div class="row mb-4" id="comparisonCharts" style="display: none;">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">نمودار مقایسه‌ای</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">نوع نمودار:</div>
                        <a class="dropdown-item" href="#" id="viewAsBar">نمودار میله‌ای</a>
                        <a class="dropdown-item" href="#" id="viewAsLine">نمودار خطی</a>
                        <a class="dropdown-item" href="#" id="viewAsPie">نمودار دایره‌ای</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="exportChart">دریافت نمودار</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="comparisonChart"></canvas>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="font-weight-bold">مشخصات بازه اول:</h6>
                                <p id="period1Description" class="mb-0">-</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="font-weight-bold">مشخصات بازه دوم:</h6>
                                <p id="period2Description" class="mb-0">-</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Daily Distribution Comparison -->
<div class="row" id="dailyDistribution" style="display: none;">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">مقایسه توزیع روزانه داده‌ها</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="distributionChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">تحلیل توزیع زمانی:</h6>
                    <p>
                        این نمودار توزیع روزانه داده‌ها را در دو بازه زمانی انتخاب شده مقایسه می‌کند. 
                        با استفاده از این مقایسه می‌توانید الگوهای زمانی فعالیت کاربران را بهتر درک کنید.
                    </p>
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="card bg-primary text-white shadow">
                                <div class="card-body">
                                    روزهای اوج در بازه اول
                                    <div class="text-white-50" id="peakDaysPeriod1">-</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="card bg-success text-white shadow">
                                <div class="card-body">
                                    روزهای اوج در بازه دوم
                                    <div class="text-white-50" id="peakDaysPeriod2">-</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Smart Insights Based on Comparison -->
<div class="row" id="smartInsightsSection" style="display: none;">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">بینش‌های هوشمند مقایسه‌ای</h6>
                <button class="btn btn-sm btn-outline-primary" id="generateMoreComparisonInsights">
                    <i class="fas fa-magic fa-sm mr-1"></i> تولید بینش‌های بیشتر
                </button>
            </div>
            <div class="card-body">
                <div id="insightsContainer">
                    <!-- Insights will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.0/dist/chart.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Period type change handlers
        document.getElementById('period1Type').addEventListener('change', function() {
            togglePeriodFields(1, this.value);
        });
        
        document.getElementById('period2Type').addEventListener('change', function() {
            togglePeriodFields(2, this.value);
        });
        
        // Toggle period fields based on selection
        function togglePeriodFields(periodNum, type) {
            if (type === 'preset') {
                document.querySelector(`.period${periodNum}-preset`).style.display = 'block';
                document.querySelector(`.period${periodNum}-custom`).style.display = 'none';
            } else {
                document.querySelector(`.period${periodNum}-preset`).style.display = 'none';
                document.querySelector(`.period${periodNum}-custom`).style.display = 'block';
            }
        }
        
        // Apply Comparison Button
        document.getElementById('applyComparison').addEventListener('click', function() {
            // In a real application, this would make an AJAX call to get comparison data
            // For demo purposes, we'll simulate the data
            
            // Show result sections
            document.getElementById('comparisonResults').style.display = 'block';
            document.getElementById('comparisonCharts').style.display = 'block';
            document.getElementById('dailyDistribution').style.display = 'block';
            document.getElementById('smartInsightsSection').style.display = 'block';
            
            // Get selected periods
            const period1 = getPeriodDescription(1);
            const period2 = getPeriodDescription(2);
            
            // Update period descriptions
            document.getElementById('period1Description').textContent = period1;
            document.getElementById('period2Description').textContent = period2;
            
            // Populate data
            populateComparisonTable();
            createComparisonChart();
            createDistributionChart();
            generateSmartInsights();
            
            // Generate peak days data
            document.getElementById('peakDaysPeriod1').textContent = 'شنبه و یکشنبه با 25% بیشتر از میانگین';
            document.getElementById('peakDaysPeriod2').textContent = 'پنجشنبه و جمعه با 32% بیشتر از میانگین';
        });
        
        // Get period description
        function getPeriodDescription(periodNum) {
            const type = document.getElementById(`period${periodNum}Type`).value;
            
            if (type === 'preset') {
                const preset = document.getElementById(`period${periodNum}Preset`).value;
                switch (preset) {
                    case 'this_month': return 'ماه جاری';
                    case 'last_month': return 'ماه گذشته';
                    case 'this_quarter': return 'فصل جاری';
                    case 'last_quarter': return 'فصل گذشته';
                    case 'this_year': return 'سال جاری';
                    case 'last_year': return 'سال گذشته';
                    default: return preset;
                }
            } else {
                const startDate = document.getElementById(`period${periodNum}StartDate`).value;
                const endDate = document.getElementById(`period${periodNum}EndDate`).value;
                return `از ${startDate} تا ${endDate}`;
            }
        }
        
        // Populate comparison table
        function populateComparisonTable() {
            const tableBody = document.getElementById('comparisonTableBody');
            tableBody.innerHTML = '';
            
            // Get selected metrics
            const metrics = Array.from(document.getElementById('metricsToCompare').selectedOptions)
                .map(option => option.value);
            
            // Sample data - in a real app this would come from API
            const sampleData = {
                'locations': { period1: 450, period2: 380 },
                'ratings': { period1: 1250, period2: 980 },
                'avg_rating': { period1: 4.2, period2: 3.9 },
                'active_locations': { period1: 85, period2: 78 },
                'user_registrations': { period1: 320, period2: 280 },
                'user_logins': { period1: 1800, period2: 1500 },
                'ad_views': { period1: 25000, period2: 18000 },
                'ad_clicks': { period1: 750, period2: 500 }
            };
            
            const metricNames = {
                'locations': 'تعداد مکان‌های جدید',
                'ratings': 'تعداد نظرات',
                'avg_rating': 'میانگین امتیازات',
                'active_locations': 'درصد مکان‌های فعال',
                'user_registrations': 'ثبت‌نام کاربران',
                'user_logins': 'ورود کاربران',
                'ad_views': 'نمایش تبلیغات',
                'ad_clicks': 'کلیک تبلیغات'
            };
            
            metrics.forEach(metric => {
                const period1Value = sampleData[metric].period1;
                const period2Value = sampleData[metric].period2;
                const change = period1Value - period2Value;
                const percentChange = ((period1Value / period2Value) - 1) * 100;
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${metricNames[metric]}</td>
                    <td class="text-primary font-weight-bold">${formatValue(period1Value, metric)}</td>
                    <td class="text-success">${formatValue(period2Value, metric)}</td>
                    <td>${formatValue(change, metric)}</td>
                    <td class="${percentChange >= 0 ? 'text-success' : 'text-danger'}">
                        ${percentChange >= 0 ? '+' : ''}${percentChange.toFixed(2)}%
                        <i class="fas fa-${percentChange >= 0 ? 'arrow-up' : 'arrow-down'} fa-sm"></i>
                    </td>
                `;
                
                tableBody.appendChild(row);
            });
        }
        
        // Format value based on metric type
        function formatValue(value, metric) {
            if (metric === 'avg_rating') {
                return value.toFixed(1);
            } else if (metric === 'active_locations') {
                return value + '%';
            } else {
                return value.toLocaleString();
            }
        }
        
        // Create comparison chart
        function createComparisonChart() {
            const ctx = document.getElementById('comparisonChart');
            
            // If there's an existing chart, destroy it
            if (window.comparisonChart) {
                window.comparisonChart.destroy();
            }
            
            // Get selected metrics
            const metrics = Array.from(document.getElementById('metricsToCompare').selectedOptions)
                .map(option => option.value);
                
            const metricNames = {
                'locations': 'تعداد مکان‌ها',
                'ratings': 'تعداد نظرات',
                'avg_rating': 'میانگین امتیازات',
                'active_locations': 'درصد مکان‌های فعال',
                'user_registrations': 'ثبت‌نام کاربران',
                'user_logins': 'ورود کاربران',
                'ad_views': 'نمایش تبلیغات',
                'ad_clicks': 'کلیک تبلیغات'
            };
            
            // Sample data - in a real app this would come from API
            const sampleData = {
                'locations': { period1: 450, period2: 380 },
                'ratings': { period1: 1250, period2: 980 },
                'avg_rating': { period1: 4.2, period2: 3.9 },
                'active_locations': { period1: 85, period2: 78 },
                'user_registrations': { period1: 320, period2: 280 },
                'user_logins': { period1: 1800, period2: 1500 },
                'ad_views': { period1: 25000, period2: 18000 },
                'ad_clicks': { period1: 750, period2: 500 }
            };
            
            const labels = metrics.map(metric => metricNames[metric]);
            const period1Data = metrics.map(metric => sampleData[metric].period1);
            const period2Data = metrics.map(metric => sampleData[metric].period2);
            
            window.comparisonChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'بازه اول',
                            data: period1Data,
                            backgroundColor: 'rgba(78, 115, 223, 0.8)',
                            borderColor: 'rgba(78, 115, 223, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'بازه دوم',
                            data: period2Data,
                            backgroundColor: 'rgba(28, 200, 138, 0.8)',
                            borderColor: 'rgba(28, 200, 138, 1)',
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: 'top',
                            rtl: true
                        }
                    }
                }
            });
        }
        
        // Create distribution chart
        function createDistributionChart() {
            const ctx = document.getElementById('distributionChart');
            
            // If there's an existing chart, destroy it
            if (window.distributionChart) {
                window.distributionChart.destroy();
            }
            
            // Sample data for weekdays
            const weekdays = ['شنبه', 'یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنج‌شنبه', 'جمعه'];
            
            // Sample data - in a real app this would come from API
            const period1Data = [120, 135, 95, 85, 90, 105, 125];
            const period2Data = [85, 90, 75, 80, 95, 130, 145];
            
            window.distributionChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: weekdays,
                    datasets: [
                        {
                            label: 'بازه اول',
                            data: period1Data,
                            fill: false,
                            backgroundColor: 'rgba(78, 115, 223, 0.8)',
                            borderColor: 'rgba(78, 115, 223, 1)',
                            tension: 0.1
                        },
                        {
                            label: 'بازه دوم',
                            data: period2Data,
                            fill: false,
                            backgroundColor: 'rgba(28, 200, 138, 0.8)',
                            borderColor: 'rgba(28, 200, 138, 1)',
                            tension: 0.1
                        }
                    ]
                },
                options: {
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: 'top',
                            rtl: true
                        }
                    }
                }
            });
        }
        
        // Generate smart insights
        function generateSmartInsights() {
            const insightsContainer = document.getElementById('insightsContainer');
            insightsContainer.innerHTML = '';
            
            // Sample insights - in a real app these would be generated based on actual data comparison
            const insights = [
                {
                    type: 'primary',
                    icon: 'fas fa-chart-line',
                    title: 'رشد کلی',
                    content: 'در مقایسه بین دو بازه زمانی، رشد کلی 18.4% در تمامی شاخص‌های کلیدی مشاهده می‌شود.'
                },
                {
                    type: 'success',
                    icon: 'fas fa-thumbs-up',
                    title: 'بهبود عملکرد کاربران',
                    content: 'تعداد ورود کاربران در بازه اول 20% بیشتر از بازه دوم بوده است که نشان‌دهنده بهبود تعامل کاربران است.'
                },
                {
                    type: 'warning',
                    icon: 'fas fa-exclamation-triangle',
                    title: 'کاهش میانگین امتیازات',
                    content: 'میانگین امتیازات در بازه اول 7.7% کاهش نسبت به بازه دوم داشته است. بررسی علت کاهش کیفیت توصیه می‌شود.'
                },
                {
                    type: 'info',
                    icon: 'fas fa-calendar-alt',
                    title: 'تغییر الگوی زمانی',
                    content: 'الگوی فعالیت در روزهای هفته تغییر کرده است. در بازه اول شنبه و یکشنبه، اما در بازه دوم پنجشنبه و جمعه پرترافیک‌ترین روزها بوده‌اند.'
                }
            ];
            
            insights.forEach(insight => {
                const card = document.createElement('div');
                card.className = 'card bg-' + insight.type + ' text-white shadow mb-4';
                
                card.innerHTML = `
                    <div class="card-body">
                        <h5><i class="${insight.icon} mr-2"></i> ${insight.title}</h5>
                        <p class="mb-0">${insight.content}</p>
                    </div>
                `;
                
                insightsContainer.appendChild(card);
            });
        }
        
        // Chart type switchers
        document.getElementById('viewAsBar').addEventListener('click', function(e) {
            e.preventDefault();
            if (window.comparisonChart) {
                window.comparisonChart.config.type = 'bar';
                window.comparisonChart.update();
            }
        });
        
        document.getElementById('viewAsLine').addEventListener('click', function(e) {
            e.preventDefault();
            if (window.comparisonChart) {
                window.comparisonChart.config.type = 'line';
                window.comparisonChart.update();
            }
        });
        
        document.getElementById('viewAsPie').addEventListener('click', function(e) {
            e.preventDefault();
            if (window.comparisonChart) {
                // Pie charts work differently - they combine the first metric for both periods
                const firstMetric = document.getElementById('metricsToCompare').selectedOptions[0].value;
                const metricName = {
                    'locations': 'تعداد مکان‌ها',
                    'ratings': 'تعداد نظرات',
                    'avg_rating': 'میانگین امتیازات',
                    'active_locations': 'درصد مکان‌های فعال',
                    'user_registrations': 'ثبت‌نام کاربران',
                    'user_logins': 'ورود کاربران',
                    'ad_views': 'نمایش تبلیغات',
                    'ad_clicks': 'کلیک تبلیغات'
                }[firstMetric];
                
                window.comparisonChart.config.type = 'pie';
                window.comparisonChart.data.labels = ['بازه اول - ' + metricName, 'بازه دوم - ' + metricName];
                
                // Get the data for the first metric
                const sampleData = {
                    'locations': { period1: 450, period2: 380 },
                    'ratings': { period1: 1250, period2: 980 },
                    'avg_rating': { period1: 4.2, period2: 3.9 },
                    'active_locations': { period1: 85, period2: 78 },
                    'user_registrations': { period1: 320, period2: 280 },
                    'user_logins': { period1: 1800, period2: 1500 },
                    'ad_views': { period1: 25000, period2: 18000 },
                    'ad_clicks': { period1: 750, period2: 500 }
                };
                
                window.comparisonChart.data.datasets = [{
                    data: [sampleData[firstMetric].period1, sampleData[firstMetric].period2],
                    backgroundColor: ['rgba(78, 115, 223, 0.8)', 'rgba(28, 200, 138, 0.8)'],
                    borderColor: ['rgba(78, 115, 223, 1)', 'rgba(28, 200, 138, 1)'],
                    borderWidth: 1
                }];
                
                window.comparisonChart.update();
            }
        });
        
        // Export chart
        document.getElementById('exportChart').addEventListener('click', function(e) {
            e.preventDefault();
            if (window.comparisonChart) {
                const link = document.createElement('a');
                link.download = 'comparison-chart.png';
                link.href = window.comparisonChart.toBase64Image();
                link.click();
            }
        });
        
        // Print report
        document.getElementById('printReport').addEventListener('click', function(e) {
            e.preventDefault();
            window.print();
        });
        
        // Generate more insights
        document.getElementById('generateMoreComparisonInsights').addEventListener('click', function(e) {
            e.preventDefault();
            this.disabled = true;
            this.innerHTML = '<i class="fas fa-spinner fa-spin fa-sm mr-1"></i> در حال تولید...';
            
            // Simulate processing
            setTimeout(() => {
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-magic fa-sm mr-1"></i> تولید بینش‌های بیشتر';
                
                // Add a new insight
                const insightsContainer = document.getElementById('insightsContainer');
                
                const newInsight = document.createElement('div');
                newInsight.className = 'card bg-dark text-white shadow mb-4';
                
                newInsight.innerHTML = `
                    <div class="card-body">
                        <h5><i class="fas fa-lightbulb mr-2"></i> تحلیل عمیق‌تر</h5>
                        <p class="mb-0">
                            مقایسه نسبت نمایش به کلیک تبلیغات در دو بازه نشان می‌دهد که نرخ تبدیل در بازه اول 3% و در بازه دوم 2.8% بوده است.
                            این بهبود احتمالاً به دلیل تغییرات در طراحی رابط کاربری صفحات تبلیغات و بهینه‌سازی محتوای تبلیغات است.
                        </p>
                    </div>
                `;
                
                insightsContainer.appendChild(newInsight);
                
                // Scroll to the new insight
                newInsight.scrollIntoView({ behavior: 'smooth' });
            }, 2000);
        });
    });
</script>
@endsection

@section('styles')
<style>
    .chart-area {
        position: relative;
        height: 300px;
    }
    
    .card {
        transition: transform 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-5px);
    }
    
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            break-inside: avoid;
            border: 1px solid #ddd !important;
            box-shadow: none !important;
        }
        .chart-area {
            height: 200px !important;
        }
    }
</style>
@endsection 