<div class="tab-pane fade" id="demographicsAnalysis" role="tabpanel">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h5 class="card-title">تحلیل جمعیت‌شناختی کاربران</h5>
        <div class="btn-group">
            <button type="button" class="btn btn-sm btn-outline-primary active" data-demographics-chart="age">سن</button>
            <button type="button" class="btn btn-sm btn-outline-primary" data-demographics-chart="gender">جنسیت</button>
            <button type="button" class="btn btn-sm btn-outline-primary" data-demographics-chart="education">تحصیلات</button>
        </div>
    </div>
    
    <div class="row">
        <!-- Age Distribution -->
        <div class="col-md-8 mb-4 demographics-chart" id="age-chart-container" data-chart-type="age">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">توزیع سنی کاربران</h6>
                    <div id="age-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 demographics-chart" id="age-stats-container" data-chart-type="age">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">آمار سنی</h6>
                    <div id="age-stats" class="stats-list">
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>میانگین سنی:</span>
                                <strong>32.5 سال</strong>
                            </div>
                        </div>
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>بیشترین گروه سنی:</span>
                                <strong>25-34 سال (38.2%)</strong>
                            </div>
                        </div>
                        <div class="alert alert-success mb-2">
                            <div class="d-flex justify-content-between">
                                <span>رشد گروه سنی 18-24:</span>
                                <strong>+5.3% نسبت به ماه قبل</strong>
                            </div>
                        </div>
                        <div class="alert alert-warning mb-2">
                            <div class="d-flex justify-content-between">
                                <span>کاهش گروه سنی 55+:</span>
                                <strong>-2.1% نسبت به ماه قبل</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Gender Distribution -->
        <div class="col-md-8 mb-4 demographics-chart d-none" id="gender-chart-container" data-chart-type="gender">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">توزیع جنسیتی کاربران</h6>
                    <div id="gender-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 demographics-chart d-none" id="gender-stats-container" data-chart-type="gender">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">آمار جنسیتی</h6>
                    <div id="gender-stats" class="stats-list">
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>کاربران مرد:</span>
                                <strong>62.3%</strong>
                            </div>
                        </div>
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>کاربران زن:</span>
                                <strong>37.7%</strong>
                            </div>
                        </div>
                        <div class="alert alert-success mb-2">
                            <div class="d-flex justify-content-between">
                                <span>رشد کاربران زن:</span>
                                <strong>+3.8% نسبت به ماه قبل</strong>
                            </div>
                        </div>
                        <div class="alert alert-warning mb-2">
                            <div class="d-flex justify-content-between">
                                <span>تغییر نسبت جنسیتی:</span>
                                <strong>تمایل به تعادل</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Education Distribution -->
        <div class="col-md-8 mb-4 demographics-chart d-none" id="education-chart-container" data-chart-type="education">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">توزیع سطح تحصیلات کاربران</h6>
                    <div id="education-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 demographics-chart d-none" id="education-stats-container" data-chart-type="education">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">آمار تحصیلات</h6>
                    <div id="education-stats" class="stats-list">
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>بیشترین سطح تحصیلات:</span>
                                <strong>کارشناسی (35.7%)</strong>
                            </div>
                        </div>
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>کاربران با تحصیلات دانشگاهی:</span>
                                <strong>78.3%</strong>
                            </div>
                        </div>
                        <div class="alert alert-success mb-2">
                            <div class="d-flex justify-content-between">
                                <span>رشد کاربران با تحصیلات دکترا:</span>
                                <strong>+2.5% نسبت به ماه قبل</strong>
                            </div>
                        </div>
                        <div class="alert alert-warning mb-2">
                            <div class="d-flex justify-content-between">
                                <span>کاهش کاربران با تحصیلات دیپلم:</span>
                                <strong>-1.8% نسبت به ماه قبل</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Comparative Analysis Row -->
    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">تحلیل تطبیقی جمعیت‌شناختی</h6>
                    <div id="demographics-comparative" class="comparative-container">
                        <div class="alert alert-primary">
                            <strong><i class="fas fa-chart-pie"></i> تحلیل توزیع جمعیت‌شناختی کاربران</strong>
                            <p class="mt-2 mb-0">
                                با مقایسه داده‌های جمعیت‌شناختی کاربران سایت با آمار جمعیتی کشور، مشخص می‌شود که سایت شما جذابیت بیشتری برای گروه سنی 25-34 سال و افراد با تحصیلات دانشگاهی دارد. همچنین نسبت کاربران مرد به زن بیشتر از نسبت جمعیتی کشور است. این اطلاعات می‌تواند برای بهینه‌سازی استراتژی‌های بازاریابی و محتوای سایت مورد استفاده قرار گیرد.
                            </p>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body py-2">
                                        <h6 class="text-center">سن <small>(نسبت به آمار کشوری)</small></h6>
                                        <div class="d-flex justify-content-around">
                                            <div class="text-center">
                                                <span class="badge badge-success">18-24</span>
                                                <div>+8.2%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-success">25-34</span>
                                                <div>+12.5%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-warning">35-44</span>
                                                <div>-3.1%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-danger">45+</span>
                                                <div>-17.6%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body py-2">
                                        <h6 class="text-center">جنسیت <small>(نسبت به آمار کشوری)</small></h6>
                                        <div class="d-flex justify-content-around">
                                            <div class="text-center">
                                                <span class="badge badge-primary">مرد</span>
                                                <div>+11.5%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-danger">زن</span>
                                                <div>-11.5%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body py-2">
                                        <h6 class="text-center">تحصیلات <small>(نسبت به آمار کشوری)</small></h6>
                                        <div class="d-flex justify-content-around">
                                            <div class="text-center">
                                                <span class="badge badge-danger">دیپلم</span>
                                                <div>-18.2%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-success">لیسانس</span>
                                                <div>+10.3%</div>
                                            </div>
                                            <div class="text-center">
                                                <span class="badge badge-success">ارشد+</span>
                                                <div>+7.9%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle between different demographics chart types
    document.querySelectorAll('[data-demographics-chart]').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('[data-demographics-chart]').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Add active class to clicked button
            this.classList.add('active');
            
            // Hide all chart containers
            document.querySelectorAll('.demographics-chart').forEach(container => {
                container.classList.add('d-none');
            });
            
            // Show the selected chart containers
            const chartType = this.getAttribute('data-demographics-chart');
            document.querySelectorAll(`[data-chart-type="${chartType}"]`).forEach(container => {
                container.classList.remove('d-none');
            });
            
            // Initialize or refresh the visible charts
            initDemographicsCharts(chartType);
        });
    });
    
    // Initialize the default age charts on page load
    initDemographicsCharts('age');
});

function initDemographicsCharts(chartType) {
    if (chartType === 'age') {
        renderAgeChart();
    } else if (chartType === 'gender') {
        renderGenderChart();
    } else if (chartType === 'education') {
        renderEducationChart();
    }
}

function renderAgeChart() {
    // Sample data for age distribution - in a real app, this would come from the server
    const ageData = [
        { age: '18-24', count: 21.5 },
        { age: '25-34', count: 38.2 },
        { age: '35-44', count: 23.7 },
        { age: '45-54', count: 10.3 },
        { age: '55+', count: 6.3 }
    ];
    
    const options = {
        series: [{
            name: 'درصد کاربران',
            data: ageData.map(item => item.count)
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                columnWidth: '60%',
                distributed: true,
                dataLabels: {
                    position: 'top'
                }
            }
        },
        colors: ['#33b2df', '#546E7A', '#d4526e', '#13d8aa', '#A5978B'],
        dataLabels: {
            enabled: true,
            formatter: function(val) {
                return val + '%';
            },
            offsetY: -20,
            style: {
                fontSize: '12px',
                colors: ['#304758']
            }
        },
        legend: {
            show: false
        },
        xaxis: {
            categories: ageData.map(item => item.age),
            labels: {
                style: {
                    fontSize: '12px'
                }
            }
        },
        yaxis: {
            max: 50,
            labels: {
                formatter: function(val) {
                    return val + '%';
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    const chart = new ApexCharts(document.querySelector("#age-chart"), options);
    chart.render();
}

function renderGenderChart() {
    // Sample data for gender distribution - in a real app, this would come from the server
    const genderData = [
        { gender: 'مرد', count: 62.3 },
        { gender: 'زن', count: 37.7 }
    ];
    
    const options = {
        series: genderData.map(item => item.count),
        chart: {
            type: 'donut',
            height: 350,
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
        },
        labels: genderData.map(item => item.gender),
        colors: ['#2E93fA', '#FF4560'],
        plotOptions: {
            pie: {
                donut: {
                    size: '55%',
                    labels: {
                        show: true,
                        total: {
                            show: true,
                            label: 'مجموع',
                            formatter: function(w) {
                                return '100%';
                            }
                        }
                    }
                }
            }
        },
        dataLabels: {
            enabled: true,
            formatter: function(val) {
                return val.toFixed(1) + '%';
            }
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 300
                },
                legend: {
                    position: 'bottom'
                }
            }
        }],
        legend: {
            position: 'bottom',
            formatter: function(val, opts) {
                return val + ' - ' + opts.w.globals.series[opts.seriesIndex] + '%';
            }
        }
    };

    const chart = new ApexCharts(document.querySelector("#gender-chart"), options);
    chart.render();
}

function renderEducationChart() {
    // Sample data for education distribution - in a real app, this would come from the server
    const educationData = [
        { education: 'زیر دیپلم', count: 5.2 },
        { education: 'دیپلم', count: 16.5 },
        { education: 'کاردانی', count: 8.7 },
        { education: 'کارشناسی', count: 35.7 },
        { education: 'کارشناسی ارشد', count: 26.3 },
        { education: 'دکترا', count: 7.6 }
    ];
    
    const options = {
        series: [{
            name: 'درصد کاربران',
            data: educationData.map(item => item.count)
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                columnWidth: '50%',
                distributed: true,
                dataLabels: {
                    position: 'top'
                }
            }
        },
        colors: ['#008FFB', '#00E396', '#FEB019', '#FF4560', '#775DD0', '#546E7A'],
        dataLabels: {
            enabled: true,
            formatter: function(val) {
                return val + '%';
            },
            offsetY: -20,
            style: {
                fontSize: '12px',
                colors: ['#304758']
            }
        },
        legend: {
            show: false
        },
        xaxis: {
            categories: educationData.map(item => item.education),
            labels: {
                style: {
                    fontSize: '12px'
                }
            }
        },
        yaxis: {
            max: 50,
            labels: {
                formatter: function(val) {
                    return val + '%';
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    const chart = new ApexCharts(document.querySelector("#education-chart"), options);
    chart.render();
}
</script> 