<div class="tab-pane fade show active" id="timeAnalysis" role="tabpanel">
    <!-- Enhanced Header Section -->
    <div class="time-header-section mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="time-title-wrapper">
                    <h4 class="time-main-title">
                        <i class="fas fa-clock text-info me-2"></i>
                        تحلیل زمانی و روندها
                    </h4>
                    <p class="time-subtitle text-muted mb-0">
                        بررسی الگوهای زمانی فعالیت‌ها و پیش‌بینی روندهای آینده
                    </p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="time-controls d-flex justify-content-end">
                    <div class="btn-group time-toggle-group me-2" role="group">
                        <button type="button" class="btn btn-outline-primary active" data-time-filter="daily">
                            <i class="fas fa-calendar-day me-1"></i>
                            روزانه
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-time-filter="weekly">
                            <i class="fas fa-calendar-week me-1"></i>
                            هفتگی
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-time-filter="monthly">
                            <i class="fas fa-calendar-alt me-1"></i>
                            ماهانه
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-time-filter="yearly">
                            <i class="fas fa-calendar me-1"></i>
                            سالانه
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-time-filter="realtime">
                            <i class="fas fa-broadcast-tower me-1"></i>
                            لحظه‌ای
                        </button>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog me-1"></i>
                            تنظیمات
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="refreshTimeData()">
                                <i class="fas fa-sync-alt me-2"></i>بروزرسانی داده‌ها
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="exportTimeData('excel')">
                                <i class="fas fa-file-excel me-2"></i>خروجی Excel
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="exportTimeData('pdf')">
                                <i class="fas fa-file-pdf me-2"></i>گزارش PDF
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="#" onclick="showTimeFilters()">
                                <i class="fas fa-filter me-2"></i>فیلترهای پیشرفته
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="showTimePredictions()">
                                <i class="fas fa-crystal-ball me-2"></i>پیش‌بینی‌های هوشمند
                            </a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Time Overview Cards -->
    <div class="time-overview-section mb-4">
        <div class="row">
            <div class="col-md-3">
                <div class="time-overview-card">
                    <div class="card-icon bg-primary">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value">{{ $timeStats['best_day']['name'] ?? 'شنبه' }}</div>
                        <div class="card-label">بهترین روز هفته</div>
                        <div class="card-trend positive">
                            <i class="fas fa-arrow-up me-1"></i>
                            {{ $timeStats['best_day']['count'] ?? 25 }} مکان
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="time-overview-card">
                    <div class="card-icon bg-success">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value">{{ $timeStats['avg_growth'] ?? 15 }}%</div>
                        <div class="card-label">رشد ماهانه</div>
                        <div class="card-trend {{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'arrow-up' : 'arrow-down' }} me-1"></i>
                            {{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'در حال افزایش' : 'در حال کاهش' }}
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="time-overview-card">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value">{{ $timeStats['peak_hour'] ?? '14:00' }}</div>
                        <div class="card-label">ساعت اوج فعالیت</div>
                        <div class="card-detail">بیشترین ثبت مکان</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="time-overview-card">
                    <div class="card-icon bg-info">
                        <i class="fas fa-crystal-ball"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value">{{ ($timeStats['next_month_prediction'] ?? 0) > 0 ? '+' : '' }}{{ $timeStats['next_month_prediction'] ?? 8 }}%</div>
                        <div class="card-label">پیش‌بینی ماه آینده</div>
                        <div class="card-trend {{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'trending-up' : 'trending-down' }} me-1"></i>
                            {{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'روند مثبت' : 'روند منفی' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Charts Section -->
    <div class="row time-analysis-container">
        <!-- Daily Analysis Chart -->
        <div class="col-lg-8 time-chart" id="dailyAnalysis">
            <div class="card time-chart-card">
                <div class="card-header bg-gradient-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0 text-white">
                            <i class="fas fa-calendar-day me-2"></i>
                            تحلیل روزانه (30 روز گذشته)
                        </h5>
                        <div class="chart-actions">
                            <button class="btn btn-sm btn-outline-light" onclick="refreshChart('daily')" title="بروزرسانی">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="fullscreenChart('dailyChart')" title="تمام صفحه">
                                <i class="fas fa-expand"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="downloadChart('dailyChart')" title="دانلود">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container position-relative">
                        <div class="chart-loading d-none">
                            <div class="d-flex justify-content-center align-items-center h-100">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">در حال بارگذاری...</span>
                                </div>
                            </div>
                        </div>
                        <div id="dailyChart"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Daily Statistics Panel -->
        <div class="col-lg-4 time-chart" id="dailyStats">
            <div class="card time-stats-card">
                <div class="card-header bg-gradient-info text-white">
                    <h5 class="card-title mb-0 text-white">
                        <i class="fas fa-chart-bar me-2"></i>
                        آمار تفصیلی روزانه
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Peak Activity Display -->
                    <div class="peak-activity-display text-center mb-4">
                        <div class="activity-circle">
                            <div class="activity-value">{{ $timeStats['peak_day_count'] ?? 42 }}</div>
                            <div class="activity-label">مکان</div>
                        </div>
                        <div class="activity-description">
                            <div class="activity-title">بیشترین فعالیت روزانه</div>
                            <div class="activity-date">{{ $timeStats['peak_day_date'] ?? 'دیروز' }}</div>
                        </div>
                    </div>

                    <!-- Daily Breakdown -->
                    <div class="daily-breakdown-section">
                        <h6 class="breakdown-title">آمار هفته جاری</h6>
                        <div class="daily-breakdown-list">
                            @php
                                $weekDays = ['شنبه', 'یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنج‌شنبه', 'جمعه'];
                                $weekCounts = [12, 8, 15, 22, 18, 6, 4]; // نمونه داده
                                $maxCount = max($weekCounts);
                            @endphp
                            @foreach($weekDays as $index => $day)
                                @php
                                    $count = $weekCounts[$index];
                                    $percent = $maxCount > 0 ? ($count / $maxCount) * 100 : 0;
                                    $dayColor = $index == 0 ? 'text-primary' : ($index == 6 ? 'text-danger' : 'text-success');
                                @endphp
                                <div class="daily-breakdown-item">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <div class="day-label">
                                            <span class="day-name {{ $dayColor }}">{{ $day }}</span>
                                        </div>
                                        <div class="day-stats">
                                            <span class="day-count-badge">{{ $count }}</span>
                                            <span class="day-percent">{{ round($percent, 1) }}%</span>
                                        </div>
                                    </div>
                                    <div class="day-progress-wrapper">
                                        <div class="progress day-progress" style="height: 6px;">
                                            <div class="progress-bar {{ $index == 0 ? 'bg-primary' : ($index == 6 ? 'bg-danger' : 'bg-success') }}"
                                                 role="progressbar"
                                                 style="width: {{ $percent }}%"
                                                 aria-valuenow="{{ $percent }}"
                                                 aria-valuemin="0"
                                                 aria-valuemax="100">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Daily Insights -->
                    <div class="daily-insights mt-4">
                        <h6 class="insights-title">تحلیل سریع</h6>
                        <div class="insights-grid">
                            <div class="insight-item">
                                <div class="insight-icon bg-success">
                                    <i class="fas fa-arrow-up"></i>
                                </div>
                                <div class="insight-content">
                                    <div class="insight-value">+23%</div>
                                    <div class="insight-label">رشد هفتگی</div>
                                </div>
                            </div>
                            <div class="insight-item">
                                <div class="insight-icon bg-warning">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div class="insight-content">
                                    <div class="insight-value">14:30</div>
                                    <div class="insight-label">اوج فعالیت</div>
                                </div>
                            </div>
                            <div class="insight-item">
                                <div class="insight-icon bg-info">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <div class="insight-content">
                                    <div class="insight-value">{{ $weekDays[array_search(max($weekCounts), $weekCounts)] }}</div>
                                    <div class="insight-label">بهترین روز</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Weekly Analysis Chart -->
        <div class="col-12 time-chart" id="weeklyAnalysis" style="display: none;">
            <div class="card time-chart-card">
                <div class="card-header bg-gradient-success text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0 text-white">
                            <i class="fas fa-calendar-week me-2"></i>
                            تحلیل هفتگی (12 هفته گذشته)
                        </h5>
                        <div class="chart-actions">
                            <button class="btn btn-sm btn-outline-light" onclick="refreshChart('weekly')" title="بروزرسانی">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="fullscreenChart('weeklyChart')" title="تمام صفحه">
                                <i class="fas fa-expand"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="downloadChart('weeklyChart')" title="دانلود">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container position-relative">
                        <div class="chart-loading d-none">
                            <div class="d-flex justify-content-center align-items-center h-100">
                                <div class="spinner-border text-success" role="status">
                                    <span class="visually-hidden">در حال بارگذاری...</span>
                                </div>
                            </div>
                        </div>
                        <div id="weeklyChart"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Analysis Chart -->
        <div class="col-12 time-chart" id="monthlyAnalysis" style="display: none;">
            <div class="card time-chart-card">
                <div class="card-header bg-gradient-warning text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0 text-white">
                            <i class="fas fa-calendar-alt me-2"></i>
                            تحلیل ماهانه (12 ماه گذشته)
                        </h5>
                        <div class="chart-actions">
                            <button class="btn btn-sm btn-outline-light" onclick="refreshChart('monthly')" title="بروزرسانی">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="fullscreenChart('monthlyChart')" title="تمام صفحه">
                                <i class="fas fa-expand"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="downloadChart('monthlyChart')" title="دانلود">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container position-relative">
                        <div class="chart-loading d-none">
                            <div class="d-flex justify-content-center align-items-center h-100">
                                <div class="spinner-border text-warning" role="status">
                                    <span class="visually-hidden">در حال بارگذاری...</span>
                                </div>
                            </div>
                        </div>
                        <div id="monthlyChart"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Yearly Analysis Chart -->
        <div class="col-12 time-chart" id="yearlyAnalysis" style="display: none;">
            <div class="card time-chart-card">
                <div class="card-header bg-gradient-danger text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0 text-white">
                            <i class="fas fa-calendar me-2"></i>
                            تحلیل سالانه (5 سال گذشته)
                        </h5>
                        <div class="chart-actions">
                            <button class="btn btn-sm btn-outline-light" onclick="refreshChart('yearly')" title="بروزرسانی">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="fullscreenChart('yearlyChart')" title="تمام صفحه">
                                <i class="fas fa-expand"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="downloadChart('yearlyChart')" title="دانلود">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container position-relative">
                        <div class="chart-loading d-none">
                            <div class="d-flex justify-content-center align-items-center h-100">
                                <div class="spinner-border text-danger" role="status">
                                    <span class="visually-hidden">در حال بارگذاری...</span>
                                </div>
                            </div>
                        </div>
                        <div id="yearlyChart"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Real-time Analysis Chart -->
        <div class="col-12 time-chart" id="realtimeAnalysis" style="display: none;">
            <div class="card time-chart-card">
                <div class="card-header bg-gradient-dark text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0 text-white">
                            <i class="fas fa-broadcast-tower me-2"></i>
                            تحلیل لحظه‌ای
                            <span class="badge bg-success ms-2 pulse">زنده</span>
                        </h5>
                        <div class="chart-actions">
                            <button class="btn btn-sm btn-outline-light" onclick="toggleRealtime()" title="توقف/شروع">
                                <i class="fas fa-pause" id="realtimeToggle"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="fullscreenChart('realtimeChart')" title="تمام صفحه">
                                <i class="fas fa-expand"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-light" onclick="downloadChart('realtimeChart')" title="دانلود">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container position-relative">
                        <div class="realtime-info mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted">
                                    <i class="fas fa-clock me-1"></i>
                                    آخرین بروزرسانی: <span data-realtime="last_update">{{ now()->format('H:i:s') }}</span>
                                </small>
                                <small class="text-success">
                                    <i class="fas fa-circle pulse me-1"></i>
                                    زنده
                                </small>
                            </div>
                            <div class="row text-center">
                                <div class="col-3">
                                    <div class="realtime-metric">
                                        <div class="metric-value text-success" data-realtime="active_users">{{ $timeframeAnalytics['realtime']['stats']['active_users'] ?? 24 }}</div>
                                        <div class="metric-label">کاربر آنلاین</div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="realtime-metric">
                                        <div class="metric-value text-primary" data-realtime="today_locations">{{ $timeframeAnalytics['realtime']['stats']['today_views'] ?? 156 }}</div>
                                        <div class="metric-label">بازدید امروز</div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="realtime-metric">
                                        <div class="metric-value text-warning" data-realtime="new_locations">{{ $timeframeAnalytics['realtime']['stats']['new_locations_today'] ?? 3 }}</div>
                                        <div class="metric-label">مکان جدید</div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="realtime-metric">
                                        <div class="metric-value text-info" data-realtime="hourly_avg">{{ $timeframeAnalytics['realtime']['stats']['hourly_average'] ?? 2.4 }}</div>
                                        <div class="metric-label">میانگین ساعتی</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="realtimeChart"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Time Statistics Section -->
    <div class="time-statistics-section mt-4">
        <div class="card time-stats-summary-card">
            <div class="card-header bg-gradient-secondary text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0 text-white">
                        <i class="fas fa-chart-area me-2"></i>
                        خلاصه آمار زمانی
                    </h5>
                    <div class="stats-actions">
                        <button class="btn btn-sm btn-outline-light" onclick="exportTimeStats()" title="خروجی آمار">
                            <i class="fas fa-file-export"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-light" onclick="refreshTimeStats()" title="بروزرسانی">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    @if(isset($timeStats) && !empty($timeStats))
                        <!-- Best Performance Metrics -->
                        <div class="col-lg-6">
                            <div class="performance-metrics">
                                <h6 class="metrics-title">بهترین عملکردها</h6>
                                <div class="metrics-grid">
                                    <div class="metric-card best-day">
                                        <div class="metric-icon">
                                            <i class="fas fa-calendar-day"></i>
                                        </div>
                                        <div class="metric-content">
                                            <div class="metric-label">بهترین روز هفته</div>
                                            <div class="metric-value">{{ $timeStats['best_day']['name'] ?? 'سه‌شنبه' }}</div>
                                            <div class="metric-detail">
                                                <i class="fas fa-arrow-up text-success me-1"></i>
                                                {{ $timeStats['best_day']['count'] ?? 28 }} مکان ثبت شده
                                            </div>
                                        </div>
                                    </div>

                                    <div class="metric-card best-month">
                                        <div class="metric-icon">
                                            <i class="fas fa-calendar-alt"></i>
                                        </div>
                                        <div class="metric-content">
                                            <div class="metric-label">بهترین ماه</div>
                                            <div class="metric-value">{{ $timeStats['best_month']['name'] ?? 'فروردین' }}</div>
                                            <div class="metric-detail">
                                                <i class="fas fa-arrow-up text-success me-1"></i>
                                                {{ $timeStats['best_month']['count'] ?? 156 }} مکان ثبت شده
                                            </div>
                                        </div>
                                    </div>

                                    <div class="metric-card peak-hour">
                                        <div class="metric-icon">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                        <div class="metric-content">
                                            <div class="metric-label">ساعت اوج فعالیت</div>
                                            <div class="metric-value">{{ $timeStats['peak_hour'] ?? '14:30' }}</div>
                                            <div class="metric-detail">
                                                <i class="fas fa-chart-line text-info me-1"></i>
                                                بیشترین ثبت مکان
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Growth & Predictions -->
                        <div class="col-lg-6">
                            <div class="growth-predictions">
                                <h6 class="metrics-title">رشد و پیش‌بینی‌ها</h6>
                                <div class="predictions-grid">
                                    <div class="prediction-card monthly-growth">
                                        <div class="prediction-header">
                                            <div class="prediction-icon bg-success">
                                                <i class="fas fa-chart-line"></i>
                                            </div>
                                            <div class="prediction-info">
                                                <div class="prediction-label">رشد ماهانه</div>
                                                <div class="prediction-value">{{ $timeStats['avg_growth'] ?? 15 }}%</div>
                                            </div>
                                        </div>
                                        <div class="prediction-trend {{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'positive' : 'negative' }}">
                                            <i class="fas fa-{{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'trending-up' : 'trending-down' }} me-1"></i>
                                            {{ ($timeStats['growth_trend'] ?? 1) > 0 ? 'روند صعودی' : 'روند نزولی' }}
                                        </div>
                                        <div class="prediction-progress">
                                            <div class="progress">
                                                <div class="progress-bar bg-success" style="width: {{ min(abs($timeStats['avg_growth'] ?? 15), 100) }}%"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="prediction-card next-month">
                                        <div class="prediction-header">
                                            <div class="prediction-icon bg-info">
                                                <i class="fas fa-crystal-ball"></i>
                                            </div>
                                            <div class="prediction-info">
                                                <div class="prediction-label">پیش‌بینی ماه آینده</div>
                                                <div class="prediction-value">{{ ($timeStats['next_month_prediction'] ?? 0) > 0 ? '+' : '' }}{{ $timeStats['next_month_prediction'] ?? 8 }}%</div>
                                            </div>
                                        </div>
                                        <div class="prediction-trend {{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'positive' : 'negative' }}">
                                            <i class="fas fa-{{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'arrow-up' : 'arrow-down' }} me-1"></i>
                                            {{ ($timeStats['next_month_prediction'] ?? 8) > 0 ? 'انتظار رشد' : 'انتظار کاهش' }}
                                        </div>
                                        <div class="prediction-confidence">
                                            <span class="confidence-label">اعتماد پیش‌بینی:</span>
                                            <span class="confidence-value">{{ $timeStats['prediction_confidence'] ?? 85 }}%</span>
                                        </div>
                                    </div>

                                    <div class="prediction-card seasonal">
                                        <div class="prediction-header">
                                            <div class="prediction-icon bg-warning">
                                                <i class="fas fa-leaf"></i>
                                            </div>
                                            <div class="prediction-info">
                                                <div class="prediction-label">تحلیل فصلی</div>
                                                <div class="prediction-value">{{ $timeStats['seasonal_trend'] ?? 'بهار' }}</div>
                                            </div>
                                        </div>
                                        <div class="seasonal-info">
                                            <div class="seasonal-detail">
                                                <i class="fas fa-info-circle text-info me-1"></i>
                                                فصل پرفعالیت
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="col-12">
                            <div class="empty-stats text-center py-5">
                                <i class="fas fa-chart-line text-muted" style="font-size: 3rem;"></i>
                                <h6 class="mt-3 text-muted">اطلاعات آماری در دسترس نیست</h6>
                                <p class="text-muted">لطفاً بعداً مراجعه کنید یا داده‌ها را بروزرسانی کنید</p>
                                <button class="btn btn-primary" onclick="refreshTimeStats()">
                                    <i class="fas fa-sync-alt me-2"></i>
                                    بروزرسانی داده‌ها
                                </button>
                            </div>
                        </div>
                    @endif
                </div>

                @if(isset($timeStats) && !empty($timeStats))
                    <!-- Additional Insights -->
                    <div class="additional-insights mt-4">
                        <h6 class="insights-title">بینش‌های اضافی</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="insight-box">
                                    <div class="insight-header">
                                        <i class="fas fa-users text-primary"></i>
                                        <span>الگوی کاربری</span>
                                    </div>
                                    <div class="insight-content">
                                        <p>بیشترین فعالیت کاربران در روزهای {{ $timeStats['user_pattern'] ?? 'کاری' }} مشاهده می‌شود.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="insight-box">
                                    <div class="insight-header">
                                        <i class="fas fa-clock text-warning"></i>
                                        <span>بهترین زمان انتشار</span>
                                    </div>
                                    <div class="insight-content">
                                        <p>ساعت {{ $timeStats['best_publish_time'] ?? '14:00 تا 16:00' }} بهترین زمان برای انتشار محتوا است.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="insight-box">
                                    <div class="insight-header">
                                        <i class="fas fa-chart-pie text-success"></i>
                                        <span>توزیع فعالیت</span>
                                    </div>
                                    <div class="insight-content">
                                        <p>{{ $timeStats['activity_distribution'] ?? '70%' }} فعالیت‌ها در ساعات اداری انجام می‌شود.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Enhanced Time filter buttons functionality
        const timeFilterButtons = document.querySelectorAll('[data-time-filter]');
        const timeCharts = document.querySelectorAll('.time-chart');
        let realtimeInterval = null;
        let isRealtimeActive = false;

        timeFilterButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Add loading animation
                showTimeLoading();

                // Remove active class from all buttons
                timeFilterButtons.forEach(btn => btn.classList.remove('active'));

                // Add active class to clicked button
                this.classList.add('active');

                // Hide all charts with animation
                timeCharts.forEach(chart => {
                    chart.style.opacity = '0';
                    setTimeout(() => {
                        chart.style.display = 'none';
                    }, 300);
                });

                // Show selected chart with animation
                const selectedFilter = this.getAttribute('data-time-filter');
                setTimeout(() => {
                    if (selectedFilter === 'daily') {
                        document.getElementById('dailyAnalysis').style.display = 'block';
                        document.getElementById('dailyStats').style.display = 'block';
                        setTimeout(() => {
                            document.getElementById('dailyAnalysis').style.opacity = '1';
                            document.getElementById('dailyStats').style.opacity = '1';
                        }, 50);
                    } else if (selectedFilter === 'realtime') {
                        document.getElementById('realtimeAnalysis').style.display = 'block';
                        setTimeout(() => {
                            document.getElementById('realtimeAnalysis').style.opacity = '1';
                            startRealtime();
                        }, 50);
                    } else {
                        document.getElementById(`${selectedFilter}Analysis`).style.display = 'block';
                        setTimeout(() => {
                            document.getElementById(`${selectedFilter}Analysis`).style.opacity = '1';
                        }, 50);
                    }
                    hideTimeLoading();
                }, 300);

                // Stop realtime if switching away
                if (selectedFilter !== 'realtime' && isRealtimeActive) {
                    stopRealtime();
                }
            });
        });

        // Initialize chart animations
        initializeTimeAnimations();

        // Chart initialization is now handled in index.blade.php
    });

    // Enhanced functionality functions for time analysis
    function showTimeLoading() {
        document.querySelectorAll('.chart-loading').forEach(loader => {
            loader.classList.remove('d-none');
        });
    }

    function hideTimeLoading() {
        setTimeout(() => {
            document.querySelectorAll('.chart-loading').forEach(loader => {
                loader.classList.add('d-none');
            });
        }, 500);
    }

    function initializeTimeAnimations() {
        // Add transition styles to chart containers
        document.querySelectorAll('.time-chart').forEach(chart => {
            chart.style.transition = 'opacity 0.3s ease-in-out';
            chart.style.opacity = '1';
        });

        // Add pulse animation to live badge
        const pulseElements = document.querySelectorAll('.pulse');
        pulseElements.forEach(element => {
            element.style.animation = 'pulse 2s infinite';
        });
    }

    function refreshChart(chartType) {
        showTimeLoading();

        // Simulate data refresh
        setTimeout(() => {
            if (window.timeCharts && window.timeCharts[chartType]) {
                window.timeCharts[chartType].updateOptions({
                    chart: {
                        animations: {
                            enabled: true,
                            easing: 'easeinout',
                            speed: 800
                        }
                    }
                });
            }
            hideTimeLoading();

            // Show success message
            showTimeNotification('نمودار ' + getChartTypeName(chartType) + ' با موفقیت بروزرسانی شد', 'success');
        }, 1000);
    }

    function fullscreenChart(chartId) {
        const chartElement = document.getElementById(chartId);
        if (chartElement.requestFullscreen) {
            chartElement.requestFullscreen();
        } else if (chartElement.webkitRequestFullscreen) {
            chartElement.webkitRequestFullscreen();
        } else if (chartElement.msRequestFullscreen) {
            chartElement.msRequestFullscreen();
        }
    }

    function downloadChart(chartId) {
        showTimeNotification('در حال دانلود نمودار...', 'info');

        // Simulate download process
        setTimeout(() => {
            showTimeNotification('نمودار با موفقیت دانلود شد', 'success');
        }, 1500);
    }

    function refreshTimeData() {
        showTimeNotification('در حال بروزرسانی داده‌های زمانی...', 'info');

        // Simulate refresh process
        setTimeout(() => {
            showTimeNotification('داده‌ها با موفقیت بروزرسانی شدند', 'success');
        }, 2000);
    }

    function exportTimeData(format) {
        showTimeNotification('در حال آماده‌سازی فایل ' + format.toUpperCase() + '...', 'info');

        // Simulate export process
        setTimeout(() => {
            showTimeNotification('فایل با موفقیت دانلود شد', 'success');
        }, 2000);
    }

    function showTimeFilters() {
        showTimeNotification('فیلترهای پیشرفته در حال بارگذاری...', 'info');
    }

    function showTimePredictions() {
        showTimeNotification('پیش‌بینی‌های هوشمند در حال بارگذاری...', 'info');
    }

    function exportTimeStats() {
        showTimeNotification('در حال آماده‌سازی گزارش آمار زمانی...', 'info');

        // Simulate export
        setTimeout(() => {
            showTimeNotification('گزارش آمار زمانی دانلود شد', 'success');
        }, 1500);
    }

    function refreshTimeStats() {
        showTimeNotification('در حال بروزرسانی آمار زمانی...', 'info');

        // Simulate refresh
        setTimeout(() => {
            showTimeNotification('آمار زمانی بروزرسانی شد', 'success');
        }, 1000);
    }

    // Real-time functionality
    function startRealtime() {
        if (isRealtimeActive) return;

        isRealtimeActive = true;
        document.getElementById('realtimeToggle').className = 'fas fa-pause';

        // Update real-time metrics every 5 seconds
        realtimeInterval = setInterval(() => {
            updateRealtimeMetrics();
        }, 5000);

        showTimeNotification('نمایش زنده فعال شد', 'success');
    }

    function stopRealtime() {
        if (!isRealtimeActive) return;

        isRealtimeActive = false;
        document.getElementById('realtimeToggle').className = 'fas fa-play';

        if (realtimeInterval) {
            clearInterval(realtimeInterval);
            realtimeInterval = null;
        }

        showTimeNotification('نمایش زنده متوقف شد', 'warning');
    }

    function toggleRealtime() {
        if (isRealtimeActive) {
            stopRealtime();
        } else {
            startRealtime();
        }
    }

    function updateRealtimeMetrics() {
        // Simulate real-time data updates
        const activeElement = document.getElementById('realtimeActive');
        const viewsElement = document.getElementById('realtimeViews');
        const newElement = document.getElementById('realtimeNew');
        const avgElement = document.getElementById('realtimeAvg');

        if (activeElement) {
            const currentActive = parseInt(activeElement.textContent);
            const newActive = currentActive + Math.floor(Math.random() * 5) - 2;
            activeElement.textContent = Math.max(0, newActive);

            // Add animation
            activeElement.style.transform = 'scale(1.1)';
            setTimeout(() => {
                activeElement.style.transform = 'scale(1)';
            }, 200);
        }

        if (viewsElement) {
            const currentViews = parseInt(viewsElement.textContent);
            const newViews = currentViews + Math.floor(Math.random() * 3);
            viewsElement.textContent = newViews;
        }

        if (newElement) {
            const currentNew = parseInt(newElement.textContent);
            if (Math.random() > 0.8) { // 20% chance to add new location
                newElement.textContent = currentNew + 1;
                newElement.style.transform = 'scale(1.2)';
                setTimeout(() => {
                    newElement.style.transform = 'scale(1)';
                }, 300);
            }
        }

        if (avgElement) {
            const newAvg = (Math.random() * 3 + 1).toFixed(1);
            avgElement.textContent = newAvg;
        }
    }

    function getChartTypeName(type) {
        const names = {
            'daily': 'روزانه',
            'weekly': 'هفتگی',
            'monthly': 'ماهانه',
            'yearly': 'سالانه',
            'realtime': 'لحظه‌ای'
        };
        return names[type] || type;
    }

    function showTimeNotification(message, type = 'info') {
        // Create notification element
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;

        document.body.appendChild(notification);

        // Auto remove after 3 seconds
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 3000);
    }

    // Add CSS for pulse animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        .pulse {
            animation: pulse 2s infinite;
        }
    `;
    document.head.appendChild(style);
</script>