@extends('admin.layouts.app')

@section('title', 'تحلیل پیش‌بینی')

@section('content')
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">تحلیل پیش‌بینی</h1>
    <div>
        <a href="{{ route('admin.analytics.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm ml-2">
            <i class="fas fa-chart-bar fa-sm text-white-50 ml-1"></i> بازگشت به داشبورد تحلیلی
        </a>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-success shadow-sm" id="printReport">
            <i class="fas fa-download fa-sm text-white-50 ml-1"></i> دریافت گزارش
        </a>
    </div>
</div>

<!-- Historical and Predictive Trend Analysis -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">تحلیل روند تاریخی و پیش‌بینی</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">گزینه‌های نمودار:</div>
                        <a class="dropdown-item" href="#" id="toggle-historical">نمایش/مخفی داده‌های تاریخی</a>
                        <a class="dropdown-item" href="#" id="toggle-predictions">نمایش/مخفی پیش‌بینی‌ها</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="export-chart-trend">دریافت نمودار</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="trendChart"></canvas>
                </div>
                <hr>
                <div class="row mt-3">
                    <div class="col-md-8">
                        <h6 class="font-weight-bold">تحلیل روند:</h6>
                        <p>
                            نمودار بالا روند تاریخی ثبت مکان‌ها را در 24 ماه گذشته نشان می‌دهد و پیش‌بینی برای 3 ماه آینده را 
                            بر اساس الگوهای گذشته ارائه می‌کند. پیش‌بینی‌ها با استفاده از تحلیل روند و محاسبه میانگین رشد انجام شده‌اند.
                        </p>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-info text-white shadow">
                            <div class="card-body">
                                پیش‌بینی رشد
                                <div class="text-white-50 small">تا 3 ماه آینده: <span class="font-weight-bold">15%</span></div>
                            </div>
                        </div>
                        <div class="mt-2 small text-center">
                            <span class="font-weight-bold">دقت پیش‌بینی: 84%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Seasonality Analysis -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">تحلیل فصلی</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="seasonalityChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">تحلیل فصلی:</h6>
                    <p>
                        این نمودار تغییرات فصلی داده‌ها را نشان می‌دهد و مقایسه میان سال‌های مختلف را امکان‌پذیر می‌سازد.
                        با مشاهده الگوهای تکرارشونده می‌توانید زمان‌های اوج و افت فعالیت را شناسایی کنید.
                    </p>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card bg-primary text-white shadow">
                                <div class="card-body">
                                    ماه‌های اوج فعالیت
                                    <div class="text-white-50 small">بهار و تابستان با بیشترین رشد</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-warning text-white shadow">
                                <div class="card-body">
                                    ماه‌های افت فعالیت
                                    <div class="text-white-50 small">زمستان با کمترین فعالیت</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Forecasting with Moving Averages -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">پیش‌بینی با میانگین متحرک</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">گزینه‌های نمودار:</div>
                        <a class="dropdown-item" href="#" id="toggle-actual">نمایش/مخفی داده‌های واقعی</a>
                        <a class="dropdown-item" href="#" id="toggle-ma7">نمایش/مخفی میانگین متحرک 7 روزه</a>
                        <a class="dropdown-item" href="#" id="toggle-ma30">نمایش/مخفی میانگین متحرک 30 روزه</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="export-chart-forecast">دریافت نمودار</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="forecastChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">تحلیل پیش‌بینی:</h6>
                    <p>
                        این نمودار داده‌های روزانه را با میانگین متحرک 7 روزه (کوتاه‌مدت) و 30 روزه (بلندمدت) مقایسه می‌کند.
                        میانگین متحرک کوتاه‌مدت نوسانات کوتاه‌مدت را نشان می‌دهد، در حالی که میانگین متحرک بلندمدت روند کلی را 
                        نمایش می‌دهد.
                    </p>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="small">
                                <span class="font-weight-bold">نکته:</span>
                                زمانی که میانگین متحرک کوتاه‌مدت از میانگین متحرک بلندمدت عبور می‌کند، می‌تواند نشانه‌ای از تغییر روند باشد.
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="small">
                                <span class="font-weight-bold">کاربرد:</span>
                                از این نمودار برای شناسایی روندهای بلندمدت و فیلتر کردن نویز کوتاه‌مدت استفاده کنید.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Correlation Analysis -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">تحلیل همبستگی</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="correlationChart"></canvas>
                </div>
                <hr>
                <div class="row mt-3">
                    <div class="col-md-7">
                        <h6 class="font-weight-bold">تحلیل همبستگی:</h6>
                        <p>
                            این نمودار رابطه بین تعداد مکان‌ها، تعداد نظرات و میانگین امتیازات را نشان می‌دهد.
                            ضریب همبستگی بین تعداد مکان‌ها و تعداد نظرات 0.85 است که نشان‌دهنده یک همبستگی قوی است.
                        </p>
                    </div>
                    <div class="col-md-5">
                        <div class="card bg-gradient-primary text-white shadow">
                            <div class="card-body">
                                <h5>نتایج کلیدی:</h5>
                                <ul>
                                    <li>همبستگی قوی بین تعداد مکان‌ها و نظرات</li>
                                    <li>تأثیر مثبت افزایش مکان‌ها بر میانگین امتیازات</li>
                                    <li>الگوی فصلی مشخص در داده‌ها</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.0/dist/chart.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Trend Analysis Chart
        var trendCtx = document.getElementById('trendChart');
        var predictiveData = @json($predictiveData ?? []);
        
        // Combine historical and prediction data
        var allMonths = [
            ...(predictiveData.historical?.months ?? []),
            ...(predictiveData.predictions?.months ?? [])
        ];
        
        var allData = [
            ...(predictiveData.historical?.counts ?? []),
            ...(new Array(predictiveData.predictions?.months?.length ?? 0).fill(null))
        ];
        
        var predictionData = [
            ...(new Array(predictiveData.historical?.months?.length ?? 0).fill(null)),
            ...(predictiveData.predictions?.counts ?? [])
        ];
        
        var trendChart = new Chart(trendCtx, {
            type: 'line',
            data: {
                labels: allMonths,
                datasets: [{
                    label: 'داده‌های تاریخی',
                    data: allData,
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                    pointBorderColor: 'rgba(78, 115, 223, 1)',
                    pointHoverRadius: 5,
                    pointHoverBackgroundColor: 'rgba(78, 115, 223, 1)',
                    pointHoverBorderColor: 'rgba(78, 115, 223, 1)',
                    pointHitRadius: 10,
                    pointBorderWidth: 2,
                    fill: true
                }, {
                    label: 'پیش‌بینی',
                    data: predictionData,
                    backgroundColor: 'rgba(246, 194, 62, 0.05)',
                    borderColor: 'rgba(246, 194, 62, 1)',
                    borderDash: [5, 5],
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(246, 194, 62, 1)',
                    pointBorderColor: 'rgba(246, 194, 62, 1)',
                    pointHoverRadius: 5,
                    pointHoverBackgroundColor: 'rgba(246, 194, 62, 1)',
                    pointHoverBorderColor: 'rgba(246, 194, 62, 1)',
                    pointHitRadius: 10,
                    pointBorderWidth: 2,
                    fill: false
                }]
            },
            options: {
                maintainAspectRatio: false,
                layout: {
                    padding: {
                        left: 10,
                        right: 25,
                        top: 25,
                        bottom: 0
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxTicksLimit: 12
                        }
                    },
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    },
                    tooltip: {
                        rtl: true,
                        titleAlign: 'right',
                        bodyAlign: 'right'
                    }
                }
            }
        });
        
        // Seasonality Chart
        var seasonalityCtx = document.getElementById('seasonalityChart');
        var seasonalityData = @json($seasonalityData ?? []);
        
        // Prepare data for seasonality chart
        var months = [];
        var yearOneData = [];
        var yearTwoData = [];
        
        seasonalityData.forEach(function(month) {
            months.push(month.month);
            yearOneData.push(month.data['2022'] || 0);
            yearTwoData.push(month.data['2023'] || 0);
        });
        
        var seasonalityChart = new Chart(seasonalityCtx, {
            type: 'bar',
            data: {
                labels: months,
                datasets: [{
                    label: '2022',
                    data: yearOneData,
                    backgroundColor: 'rgba(78, 115, 223, 0.8)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    borderWidth: 1
                }, {
                    label: '2023',
                    data: yearTwoData,
                    backgroundColor: 'rgba(28, 200, 138, 0.8)',
                    borderColor: 'rgba(28, 200, 138, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    x: {
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    }
                }
            }
        });
        
        // Forecast Chart with Moving Averages
        var forecastCtx = document.getElementById('forecastChart');
        var forecastData = @json($forecastData ?? []);
        
        var forecastChart = new Chart(forecastCtx, {
            type: 'line',
            data: {
                labels: forecastData.dates || [],
                datasets: [{
                    label: 'داده‌های واقعی',
                    data: forecastData.actual || [],
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    borderColor: 'rgba(78, 115, 223, 0.8)',
                    pointRadius: 2,
                    pointBackgroundColor: 'rgba(78, 115, 223, 0.8)',
                    pointBorderColor: 'rgba(78, 115, 223, 0.8)',
                    pointHoverRadius: 3,
                    pointHitRadius: 10,
                    pointBorderWidth: 1,
                    fill: false
                }, {
                    label: 'میانگین متحرک 7 روزه',
                    data: forecastData.ma7 || [],
                    backgroundColor: 'rgba(28, 200, 138, 0.05)',
                    borderColor: 'rgba(28, 200, 138, 1)',
                    pointRadius: 0,
                    borderWidth: 2,
                    fill: false
                }, {
                    label: 'میانگین متحرک 30 روزه',
                    data: forecastData.ma30 || [],
                    backgroundColor: 'rgba(246, 194, 62, 0.05)',
                    borderColor: 'rgba(246, 194, 62, 1)',
                    pointRadius: 0,
                    borderWidth: 2,
                    fill: false
                }]
            },
            options: {
                maintainAspectRatio: false,
                layout: {
                    padding: {
                        left: 10,
                        right: 25,
                        top: 25,
                        bottom: 0
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxTicksLimit: 10
                        }
                    },
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    }
                }
            }
        });
        
        // Correlation Analysis Chart
        var correlationCtx = document.getElementById('correlationChart');
        var correlationData = @json($correlationData ?? []);
        
        var correlationChart = new Chart(correlationCtx, {
            type: 'line',
            data: {
                labels: correlationData.months || [],
                datasets: [{
                    label: 'تعداد مکان‌ها',
                    data: correlationData.locations || [],
                    yAxisID: 'y',
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                    pointBorderColor: 'rgba(78, 115, 223, 1)',
                    pointHoverRadius: 5,
                    fill: false
                }, {
                    label: 'تعداد نظرات',
                    data: correlationData.ratings || [],
                    yAxisID: 'y',
                    backgroundColor: 'rgba(28, 200, 138, 0.05)',
                    borderColor: 'rgba(28, 200, 138, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(28, 200, 138, 1)',
                    pointBorderColor: 'rgba(28, 200, 138, 1)',
                    pointHoverRadius: 5,
                    fill: false
                }, {
                    label: 'میانگین امتیازات',
                    data: correlationData.avg_ratings || [],
                    yAxisID: 'y1',
                    backgroundColor: 'rgba(246, 194, 62, 0.05)',
                    borderColor: 'rgba(246, 194, 62, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(246, 194, 62, 1)',
                    pointBorderColor: 'rgba(246, 194, 62, 1)',
                    pointHoverRadius: 5,
                    fill: false
                }]
            },
            options: {
                maintainAspectRatio: false,
                layout: {
                    padding: {
                        left: 10,
                        right: 25,
                        top: 25,
                        bottom: 0
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxTicksLimit: 8
                        }
                    },
                    y: {
                        position: 'left',
                        title: {
                            display: true,
                            text: 'تعداد'
                        }
                    },
                    y1: {
                        position: 'right',
                        title: {
                            display: true,
                            text: 'میانگین امتیاز'
                        },
                        min: 0,
                        max: 5,
                        grid: {
                            drawOnChartArea: false
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    }
                }
            }
        });
        
        // Toggle buttons for trend chart
        document.getElementById('toggle-historical').addEventListener('click', function() {
            trendChart.data.datasets[0].hidden = !trendChart.data.datasets[0].hidden;
            trendChart.update();
        });
        
        document.getElementById('toggle-predictions').addEventListener('click', function() {
            trendChart.data.datasets[1].hidden = !trendChart.data.datasets[1].hidden;
            trendChart.update();
        });
        
        // Toggle buttons for forecast chart
        document.getElementById('toggle-actual').addEventListener('click', function() {
            forecastChart.data.datasets[0].hidden = !forecastChart.data.datasets[0].hidden;
            forecastChart.update();
        });
        
        document.getElementById('toggle-ma7').addEventListener('click', function() {
            forecastChart.data.datasets[1].hidden = !forecastChart.data.datasets[1].hidden;
            forecastChart.update();
        });
        
        document.getElementById('toggle-ma30').addEventListener('click', function() {
            forecastChart.data.datasets[2].hidden = !forecastChart.data.datasets[2].hidden;
            forecastChart.update();
        });
        
        // Print report functionality
        document.getElementById('printReport').addEventListener('click', function() {
            window.print();
        });
        
        // Export chart functionality
        document.getElementById('export-chart-trend').addEventListener('click', function() {
            var link = document.createElement('a');
            link.download = 'trend-analysis.png';
            link.href = trendChart.toBase64Image();
            link.click();
        });
        
        document.getElementById('export-chart-forecast').addEventListener('click', function() {
            var link = document.createElement('a');
            link.download = 'forecast-analysis.png';
            link.href = forecastChart.toBase64Image();
            link.click();
        });
    });
</script>
@endsection

@section('styles')
<style>
    .chart-area, .chart-bar, .chart-pie {
        height: 20rem;
        position: relative;
    }
    
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            break-inside: avoid;
            border: 1px solid #ddd !important;
            box-shadow: none !important;
        }
        .chart-area, .chart-bar, .chart-pie {
            height: 15rem !important;
        }
    }
</style>
@endsection 