@extends('admin.layouts.app')

@section('title', __('admin.translations'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('admin.translations') }} - {{ $language->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.languages.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-left"></i> {{ __('admin.back') }}
                        </a>
                    </div>
                </div>
                <form action="{{ route('admin.languages.translations.update', $language) }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <ul class="nav nav-tabs" id="translationTabs" role="tablist">
                            @foreach($translations as $group => $items)
                                <li class="nav-item">
                                    <a class="nav-link {{ $loop->first ? 'active' : '' }}" id="{{ $group }}-tab" data-toggle="tab" href="#{{ $group }}" role="tab">
                                        {{ $group }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                        <div class="tab-content mt-3" id="translationTabsContent">
                            @foreach($translations as $group => $items)
                                <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" id="{{ $group }}" role="tabpanel">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('admin.key') }}</th>
                                                    <th>{{ __('admin.value') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $key => $value)
                                                    <tr>
                                                        <td>{{ $key }}</td>
                                                        <td>
                                                            @if(is_array($value))
                                                                <textarea class="form-control" name="translations[{{ $group }}][{{ $key }}]" rows="3">{{ json_encode($value, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</textarea>
                                                            @else
                                                                <input type="text" class="form-control" name="translations[{{ $group }}][{{ $key }}]" value="{{ is_string($value) ? $value : '' }}">
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">{{ __('admin.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 