@extends('admin.layouts.app')

@section('title', 'جزئیات مکان')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ $location->title }}</h1>
        <div>
            <a href="{{ route('admin.locations.edit', $location->id) }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm mr-2">
                <i class="fas fa-edit fa-sm text-white-50 ml-1"></i> ویرایش
            </a>
            <a href="{{ route('admin.locations.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-right fa-sm text-white-50 ml-1"></i> بازگشت به لیست
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- اطلاعات اصلی -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات اصلی</h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">عملیات:</div>
                            <a class="dropdown-item" href="{{ route('admin.locations.edit', $location->id) }}">ویرایش</a>
                            <div class="dropdown-divider"></div>
                            <form action="{{ route('admin.locations.destroy', $location->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="dropdown-item text-danger" onclick="return confirm('آیا از حذف این مکان اطمینان دارید؟')">حذف</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th style="width: 200px;">عنوان</th>
                                    <td>{{ $location->title }}</td>
                                </tr>
                                <tr>
                                    <th>شناسه یکتا</th>
                                    <td>{{ $location->title_id }}</td>
                                </tr>
                                <tr>
                                    <th>دسته‌بندی</th>
                                    <td>
                                        @if($location->category_id && is_object($location->categoryRelation))
                                            {{ $location->categoryRelation->category_fa }}
                                        @elseif($location->category_fa)
                                            {{ $location->category_fa }}
                                        @else
                                            {{ is_string($location->category) ? $location->category : '-' }}
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>شعار</th>
                                    <td>{{ $location->slogan }}</td>
                                </tr>
                                <tr>
                                    <th>توضیحات</th>
                                    <td>{{ $location->description }}</td>
                                </tr>
                                <tr>
                                    <th>وضعیت</th>
                                    <td>
                                        @if($location->is_active)
                                            <span class="badge bg-success text-white">فعال</span>
                                        @else
                                            <span class="badge bg-danger text-white">غیرفعال</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاریخ ایجاد</th>
                                    <td>{{ \Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>تاریخ بروزرسانی</th>
                                    <td>{{ \Morilog\Jalali\Jalalian::fromDateTime($location->updated_at)->format('Y/m/d H:i') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- امکانات -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">امکانات</h6>
                </div>
                <div class="card-body">
                    @if($location->amenities)
                        @php
                            $amenities = $location->amenities_array;
                        @endphp
                        <div class="row">
                            @foreach($amenities as $amenityId => $value)
                                <div class="col-md-4 mb-2">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-check-circle text-success mr-2"></i>
                                        <span>{{ $amenityId }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted">هیچ امکاناتی ثبت نشده است.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- اطلاعات جانبی -->
        <div class="col-xl-4 col-lg-5">
            <!-- تصاویر -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">تصاویر</h6>
                </div>
                <div class="card-body">
                    @if($location->images)
                        @php
                            $images = $location->images_array;
                        @endphp

                        @if(!empty($images))
                            <div class="row">
                                @foreach($images as $index => $image)
                                    <div class="col-md-4 mb-3">
                                        <div class="card">
                                            <img src="{{ asset('storage/' . $image) }}" alt="{{ $location->title }}" class="card-img-top" style="height: 200px; object-fit: cover;">
                                            <div class="card-body p-2">
                                                <small class="text-muted">تصویر {{ $index + 1 }}</small>
                                                @if($index === 0)
                                                    <span class="badge badge-primary ml-2">تصویر اصلی</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="alert alert-secondary">تصویری وجود ندارد</div>
                        @endif
                    @else
                        <div class="alert alert-secondary">تصویری وجود ندارد</div>
                    @endif
                </div>
            </div>

            <!-- اطلاعات تماس -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات تماس</h6>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-phone ml-2"></i> شماره تماس:</span>
                            <span class="text-primary">{{ $location->phone ?? '-' }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-globe ml-2"></i> وب‌سایت:</span>
                            <span class="text-primary">{{ $location->url ?? '-' }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-clock ml-2"></i> ساعت کاری:</span>
                            <span class="text-primary">
                                {{ $location->open_hours ?? '-' }} تا {{ $location->closing_hours ?? '-' }}
                            </span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- موقعیت جغرافیایی -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">موقعیت جغرافیایی</h6>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <strong><i class="fas fa-map-marker-alt ml-2"></i> آدرس:</strong>
                            <p class="mt-2">{{ $location->address ?? '-' }}</p>
                        </li>
                        @if($location->lat && $location->lng)
                        <li class="list-group-item">
                            <div class="d-flex justify-content-between mb-2">
                                <span>عرض جغرافیایی:</span>
                                <span class="text-primary">{{ $location->lat }}</span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>طول جغرافیایی:</span>
                                <span class="text-primary">{{ $location->lng }}</span>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <a href="https://www.google.com/maps?q={{ $location->lat }},{{ $location->lng }}" target="_blank" class="btn btn-sm btn-primary w-100">
                                <i class="fas fa-map ml-1"></i> نمایش در نقشه
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection