@extends('admin.layouts.app')

@section('title', 'مشاهده لاگ')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مشاهده لاگ: {{ $filename }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.logs.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> بازگشت به لیست
                        </a>
                        <a href="{{ route('admin.logs.download', $filename) }}" class="btn btn-success">
                            <i class="fas fa-download"></i> دانلود
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="log-content" style="background-color: #1e1e1e; color: #fff; padding: 15px; border-radius: 5px; font-family: monospace; white-space: pre-wrap; max-height: 600px; overflow-y: auto;">
                        {{ $content }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .log-content {
        direction: ltr;
        text-align: left;
    }
</style>
@endpush
@endsection 