@extends('admin.layouts.app')

@section('title', 'افزودن منو جدید')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">افزودن منو جدید</h1>
        <a href="{{ route('admin.menu-management.index', ['lang' => $languageCode]) }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-right"></i> بازگشت به لیست
        </a>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات منو</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.menu-management.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">عنوان منو <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('title') is-invalid @enderror" 
                                           id="title" 
                                           name="title" 
                                           value="{{ old('title') }}"
                                           placeholder="مثال: صفحه اصلی"
                                           required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="url">آدرس لینک <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('url') is-invalid @enderror" 
                                           id="url" 
                                           name="url" 
                                           value="{{ old('url') }}"
                                           placeholder="مثال: / یا /about یا https://example.com"
                                           required>
                                    @error('url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="icon">آیکون FontAwesome</label>
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control @error('icon') is-invalid @enderror" 
                                               id="icon" 
                                               name="icon" 
                                               value="{{ old('icon') }}"
                                               placeholder="مثال: fas fa-home">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="showIconPicker()">
                                                <i class="fas fa-icons"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">
                                        آیکون FontAwesome برای نمایش در کنار عنوان منو
                                    </small>
                                    @error('icon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div id="icon-preview" class="mt-2"></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="target">نحوه باز شدن لینک</label>
                                    <select class="form-control @error('target') is-invalid @enderror" 
                                            id="target" 
                                            name="target">
                                        <option value="_self" {{ old('target') == '_self' ? 'selected' : '' }}>
                                            همان تب (_self)
                                        </option>
                                        <option value="_blank" {{ old('target') == '_blank' ? 'selected' : '' }}>
                                            تب جدید (_blank)
                                        </option>
                                    </select>
                                    @error('target')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="parent_id">منوی والد</label>
                                    <select class="form-control @error('parent_id') is-invalid @enderror" 
                                            id="parent_id" 
                                            name="parent_id">
                                        <option value="">منوی اصلی (بدون والد)</option>
                                        @foreach($parentMenus as $parentMenu)
                                            <option value="{{ $parentMenu->id }}" 
                                                    {{ old('parent_id') == $parentMenu->id ? 'selected' : '' }}>
                                                {{ $parentMenu->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">
                                        برای ایجاد زیرمنو، منوی والد را انتخاب کنید
                                    </small>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sort_order">ترتیب نمایش</label>
                                    <input type="number" 
                                           class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" 
                                           name="sort_order" 
                                           value="{{ old('sort_order', 0) }}"
                                           min="0"
                                           placeholder="0">
                                    <small class="form-text text-muted">
                                        عدد کمتر = نمایش زودتر
                                    </small>
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="language_code">زبان</label>
                                    <select class="form-control @error('language_code') is-invalid @enderror" 
                                            id="language_code" 
                                            name="language_code">
                                        @foreach($languages as $language)
                                            <option value="{{ $language->code }}" 
                                                    {{ ($languageCode == $language->code || old('language_code') == $language->code) ? 'selected' : '' }}>
                                                {{ $language->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('language_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="is_active" 
                                               name="is_active" 
                                               value="1"
                                               {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            فعال
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        منوهای غیرفعال نمایش داده نمی‌شوند
                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_for_guests" 
                                               name="show_for_guests" 
                                               value="1"
                                               {{ old('show_for_guests', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_for_guests">
                                            نمایش برای مهمان‌ها
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        کاربرانی که وارد نشده‌اند
                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_for_users" 
                                               name="show_for_users" 
                                               value="1"
                                               {{ old('show_for_users', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_for_users">
                                            نمایش برای کاربران
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        کاربرانی که وارد شده‌اند
                                    </small>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> ذخیره منو
                            </button>
                            <a href="{{ route('admin.menu-management.index', ['lang' => $languageCode]) }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> انصراف
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">راهنما</h6>
                </div>
                <div class="card-body">
                    <h6>نکات مهم:</h6>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-info-circle text-info"></i> عنوان منو باید کوتاه و واضح باشد</li>
                        <li><i class="fas fa-info-circle text-info"></i> آدرس می‌تواند نسبی (/) یا مطلق (https://) باشد</li>
                        <li><i class="fas fa-info-circle text-info"></i> آیکون‌ها از FontAwesome استفاده می‌کنند</li>
                        <li><i class="fas fa-info-circle text-info"></i> ترتیب نمایش: عدد کمتر = نمایش زودتر</li>
                    </ul>

                    <hr>

                    <h6>آیکون‌های پرکاربرد:</h6>
                    <div class="row">
                        <div class="col-6">
                            <small>
                                <code>fas fa-home</code><br>
                                <code>fas fa-list</code><br>
                                <code>fas fa-map</code><br>
                                <code>fas fa-phone</code><br>
                                <code>fas fa-info-circle</code>
                            </small>
                        </div>
                        <div class="col-6">
                            <i class="fas fa-home"></i> خانه<br>
                            <i class="fas fa-list"></i> لیست<br>
                            <i class="fas fa-map"></i> نقشه<br>
                            <i class="fas fa-phone"></i> تماس<br>
                            <i class="fas fa-info-circle"></i> درباره
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Icon Picker Modal -->
<div class="modal fade" id="iconPickerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">انتخاب آیکون</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Icons will be loaded here -->
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Icon preview
$('#icon').on('input', function() {
    const iconClass = $(this).val();
    const preview = $('#icon-preview');
    
    if (iconClass) {
        preview.html(`<i class="${iconClass} fa-2x"></i> <span class="ml-2">${iconClass}</span>`);
    } else {
        preview.html('');
    }
});

// Icon picker (simple version)
function showIconPicker() {
    const commonIcons = [
        'fas fa-home', 'fas fa-list', 'fas fa-map', 'fas fa-phone', 'fas fa-info-circle',
        'fas fa-envelope', 'fas fa-user', 'fas fa-cog', 'fas fa-search', 'fas fa-star',
        'fas fa-heart', 'fas fa-shopping-cart', 'fas fa-calendar', 'fas fa-clock',
        'fas fa-download', 'fas fa-upload', 'fas fa-edit', 'fas fa-trash', 'fas fa-plus', 'fas fa-minus'
    ];
    
    let iconHtml = '<div class="row">';
    commonIcons.forEach(icon => {
        iconHtml += `
            <div class="col-3 text-center mb-2">
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selectIcon('${icon}')">
                    <i class="${icon}"></i>
                </button>
            </div>
        `;
    });
    iconHtml += '</div>';
    
    $('#iconPickerModal .modal-body').html(iconHtml);
    $('#iconPickerModal').modal('show');
}

function selectIcon(iconClass) {
    $('#icon').val(iconClass).trigger('input');
    $('#iconPickerModal').modal('hide');
}

// Trigger icon preview on page load
$(document).ready(function() {
    $('#icon').trigger('input');
});
</script>
@endpush
