@props(['menus' => collect(), 'class' => 'navbar-nav'])

<ul class="{{ $class }}">
    @foreach($menus as $menu)
        @if($menu->is_active)
            <li class="nav-item {{ $menu->hasChildren() ? 'dropdown' : '' }}">
                @if($menu->hasChildren())
                    <!-- Dropdown Menu -->
                    <a class="nav-link dropdown-toggle position-relative" 
                       href="#" 
                       id="navbarDropdown{{ $menu->id }}" 
                       role="button" 
                       data-bs-toggle="dropdown" 
                       aria-expanded="false"
                       style="padding: 8px 16px; border-radius: 8px; transition: all 0.3s ease; margin: 0 4px;">
                        @if($menu->icon)
                            <i class="{{ $menu->icon }}" style="font-size: 1.1rem;"></i>
                        @endif
                        <span>{{ $menu->title }}</span>
                        <span class="nav-indicator"></span>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown{{ $menu->id }}">
                        @foreach($menu->children as $child)
                            @if($child->is_active)
                                <li>
                                    <a class="dropdown-item" 
                                       href="{{ $child->full_url }}" 
                                       target="{{ $child->target }}"
                                       style="padding: 8px 16px; transition: all 0.2s ease;">
                                        @if($child->icon)
                                            <i class="{{ $child->icon }} me-2"></i>
                                        @endif
                                        {{ $child->title }}
                                    </a>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                @else
                    <!-- Regular Menu Item -->
                    <a class="nav-link position-relative {{ request()->is(trim($menu->url, '/') . '*') ? 'active' : '' }}" 
                       href="{{ $menu->full_url }}" 
                       target="{{ $menu->target }}"
                       style="padding: 8px 16px; border-radius: 8px; transition: all 0.3s ease; margin: 0 4px;">
                        @if($menu->icon)
                            <i class="{{ $menu->icon }}" style="font-size: 1.1rem;"></i>
                        @endif
                        <span>{{ $menu->title }}</span>
                        <span class="nav-indicator"></span>
                    </a>
                @endif
            </li>
        @endif
    @endforeach
</ul>

<style>
/* Menu Styles */
.nav-link {
    color: #2c3e50 !important;
    font-weight: 500;
    position: relative;
    overflow: hidden;
}

.nav-link:hover {
    background: rgba(255,255,255,0.3) !important;
    color: #1a252f !important;
    transform: translateY(-1px);
}

.nav-link.active {
    background: rgba(255,255,255,0.4) !important;
    color: #1a252f !important;
    font-weight: 600;
}

.nav-indicator {
    position: absolute;
    bottom: 0;
    left: 50%;
    width: 0;
    height: 2px;
    background: #2c3e50;
    transition: all 0.3s ease;
    transform: translateX(-50%);
}

.nav-link:hover .nav-indicator,
.nav-link.active .nav-indicator {
    width: 80%;
}

.dropdown-menu {
    border: none;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    border-radius: 8px;
    overflow: hidden;
    margin-top: 8px;
}

.dropdown-item {
    color: #2c3e50;
    font-weight: 500;
    border-bottom: 1px solid #f8f9fa;
}

.dropdown-item:last-child {
    border-bottom: none;
}

.dropdown-item:hover {
    background: #f8f9fa;
    color: #1a252f;
    transform: translateX(5px);
}

.dropdown-item i {
    width: 20px;
    text-align: center;
    color: #6c757d;
}

/* Mobile Responsive */
@media (max-width: 991.98px) {
    .nav-link {
        padding: 12px 16px !important;
        margin: 2px 0 !important;
        border-radius: 6px !important;
    }
    
    .dropdown-menu {
        margin-top: 0;
        border-radius: 0;
        box-shadow: none;
        border-left: 3px solid #FFD700;
        margin-left: 15px;
    }
    
    .dropdown-item {
        padding: 10px 20px;
        font-size: 0.9rem;
    }
}

/* Animation for dropdown */
.dropdown-menu {
    opacity: 0;
    transform: translateY(-10px);
    transition: all 0.3s ease;
    pointer-events: none;
}

.dropdown:hover .dropdown-menu,
.dropdown-menu.show {
    opacity: 1;
    transform: translateY(0);
    pointer-events: auto;
}

/* Icon animations */
.nav-link i {
    transition: all 0.3s ease;
}

.nav-link:hover i {
    transform: scale(1.1);
}

.dropdown-toggle::after {
    transition: transform 0.3s ease;
}

.dropdown:hover .dropdown-toggle::after {
    transform: rotate(180deg);
}
</style>
