@extends('layouts.app')

@section('title', 'مکان‌های محبوب')

@push('head')
    <link rel="stylesheet" href="{{ asset('css/popular-page.css') }}">
    <meta name="description" content="کشف محبوب‌ترین مکان‌های گردشگری، رستوران‌ها، هتل‌ها و جاذبه‌های دیدنی با بهترین امتیازات و نظرات کاربران">
@endpush

@section('content')
<!-- Hero Section -->
<section class="popular-hero">
    <div class="container">
        <div class="text-center">
            <h1 class="hero-title">
                <i class="fas fa-star me-3"></i>
                مکان‌های محبوب
            </h1>
            <p class="hero-subtitle">
                کشف بهترین و محبوب‌ترین مکان‌ها با بالاترین امتیازات و نظرات مثبت کاربران
            </p>
        </div>

        <!-- آمار Hero -->
        <div class="hero-stats">
            <div class="stat-card">
                <span class="stat-number">{{ app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian(number_format($totalLocations)) : number_format($totalLocations) }}</span>
                <span class="stat-label">مکان ثبت شده</span>
            </div>
            <div class="stat-card">
                <span class="stat-number">{{ app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($totalCategories) : $totalCategories }}</span>
                <span class="stat-label">دسته‌بندی مختلف</span>
            </div>
            <div class="stat-card">
                <span class="stat-number">{{ app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($totalProvinces) : $totalProvinces }}</span>
                <span class="stat-label">استان پوشش داده شده</span>
            </div>
            <div class="stat-card">
                <span class="stat-number">{{ app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian(number_format($averageRating, 1)) : number_format($averageRating, 1) }}</span>
                <span class="stat-label">میانگین امتیاز</span>
            </div>
        </div>
    </div>
</section>

<div class="container">
    <!-- فیلترها -->
    <section class="filters-section">
        <h2 class="filters-title">
            <i class="fas fa-filter"></i>
            فیلتر و جستجو
        </h2>

        <form method="GET" action="{{ route('popular') }}" id="filtersForm">
            <div class="filter-row">
                <div class="filter-group">
                    <label class="filter-label" for="category">دسته‌بندی</label>
                    <select name="category" id="category" class="filter-select">
                        <option value="">همه دسته‌بندی‌ها</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ $categoryId == $category->id ? 'selected' : '' }}>
                                {{ $category->emoji ?? '📍' }} {{ $category->category_fa }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="filter-group">
                    <label class="filter-label" for="province">استان</label>
                    <select name="province" id="province" class="filter-select">
                        <option value="">همه استان‌ها</option>
                        @foreach($provinces as $province)
                            <option value="{{ $province->id }}" {{ $provinceId == $province->id ? 'selected' : '' }}>
                                {{ $province->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="filter-group">
                    <label class="filter-label" for="city">شهر</label>
                    <select name="city" id="city" class="filter-select">
                        <option value="">همه شهرها</option>
                        @foreach($cities as $city)
                            <option value="{{ $city->id }}" {{ $cityId == $city->id ? 'selected' : '' }}>
                                {{ $city->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="filter-group">
                    <label class="filter-label" for="min_rating">حداقل امتیاز</label>
                    <select name="min_rating" id="min_rating" class="filter-select">
                        <option value="0" {{ $minRating == 0 ? 'selected' : '' }}>همه امتیازات</option>
                        <option value="1" {{ $minRating == 1 ? 'selected' : '' }}>⭐ 1 و بالاتر</option>
                        <option value="2" {{ $minRating == 2 ? 'selected' : '' }}>⭐ 2 و بالاتر</option>
                        <option value="3" {{ $minRating == 3 ? 'selected' : '' }}>⭐ 3 و بالاتر</option>
                        <option value="4" {{ $minRating == 4 ? 'selected' : '' }}>⭐ 4 و بالاتر</option>
                        <option value="5" {{ $minRating == 5 ? 'selected' : '' }}>⭐ 5 ستاره</option>
                    </select>
                </div>
            </div>

            <div class="filter-row">
                <div class="filter-group">
                    <label class="filter-label" for="sort">مرتب‌سازی بر اساس</label>
                    <select name="sort" id="sort" class="filter-select">
                        <option value="star_rating" {{ $sortBy == 'star_rating' ? 'selected' : '' }}>بالاترین امتیاز</option>
                        <option value="view_count" {{ $sortBy == 'view_count' ? 'selected' : '' }}>بیشترین بازدید</option>
                        <option value="newest" {{ $sortBy == 'newest' ? 'selected' : '' }}>جدیدترین</option>
                        <option value="oldest" {{ $sortBy == 'oldest' ? 'selected' : '' }}>قدیمی‌ترین</option>
                        <option value="name_asc" {{ $sortBy == 'name_asc' ? 'selected' : '' }}>نام (الف تا ی)</option>
                        <option value="name_desc" {{ $sortBy == 'name_desc' ? 'selected' : '' }}>نام (ی تا الف)</option>
                    </select>
                </div>

                <div class="filter-group">
                    <label class="filter-label" for="per_page">تعداد نمایش</label>
                    <select name="per_page" id="per_page" class="filter-select">
                        <option value="12" {{ request('per_page', 12) == 12 ? 'selected' : '' }}>12 مورد</option>
                        <option value="24" {{ request('per_page') == 24 ? 'selected' : '' }}>24 مورد</option>
                        <option value="36" {{ request('per_page') == 36 ? 'selected' : '' }}>36 مورد</option>
                        <option value="48" {{ request('per_page') == 48 ? 'selected' : '' }}>48 مورد</option>
                    </select>
                </div>
            </div>

            <div class="filter-actions">
                <button type="submit" class="btn-filter btn-primary">
                    <i class="fas fa-search"></i>
                    اعمال فیلتر
                </button>
                <a href="{{ route('popular') }}" class="btn-filter btn-secondary">
                    <i class="fas fa-times"></i>
                    پاک کردن فیلتر
                </a>
            </div>
        </form>
    </section>

    <!-- نتایج -->
    <section class="results-section">
        @if($popularLocations->count() > 0)
            <!-- اطلاعات نتایج -->
            <div class="results-info mb-4">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="results-count">
                        <strong>{{ $popularLocations->total() }}</strong> مکان یافت شد
                        @if($popularLocations->currentPage() > 1)
                            (صفحه {{ $popularLocations->currentPage() }} از {{ $popularLocations->lastPage() }})
                        @endif
                    </div>
                    <div class="results-per-page">
                        نمایش {{ $popularLocations->firstItem() }} تا {{ $popularLocations->lastItem() }} از {{ $popularLocations->total() }} مورد
                    </div>
                </div>
            </div>

            <!-- Grid مکان‌ها -->
            <div class="locations-grid">
                @foreach($popularLocations as $location)
                    <article class="location-card">
                        <!-- تصویر مکان -->
                        <div class="card-image-container">
                            @php
                                $images = $location->images_array;
                                $firstImage = !empty($images) ? $images[0] : null;
                            @endphp
                            @if($firstImage)
                                @php
                                    $imagePath = 'storage/' . $firstImage;
                                    $fullImagePath = public_path($imagePath);
                                @endphp
                                @if(file_exists($fullImagePath))
                                    <img src="{{ asset($imagePath) }}"
                                         class="card-image"
                                         alt="{{ $location->title }}"
                                         loading="lazy"
                                         onerror="this.parentElement.innerHTML='<div class=\'card-image bg-light d-flex align-items-center justify-content-center\'><i class=\'fas fa-image fa-3x text-muted\'></i></div>'">
                                @else
                                    <div class="card-image bg-light d-flex align-items-center justify-content-center">
                                        <i class="fas fa-image fa-3x text-muted"></i>
                                    </div>
                                @endif
                            @else
                                <div class="card-image bg-light d-flex align-items-center justify-content-center">
                                    <i class="fas fa-image fa-3x text-muted"></i>
                                </div>
                            @endif

                            <!-- Badge دسته‌بندی -->
                            @if($location->categoryRelation && $location->categoryRelation->emoji)
                                <div class="card-badge">
                                    {{ $location->categoryRelation->emoji }}
                                </div>
                            @endif

                            <!-- Badge امتیاز -->
                            @if($location->average_rating > 0)
                                <div class="rating-badge">
                                    <i class="fas fa-star"></i>
                                    {{ number_format($location->average_rating, 1) }}
                                    @if($location->ratings_count > 0)
                                        <span>({{ $location->ratings_count }})</span>
                                    @endif
                                </div>
                            @endif
                        </div>

                        <!-- محتوای کارت -->
                        <div class="card-content">
                            <h3 class="card-title">{{ $location->title }}</h3>

                            <!-- موقعیت جغرافیایی -->
                            <div class="card-location">
                                <i class="fas fa-map-marker-alt"></i>
                                @if($location->province)
                                    {{ $location->province->name }}
                                    @if($location->city)، {{ $location->city->name }}@endif
                                @elseif($location->city)
                                    {{ $location->city->name }}
                                @endif
                            </div>

                            <!-- دسته‌بندی -->
                            @if($location->category_fa)
                                <span class="card-category">
                                    <i class="fas fa-tag me-1"></i>
                                    {{ $location->category_fa }}
                                </span>
                            @endif

                            <!-- توضیحات -->
                            @if(!empty($location->description))
                                <p class="card-description">
                                    {{ \Illuminate\Support\Str::limit($location->description, 120) }}
                                </p>
                            @endif

                            <!-- آمار اضافی -->
                            <div class="card-stats mt-auto">
                                @if($location->ratings_count > 0)
                                    <small class="text-muted me-3">
                                        <i class="fas fa-comments me-1"></i>
                                        {{ number_format($location->ratings_count) }} نظر
                                    </small>
                                @endif
                                @if($location->star_rating > 0)
                                    <small class="text-muted">
                                        <i class="fas fa-star me-1"></i>
                                        {{ $location->star_rating }} ستاره
                                    </small>
                                @endif
                            </div>
                        </div>

                        <!-- Footer کارت -->
                        <div class="card-footer">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <!-- نمایش ستاره‌ها -->
                                <div class="stars-display">
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= ($location->average_rating ?? $location->star_rating ?? 0))
                                            <i class="fas fa-star text-warning"></i>
                                        @else
                                            <i class="far fa-star text-muted"></i>
                                        @endif
                                    @endfor
                                </div>

                                <!-- دکمه مشاهده جزئیات -->
                                <a href="{{ url('/location/' . $location->title_id) }}" class="view-details-btn">
                                    <i class="fas fa-eye"></i>
                                    مشاهده جزئیات
                                </a>
                            </div>
                        </div>
                    </article>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="pagination-wrapper">
                {{ $popularLocations->appends(request()->query())->links('pagination::bootstrap-4') }}
            </div>

        @else
            <!-- Empty State -->
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="fas fa-search"></i>
                </div>
                <h3 class="empty-state-title">هیچ مکانی یافت نشد</h3>
                <p class="empty-state-text">
                    متأسفانه با فیلترهای انتخابی شما هیچ مکانی پیدا نشد.<br>
                    لطفاً فیلترهای خود را تغییر دهید یا آن‌ها را پاک کنید.
                </p>
                <a href="{{ route('popular') }}" class="btn-filter btn-primary">
                    <i class="fas fa-refresh"></i>
                    مشاهده همه مکان‌ها
                </a>
            </div>
        @endif
    </section>
</div>

@endsection

@push('scripts')
<script>
// Popular page specific JavaScript
(function() {
    'use strict';

    // Wait for DOM to be ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initPopularPage);
    } else {
        initPopularPage();
    }

    function initPopularPage() {
        console.log('Initializing Popular Page...');

        // Initialize filter functionality
        initFilters();

        // Initialize image loading
        initImageLoading();

        // Smooth scroll to results if filtered
        handleFilteredResults();
    }

    function initFilters() {
        const filterSelects = document.querySelectorAll('.filter-select');
        const provinceSelect = document.getElementById('province');
        const citySelect = document.getElementById('city');

        // Auto-submit form on filter change (except province)
        filterSelects.forEach(select => {
            if (select.id !== 'province') {
                select.addEventListener('change', function() {
                    clearTimeout(window.filterTimeout);
                    window.filterTimeout = setTimeout(() => {
                        document.getElementById('filtersForm').submit();
                    }, 500);
                });
            }
        });

        // Province change handler for cities
        if (provinceSelect && citySelect) {
            provinceSelect.addEventListener('change', function() {
                const provinceId = this.value;

                // Clear city options
                citySelect.innerHTML = '<option value="">همه شهرها</option>';

                if (provinceId) {
                    // Show loading state
                    citySelect.disabled = true;
                    citySelect.innerHTML = '<option value="">در حال بارگذاری...</option>';

                    // Fetch cities for selected province
                    fetch(`/api/geography/cities-by-province/${provinceId}`)
                        .then(response => response.json())
                        .then(result => {
                            citySelect.innerHTML = '<option value="">همه شهرها</option>';
                            if (result.success && result.data) {
                                result.data.forEach(city => {
                                    const option = document.createElement('option');
                                    option.value = city.id;
                                    option.textContent = city.name;
                                    citySelect.appendChild(option);
                                });
                            }
                        })
                        .catch(error => {
                            console.error('Error fetching cities:', error);
                            citySelect.innerHTML = '<option value="">خطا در بارگذاری شهرها</option>';
                        })
                        .finally(() => {
                            citySelect.disabled = false;
                        });
                } else {
                    citySelect.disabled = false;
                }
            });
        }
    }

    function initImageLoading() {
        const images = document.querySelectorAll('.card-image[src]');
        images.forEach(img => {
            img.style.opacity = '0';
            img.style.transition = 'opacity 0.3s ease';

            if (img.complete) {
                img.style.opacity = '1';
            } else {
                img.addEventListener('load', function() {
                    this.style.opacity = '1';
                });

                img.addEventListener('error', function() {
                    this.style.opacity = '1';
                    console.warn('Failed to load image:', this.src);
                });
            }
        });
    }

    function handleFilteredResults() {
        if (window.location.search) {
            setTimeout(() => {
                const resultsSection = document.querySelector('.results-section');
                if (resultsSection) {
                    resultsSection.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }, 100);
        }
    }
})();
</script>
@endpush