-- ایجاد جدول زبان‌ها
CREATE TABLE IF NOT EXISTS `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `name` varchar(50) NOT NULL COMMENT 'نام زبان',
  `direction` enum('rtl','ltr') NOT NULL DEFAULT 'rtl' COMMENT 'جهت نوشتار',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'فعال/غیرفعال',
  `is_default` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'زبان پیش‌فرض',
  `sort_order` int(11) NOT NULL DEFAULT 0 COMMENT 'ترتیب نمایش',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='زبان‌های سایت';

-- درج زبان‌های پیش‌فرض
INSERT INTO `languages` (`code`, `name`, `direction`, `is_active`, `is_default`, `sort_order`) VALUES
('fa', 'فارسی', 'rtl', 1, 1, 1),
('en', 'English', 'ltr', 1, 0, 2),
('ar', 'العربية', 'rtl', 1, 0, 3); 