<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model
{
    use SoftDeletes;

    /**
     * فیلدهای قابل پر شدن
     */
    protected $fillable = [
        'sender_id',
        'recipient_id',
        'sender_name',
        'sender_email',
        'sender_phone',
        'subject',
        'content',
        'read_at'
    ];

    /**
     * فیلدهای تاریخ
     */
    protected $dates = [
        'read_at',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    /**
     * بررسی خوانده شدن پیام
     */
    public function isRead(): bool
    {
        return !is_null($this->read_at);
    }

    /**
     * علامت‌گذاری پیام به عنوان خوانده شده
     */
    public function markAsRead(): bool
    {
        return $this->update(['read_at' => now()]);
    }

    /**
     * رابطه با فرستنده پیام
     */
    public function sender()
    {
        return $this->belongsTo(Admin::class, 'sender_id');
    }

    /**
     * رابطه با گیرنده پیام
     */
    public function recipient()
    {
        return $this->belongsTo(Admin::class, 'recipient_id');
    }
} 