@extends('admin.layouts.app')

@section('title', 'افزودن امکان جدید')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">افزودن امکان جدید</h1>
        <a href="{{ route('admin.amenities.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50"></i>
            بازگشت به لیست
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="{{ route('admin.amenities.store') }}" method="POST">
                @csrf
                
                <div class="form-group">
                    <label for="type_id">نوع امکان</label>
                    <select name="type_id" id="type_id" class="form-control @error('type_id') is-invalid @enderror" required>
                        <option value="">انتخاب کنید</option>
                        @foreach($types as $type)
                            <option value="{{ $type->id }}" {{ old('type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->type_name }}
                            </option>
                        @endforeach
                    </select>
                    @error('type_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="title">عنوان</label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                    @error('title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="icon">آیکون</label>
                    <input type="text" class="form-control @error('icon') is-invalid @enderror" id="icon" name="icon" value="{{ old('icon') }}">
                    <small class="form-text text-muted">نام کلاس آیکون (مثال: fas fa-wifi)</small>
                    @error('icon')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="description">توضیحات</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                    @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="display_order">ترتیب نمایش</label>
                    <input type="number" class="form-control @error('display_order') is-invalid @enderror" id="display_order" name="display_order" value="{{ old('display_order', 0) }}">
                    @error('display_order')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active') ? 'checked' : '' }}>
                        <label class="custom-control-label" for="is_active">فعال</label>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">ذخیره</button>
                <a href="{{ route('admin.amenities.index') }}" class="btn btn-secondary mr-2">انصراف</a>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Add any JavaScript code here if needed
</script>
@endpush 