@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">ویرایش تنظیمات</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.display-settings.update', $displaySetting) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group">
                            <label for="page_key">کلید صفحه</label>
                            <input type="text" 
                                   class="form-control @error('page_key') is-invalid @enderror" 
                                   id="page_key" 
                                   name="page_key" 
                                   value="{{ old('page_key', $displaySetting->page_key) }}"
                                   placeholder="مثال: home, category, location">
                            @error('page_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="section_key">کلید بخش</label>
                            <input type="text" 
                                   class="form-control @error('section_key') is-invalid @enderror" 
                                   id="section_key" 
                                   name="section_key" 
                                   value="{{ old('section_key', $displaySetting->section_key) }}"
                                   placeholder="مثال: featured, latest, popular">
                            @error('section_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="desktop_items">تعداد آیتم در دسکتاپ</label>
                            <input type="number" 
                                   class="form-control @error('desktop_items') is-invalid @enderror" 
                                   id="desktop_items" 
                                   name="desktop_items" 
                                   value="{{ old('desktop_items', $displaySetting->desktop_items) }}"
                                   min="1">
                            @error('desktop_items')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mobile_items">تعداد آیتم در موبایل</label>
                            <input type="number" 
                                   class="form-control @error('mobile_items') is-invalid @enderror" 
                                   id="mobile_items" 
                                   name="mobile_items" 
                                   value="{{ old('mobile_items', $displaySetting->mobile_items) }}"
                                   min="1">
                            @error('mobile_items')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="load_more_text">متن دکمه نمایش بیشتر</label>
                            <input type="text" 
                                   class="form-control @error('load_more_text') is-invalid @enderror" 
                                   id="load_more_text" 
                                   name="load_more_text" 
                                   value="{{ old('load_more_text', $displaySetting->load_more_text) }}">
                            @error('load_more_text')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" 
                                       class="custom-control-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active', $displaySetting->is_active) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">فعال</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">بروزرسانی تنظیمات</button>
                            <a href="{{ route('admin.display-settings.index') }}" class="btn btn-secondary">بازگشت</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 