@extends('admin.layouts.app')

@section('title', 'تنظیمات نمایش صفحه اصلی')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex align-items-center">
                <h3 class="mb-0"><i class="fas fa-home ml-2"></i> تنظیمات نمایش صفحه اصلی</h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card shadow-lg rounded-lg">
                <div class="card-body">
                    <form action="{{ route('admin.display-settings.homepage.update') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="mb-3">بخش‌های صفحه اصلی</h5>
                                
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="hero_section" name="hero_section" value="1" {{ old('hero_section', $settings->hero_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="hero_section">بخش قهرمان (Hero)</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="featured_section" name="featured_section" value="1" {{ old('featured_section', $settings->featured_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="featured_section">بخش ویژه</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="categories_section" name="categories_section" value="1" {{ old('categories_section', $settings->categories_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="categories_section">بخش دسته‌بندی‌ها</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="latest_section" name="latest_section" value="1" {{ old('latest_section', $settings->latest_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="latest_section">بخش جدیدترین‌ها</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="popular_section" name="popular_section" value="1" {{ old('popular_section', $settings->popular_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="popular_section">بخش محبوب‌ترین‌ها</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="map_section" name="map_section" value="1" {{ old('map_section', $settings->map_section ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="map_section">بخش نقشه</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h5 class="mb-3">تنظیمات عمومی</h5>

                                <div class="form-group">
                                    <label for="sidebar_position">موقعیت نوار کناری</label>
                                    <select class="form-control" id="sidebar_position" name="sidebar_position">
                                        <option value="right" {{ old('sidebar_position', $settings->sidebar_position ?? 'right') == 'right' ? 'selected' : '' }}>راست</option>
                                        <option value="left" {{ old('sidebar_position', $settings->sidebar_position ?? 'right') == 'left' ? 'selected' : '' }}>چپ</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="items_per_page">تعداد آیتم در هر صفحه</label>
                                    <input type="number" class="form-control" id="items_per_page" name="items_per_page" min="1" max="50" value="{{ old('items_per_page', $settings->items_per_page ?? 12) }}">
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="show_ratings" name="show_ratings" value="1" {{ old('show_ratings', $settings->show_ratings ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_ratings">نمایش امتیازات</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="show_comments" name="show_comments" value="1" {{ old('show_comments', $settings->show_comments ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_comments">نمایش نظرات</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="show_share_buttons" name="show_share_buttons" value="1" {{ old('show_share_buttons', $settings->show_share_buttons ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_share_buttons">نمایش دکمه‌های اشتراک‌گذاری</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save ml-1"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .custom-switch {
        padding-right: 2.25rem;
        padding-left: 0;
    }
    .custom-control {
        position: relative;
        display: block;
        min-height: 1.5rem;
        padding-right: 1.5rem;
    }
    .custom-control-label {
        position: relative;
        margin-bottom: 0;
        vertical-align: top;
    }
    .custom-control-label::before {
        right: -1.5rem;
        left: auto;
    }
    .custom-control-label::after {
        right: calc(-1.5rem + 2px);
        left: auto;
    }
    .custom-switch .custom-control-label::before {
        right: -2.25rem;
        left: auto;
        width: 1.75rem;
        pointer-events: all;
        border-radius: 0.5rem;
    }
    .custom-switch .custom-control-label::after {
        top: calc(0.25rem + 2px);
        right: calc(-2.25rem + 2px);
        left: auto;
        width: calc(1rem - 4px);
        height: calc(1rem - 4px);
        background-color: #adb5bd;
        border-radius: 0.5rem;
        transition: transform 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    }
    .custom-switch .custom-control-input:checked ~ .custom-control-label::after {
        transform: translateX(-0.75rem);
    }
</style>
@endpush 