@extends('admin.layouts.app')

@section('title', 'جزئیات شهر')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>جزئیات شهر</h4>
                <div>
                    <a href="{{ route('admin.geography.cities.edit', $item->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> ویرایش
                    </a>
                    <a href="{{ route('admin.geography.cities.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> بازگشت به لیست شهرها
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">شناسه شهر</th>
                            <td>{{ $item->id }}</td>
                        </tr>
                        <tr>
                            <th>نام</th>
                            <td>{{ $item->name }}</td>
                        </tr>
                        <tr>
                            <th>نام انگلیسی</th>
                            <td>{{ $item->name_en ?? 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>بخش</th>
                            <td>
                                @if($item->district)
                                <a href="{{ route('admin.geography.districts.show', $item->district_id) }}">
                                    {{ $item->district->name ?? 'ندارد' }}
                                </a>
                                @else
                                ندارد
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>شهرستان</th>
                            <td>
                                @if($item->county)
                                <a href="{{ route('admin.geography.counties.show', $item->county_id) }}">
                                    {{ $item->county->name ?? 'ندارد' }}
                                </a>
                                @else
                                ندارد
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>نامک (Slug)</th>
                            <td><code>{{ $item->slug ?? 'ندارد' }}</code></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">کد</th>
                            <td>{{ $item->code ?? 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>جمعیت</th>
                            <td>{{ isset($item->population) ? number_format($item->population) : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>مساحت</th>
                            <td>{{ isset($item->area) ? number_format($item->area, 2) . ' کیلومتر مربع' : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>وضعیت</th>
                            <td>
                                <span class="badge {{ $item->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $item->is_active ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>تاریخ ایجاد</th>
                            <td>{{ $item->created_at ? (is_object($item->created_at) && method_exists($item->created_at, 'format') ? $item->created_at->format('Y-m-d H:i:s') : $item->created_at) : 'ندارد' }}</td>
                        </tr>
                        <tr>
                            <th>تاریخ بروزرسانی</th>
                            <td>{{ $item->updated_at ? (is_object($item->updated_at) && method_exists($item->updated_at, 'format') ? $item->updated_at->format('Y-m-d H:i:s') : $item->updated_at) : 'ندارد' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if($item->description)
            <div class="row mt-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>توضیحات</h5>
                        </div>
                        <div class="card-body">
                            {{ $item->description }}
                        </div>
                    </div>
                </div>
            </div>
            @endif

            {{-- بخش نقشه اگر داده مرزها وجود داشته باشد --}}
            @if(isset($item->boundaries))
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>مرزهای جغرافیایی</h5>
                    <div id="cityMap" style="height: 400px; width: 100%;"></div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- مناطق این شهر -->
    <div class="card mt-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5>مناطق</h5>
                <a href="{{ route('admin.geography.zones.create') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus"></i> افزودن منطقه
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(isset($zones) && $zones->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>شناسه</th>
                                <th>نام</th>
                                <th>نوع</th>
                                <th>منطقه والد</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($zones as $zone)
                            <tr>
                                <td>{{ $zone->id }}</td>
                                <td>{{ $zone->name }}</td>
                                <td>{{ $zone->type ?? 'نامشخص' }}</td>
                                <td>
                                    @if($zone->parent_zone_id)
                                        <a href="{{ route('admin.geography.zones.show', $zone->parent_zone_id) }}">
                                            {{ $zone->parentZone->name ?? 'ندارد' }}
                                        </a>
                                    @else
                                        ندارد
                                    @endif
                                </td>
                                <td>
                                    <span class="badge {{ $zone->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $zone->is_active ? 'فعال' : 'غیرفعال' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.geography.zones.show', $zone->id) }}" class="btn btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.geography.zones.edit', $zone->id) }}" class="btn btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">هیچ منطقه‌ای برای این شهر یافت نشد.</p>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
@if(isset($item->boundaries))
<script>
    // در صورت نیاز، کد مربوط به نمایش نقشه اینجا قرار می‌گیرد
    $(document).ready(function() {
        // اگر قصد پیاده‌سازی قابلیت نقشه دارید، کد آن اینجا قرار می‌گیرد
    });
</script>
@endif
@endsection 