@extends('admin.layouts.app')

@section('title', 'تنظیمات سایت')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">تنظیمات سایت</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="site_logo">لوگوی سایت</label>
                                    <input type="text" class="form-control @error('site_logo') is-invalid @enderror" 
                                           id="site_logo" name="site_logo" 
                                           value="{{ old('site_logo', $settings['site_logo'] ?? '') }}" required>
                                    @error('site_logo')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="site_title">عنوان سایت</label>
                                    <input type="text" class="form-control @error('site_title') is-invalid @enderror" 
                                           id="site_title" name="site_title" 
                                           value="{{ old('site_title', $settings['site_title'] ?? '') }}" required>
                                    @error('site_title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="site_description">توضیحات سایت</label>
                            <textarea class="form-control @error('site_description') is-invalid @enderror" 
                                      id="site_description" name="site_description" rows="3" required>{{ old('site_description', $settings['site_description'] ?? '') }}</textarea>
                            @error('site_description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> ذخیره تنظیمات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 