@php
    /**
     * ویوی پیش‌نمایش زنده قالب
     * این ویو فقط برای نمایش سریع اطلاعات وارد شده در فرم ویرایش/ایجاد قالب است.
     * تمام توضیحات و متون به زبان فارسی درج شده‌اند.
     */
@endphp
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-gradient-primary text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-eye ml-2"></i>
                        پیش‌نمایش قالب
                    </h4>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>نام قالب:</strong>
                            <span>{{ $template->name ?? '-' }}</span>
                        </div>
                        <div class="col-md-6">
                            <strong>دسته‌بندی:</strong>
                            <span>{{ $template->category_id ?? '-' }}</span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>رنگ اصلی:</strong>
                            <span style="display:inline-block;width:24px;height:24px;background:{{ $template->primary_color ?? '#007bff' }};border-radius:4px;vertical-align:middle;"></span>
                            <span>{{ $template->primary_color ?? '-' }}</span>
                        </div>
                        <div class="col-md-6">
                            <strong>رنگ فرعی:</strong>
                            <span style="display:inline-block;width:24px;height:24px;background:{{ $template->secondary_color ?? '#6c757d' }};border-radius:4px;vertical-align:middle;"></span>
                            <span>{{ $template->secondary_color ?? '-' }}</span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>فونت:</strong>
                            <span>{{ $template->font_family ?? 'پیش‌فرض' }}</span>
                        </div>
                        <div class="col-md-6">
                            <strong>نوع قالب:</strong>
                            <span>{{ $template->template_type ?? 'پیش‌فرض' }}</span>
                        </div>
                    </div>
                    <hr>
                    <h5 class="mb-3"><i class="fas fa-cogs ml-1"></i> ویژگی‌های فعال</h5>
                    <div class="row">
                        @if(!empty($template->features) && is_array($template->features))
                            @foreach($template->features as $feature => $settings)
                                @if(isset($settings['is_enabled']) && $settings['is_enabled'])
                                    <div class="col-md-4 mb-2">
                                        <div class="alert alert-success p-2">
                                            <i class="fas fa-check-circle ml-1"></i>
                                            <strong>{{ $feature }}</strong>
                                            @if(!empty($settings['settings']) && is_array($settings['settings']))
                                                <ul class="mb-0 mt-1 pl-3">
                                                    @foreach($settings['settings'] as $key => $val)
                                                        <li><span class="text-muted">{{ $key }}:</span> <span>{{ is_bool($val) ? ($val ? 'بله' : 'خیر') : $val }}</span></li>
                                                    @endforeach
                                                </ul>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        @else
                            <div class="col-12">
                                <div class="alert alert-warning">هیچ ویژگی فعالی انتخاب نشده است.</div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 