@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/categories">دسته‌بندی‌ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $category->getTranslatedName(app()->getLocale()) }}</li>
                </ol>
            </nav>

            <div class="d-flex align-items-center mb-4">
                @if($category->emoji)
                    <span class="fs-2 me-3">{{ $category->emoji }}</span>
                @elseif($category->font_icon)
                    <i class="fas fa-{{ $category->font_icon }} fs-2 me-3"></i>
                @endif
                <h1 class="mb-0">{{ $category->getTranslatedName(app()->getLocale()) }}</h1>
            </div>

            @if($category->getTranslatedDescription(app()->getLocale()))
                <p class="lead text-muted mb-4">{{ $category->getTranslatedDescription(app()->getLocale()) }}</p>
            @endif

            {{-- فیلتر جغرافیایی --}}
            <x-geographic-filter :countries="$countries" />

            @if($childCategories->count() > 0)
                <div class="row mb-4">
                    @foreach($childCategories as $child)
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        @if($child->emoji)
                                            <span class="me-2">{{ $child->emoji }}</span>
                                        @elseif($child->font_icon)
                                            <i class="fas fa-{{ $child->font_icon }} me-2"></i>
                                        @endif
                                        {{ $child->getTranslatedName(app()->getLocale()) }}
                                    </h5>
                                    @if($child->getTranslatedDescription(app()->getLocale()))
                                        <p class="card-text text-muted">{{ $child->getTranslatedDescription(app()->getLocale()) }}</p>
                                    @endif
                                    <a href="{{ route('categories.show', $child->category_key) }}" class="btn btn-primary">
                                        مشاهده مکان‌ها
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif

            <div class="row">
                <div class="col-12">
                    <h3 class="mb-3">مکان‌ها</h3>
                    @if($locations->count() > 0)
                        <div class="row">
                            @foreach($locations as $location)
                                <div class="col-md-4 mb-4">
                                    <div class="card h-100">
                                        @if($location->image)
                                            <img src="{{ asset('storage/' . $location->image) }}" 
                                                 class="card-img-top" 
                                                 alt="{{ $location->title }}">
                                        @endif
                                        <div class="card-body">
                                            <h5 class="card-title">{{ $location->title }}</h5>
                                            <p class="card-text mb-1"><strong>دسته‌بندی:</strong> {{ $location->category_fa }}</p>
                                            @if($location->address)
                                                <p class="card-text mb-1"><strong>آدرس:</strong> {{ $location->address }}</p>
                                            @endif
                                            @if($location->phone)
                                                <p class="card-text mb-1"><strong>تلفن:</strong> {{ $location->phone }}</p>
                                            @endif
                                            @if($location->open_hours)
                                                <p class="card-text mb-1"><strong>ساعات کاری:</strong> {{ $location->open_hours }}</p>
                                            @endif
                                            @if($location->description)
                                                <p class="card-text text-muted">{{ Str::limit($location->description, 80) }}</p>
                                            @endif
                                            @php
                                                $categoryPath = '';
                                                if ($category->category_key === 'mall') {
                                                    $categoryPath = 'shopping_centers/mall';
                                                } elseif ($category->category_key === 'shopping_centers') {
                                                    $categoryPath = 'shopping_centers';
                                                } else {
                                                    $categoryPath = $category->category_key;
                                                }
                                            @endphp
                                            <a href="/{{ $categoryPath }}/{{ $location->title_id }}" 
                                               class="btn btn-primary mt-2">مشاهده جزئیات</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="d-flex justify-content-center mt-4">
                            @if ($locations->lastPage() > 1)
                                <nav aria-label="pagination">
                                    <ul class="pagination">
                                        @if ($locations->onFirstPage())
                                            <li class="page-item disabled"><span class="page-link">قبلی</span></li>
                                        @else
                                            <li class="page-item"><a class="page-link" href="{{ $locations->previousPageUrl() }}">قبلی</a></li>
                                        @endif
                                        @for ($i = 1; $i <= $locations->lastPage(); $i++)
                                            <li class="page-item {{ $i == $locations->currentPage() ? 'active' : '' }}">
                                                <a class="page-link" href="{{ $locations->url($i) }}">{{ $i }}</a>
                                            </li>
                                        @endfor
                                        @if ($locations->hasMorePages())
                                            <li class="page-item"><a class="page-link" href="{{ $locations->nextPageUrl() }}">بعدی</a></li>
                                        @else
                                            <li class="page-item disabled"><span class="page-link">بعدی</span></li>
                                        @endif
                                    </ul>
                                </nav>
                            @endif
                        </div>
                    @else
                        <div class="alert alert-info">
                            هیچ مکانی در این دسته‌بندی یافت نشد.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// تابع به‌روزرسانی نتایج بر اساس فیلترهای جغرافیایی
function updateResults() {
    // ساخت پارامترهای URL بر اساس فیلترهای فعال
    const params = new URLSearchParams();
    
    if (activeGeoFilters.country) params.append('country', activeGeoFilters.country);
    if (activeGeoFilters.province) params.append('province', activeGeoFilters.province);
    if (activeGeoFilters.county) params.append('county', activeGeoFilters.county);
    if (activeGeoFilters.district) params.append('district', activeGeoFilters.district);
    if (activeGeoFilters.city) params.append('city', activeGeoFilters.city);
    if (activeGeoFilters.village) params.append('village', activeGeoFilters.village);
    if (activeGeoFilters.zone) params.append('zone', activeGeoFilters.zone);
    
    // به‌روزرسانی URL بدون بارگذاری مجدد صفحه
    const newUrl = window.location.pathname + (params.toString() ? '?' + params.toString() : '');
    window.history.pushState({}, '', newUrl);
    
    // در اینجا می‌توانید درخواست AJAX برای فیلتر کردن مکان‌ها ارسال کنید
    // یا صفحه را مجدداً بارگذاری کنید
    // window.location.reload();
}
</script>
@endpush

@push('styles')
<style>
    .card {
        transition: transform 0.2s;
        border: none;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .card:hover {
        transform: translateY(-5px);
    }

    .card-img-top {
        height: 200px;
        object-fit: cover;
    }

    .card-title {
        color: #333;
    }

    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin-bottom: 1rem;
    }

    .breadcrumb-item + .breadcrumb-item::before {
        content: ">";
    }
</style>
@endpush