@extends('layouts.user')

@section('title', 'پروفایل کاربری')

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.min.js" rel="preload" as="script">
<style>
    /* Modern Profile Styles */
    .profile-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 2rem 0;
    }

    .profile-header {
        background: white;
        border-radius: 20px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
    }

    .profile-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 120px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        z-index: 1;
    }

    .profile-avatar-section {
        position: relative;
        z-index: 2;
        text-align: center;
        margin-top: 60px;
    }

    .profile-avatar {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        border: 5px solid white;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        margin: 0 auto;
        position: relative;
        overflow: hidden;
        background: white;
    }

    .profile-avatar img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .profile-avatar-edit {
        position: absolute;
        bottom: 5px;
        right: 5px;
        background: #667eea;
        color: white;
        border: none;
        border-radius: 50%;
        width: 35px;
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    }

    .profile-avatar-edit:hover {
        background: #5a67d8;
        transform: scale(1.1);
    }

    .profile-info {
        text-align: center;
        margin-top: 1.5rem;
    }

    .profile-name {
        font-size: 2rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .profile-username {
        color: #718096;
        font-size: 1.1rem;
        margin-bottom: 1rem;
    }

    .profile-badges {
        display: flex;
        justify-content: center;
        gap: 0.5rem;
        margin-bottom: 1.5rem;
        flex-wrap: wrap;
    }

    .profile-badge {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 25px;
        font-size: 0.875rem;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
    }

    .profile-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 1rem;
        margin-top: 2rem;
    }

    .profile-stat {
        text-align: center;
        padding: 1rem;
        background: #f7fafc;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .profile-stat:hover {
        background: #edf2f7;
        transform: translateY(-2px);
    }

    .profile-stat-number {
        font-size: 1.5rem;
        font-weight: 700;
        color: #667eea;
        display: block;
    }

    .profile-stat-label {
        font-size: 0.875rem;
        color: #718096;
        margin-top: 0.25rem;
    }

    .modern-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .modern-card:hover {
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .card-header-modern {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f1f5f9;
    }

    .card-title-modern {
        font-size: 1.25rem;
        font-weight: 700;
        color: #2d3748;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .card-title-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
    }

    .modern-form-group {
        margin-bottom: 1.5rem;
    }

    .modern-label {
        display: block;
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
    }

    .modern-input {
        width: 100%;
        padding: 0.875rem 1rem;
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .modern-input:focus {
        outline: none;
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .modern-input:disabled {
        background: #f3f4f6;
        color: #9ca3af;
        cursor: not-allowed;
    }

    .modern-btn {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border: none;
        padding: 0.875rem 2rem;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
    }

    .modern-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        color: white;
        text-decoration: none;
    }

    .modern-btn-secondary {
        background: #6b7280;
    }

    .modern-btn-secondary:hover {
        background: #4b5563;
        box-shadow: 0 8px 25px rgba(107, 114, 128, 0.3);
    }

    .achievement-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 1rem;
    }

    .achievement-card {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        border: 2px solid #f1f5f9;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .achievement-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, #667eea, #764ba2);
    }

    .achievement-card:hover {
        border-color: #667eea;
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.15);
    }

    .achievement-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin-bottom: 1rem;
    }

    .achievement-title {
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .achievement-description {
        color: #718096;
        font-size: 0.875rem;
        margin-bottom: 1rem;
    }

    .achievement-date {
        font-size: 0.75rem;
        color: #a0aec0;
    }

    .timeline {
        position: relative;
    }

    .timeline::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e5e7eb;
    }

    .timeline-item {
        position: relative;
        padding-left: 60px;
        margin-bottom: 2rem;
    }

    .timeline-icon {
        position: absolute;
        left: 0;
        top: 0;
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1rem;
        box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
    }

    .timeline-content {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        border: 1px solid #f1f5f9;
    }

    .timeline-title {
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .timeline-description {
        color: #718096;
        margin-bottom: 0.75rem;
    }

    .timeline-date {
        font-size: 0.75rem;
        color: #a0aec0;
    }

    .chart-container {
        position: relative;
        height: 300px;
        margin: 1rem 0;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 2rem;
    }

    .stat-card {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        text-align: center;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        border: 1px solid #f1f5f9;
        transition: all 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin: 0 auto 1rem;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .stat-label {
        color: #718096;
        font-size: 0.875rem;
    }

    .stat-growth {
        font-size: 0.75rem;
        margin-top: 0.5rem;
    }

    .stat-growth.positive {
        color: #10b981;
    }

    .stat-growth.negative {
        color: #ef4444;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .profile-container {
            padding: 1rem 0;
        }

        .profile-header {
            margin: 1rem;
            padding: 1.5rem;
        }

        .profile-name {
            font-size: 1.5rem;
        }

        .profile-stats {
            grid-template-columns: repeat(2, 1fr);
        }

        .achievement-grid {
            grid-template-columns: 1fr;
        }

        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .timeline-item {
            padding-left: 50px;
        }

        .timeline-icon {
            width: 35px;
            height: 35px;
            font-size: 0.875rem;
        }

        .timeline::before {
            left: 17px;
        }
    }

    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .modern-card {
        animation: fadeInUp 0.6s ease forwards;
    }

    .modern-card:nth-child(1) { animation-delay: 0.1s; }
    .modern-card:nth-child(2) { animation-delay: 0.2s; }
    .modern-card:nth-child(3) { animation-delay: 0.3s; }
    .modern-card:nth-child(4) { animation-delay: 0.4s; }
</style>
@endsection

@section('content')
<div class="profile-container">
    <div class="container-fluid">
        <!-- Profile Header -->
        <div class="profile-header">
            <div class="profile-avatar-section">
                <div class="profile-avatar">
                    <img src="https://ui-avatars.com/api/?name={{ urlencode($user->full_name) }}&background=667eea&color=fff&size=200" alt="{{ $user->full_name }}">
                    <button class="profile-avatar-edit" onclick="document.getElementById('avatar-upload').click()">
                        <i class="fas fa-camera"></i>
                    </button>
                    <input type="file" id="avatar-upload" style="display: none;" accept="image/*">
                </div>

                <div class="profile-info">
                    <h1 class="profile-name">{{ $user->full_name }}</h1>
                    <div class="profile-username">
                        <i class="fas fa-at"></i> {{ $user->username }}
                    </div>

                    <div class="profile-badges">
                        <span class="profile-badge">
                            <i class="fas fa-user"></i>
                            {{ $user->role == 'admin' ? 'مدیر' : 'کاربر' }}
                        </span>
                        <span class="profile-badge">
                            <i class="fas fa-{{ $user->status == 'active' ? 'check-circle' : 'times-circle' }}"></i>
                            {{ $user->status == 'active' ? 'فعال' : 'غیرفعال' }}
                        </span>
                        @if($user->email_verified_at)
                        <span class="profile-badge">
                            <i class="fas fa-shield-alt"></i>
                            تایید شده
                        </span>
                        @endif
                    </div>

                    <div class="profile-stats">
                        <div class="profile-stat">
                            <span class="profile-stat-number">{{ $stats['total_locations'] }}</span>
                            <span class="profile-stat-label">مکان ثبت شده</span>
                        </div>
                        <div class="profile-stat">
                            <span class="profile-stat-number">{{ $stats['total_ratings'] }}</span>
                            <span class="profile-stat-label">نظر ثبت شده</span>
                        </div>
                        <div class="profile-stat">
                            <span class="profile-stat-number">{{ number_format($stats['avg_rating'], 1) }}</span>
                            <span class="profile-stat-label">میانگین امتیاز</span>
                        </div>
                        <div class="profile-stat">
                            <span class="profile-stat-number">{{ $user->created_at->diffInDays(now()) }}</span>
                            <span class="profile-stat-label">روز عضویت</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Statistics Cards -->
            <div class="col-12 mb-4">
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="stat-number">{{ $stats['total_locations'] }}</div>
                        <div class="stat-label">مکان‌های ثبت شده</div>
                        @if($stats['locations_growth'] > 0)
                        <div class="stat-growth positive">
                            <i class="fas fa-arrow-up"></i> +{{ $stats['locations_growth'] }}%
                        </div>
                        @endif
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="stat-number">{{ $stats['active_locations'] }}</div>
                        <div class="stat-label">مکان‌های فعال</div>
                        <div class="stat-growth">
                            {{ $stats['pending_locations'] }} در انتظار تایید
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-star"></i>
                        </div>
                        <div class="stat-number">{{ $stats['total_ratings'] }}</div>
                        <div class="stat-label">نظرات ثبت شده</div>
                        @if($stats['ratings_growth'] > 0)
                        <div class="stat-growth positive">
                            <i class="fas fa-arrow-up"></i> +{{ $stats['ratings_growth'] }}%
                        </div>
                        @endif
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-eye"></i>
                        </div>
                        <div class="stat-number">{{ number_format($stats['total_views']) }}</div>
                        <div class="stat-label">بازدید کل</div>
                        <div class="stat-growth">
                            {{ $stats['approved_ratings'] }} نظر تایید شده
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Edit Profile Card -->
                <div class="modern-card">
                    <div class="card-header-modern">
                        <div class="card-title-modern">
                            <div class="card-title-icon">
                                <i class="fas fa-user-edit"></i>
                            </div>
                            ویرایش اطلاعات شخصی
                        </div>
                    </div>

                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    <form method="POST" action="{{ route('user.profile.update') }}">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label" for="full_name">نام و نام خانوادگی</label>
                                    <input type="text"
                                           class="modern-input @error('full_name') is-invalid @enderror"
                                           id="full_name"
                                           name="full_name"
                                           value="{{ old('full_name', $user->full_name) }}"
                                           required>
                                    @error('full_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label" for="username">نام کاربری</label>
                                    <input type="text"
                                           class="modern-input"
                                           id="username"
                                           value="{{ $user->username }}"
                                           disabled>
                                    <small class="text-muted">نام کاربری قابل تغییر نیست</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label" for="email">آدرس ایمیل</label>
                                    <input type="email"
                                           class="modern-input @error('email') is-invalid @enderror"
                                           id="email"
                                           name="email"
                                           value="{{ old('email', $user->email) }}"
                                           required>
                                    @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label" for="phone">شماره تماس</label>
                                    <input type="tel"
                                           class="modern-input"
                                           id="phone"
                                           name="phone"
                                           value="{{ old('phone', $user->phone) }}"
                                           placeholder="09123456789">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label">وضعیت حساب</label>
                                    <input type="text"
                                           class="modern-input"
                                           value="{{ $user->status == 'active' ? 'فعال' : 'غیرفعال' }}"
                                           disabled>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-label">تاریخ عضویت</label>
                                    <input type="text"
                                           class="modern-input"
                                           value="{{ $user->created_at ? \App\Helpers\DateHelper::formatDateTimeByLocale($user->created_at) : 'نامشخص' }}"
                                           disabled>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <a href="{{ route('user.change-password') }}" class="modern-btn modern-btn-secondary">
                                <i class="fas fa-key"></i>
                                تغییر رمز عبور
                            </a>

                            <button type="submit" class="modern-btn">
                                <i class="fas fa-save"></i>
                                ذخیره تغییرات
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Activity Chart -->
                <div class="modern-card">
                    <div class="card-header-modern">
                        <div class="card-title-modern">
                            <div class="card-title-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            نمودار فعالیت ماهانه
                        </div>
                    </div>

                    <div class="chart-container">
                        <canvas id="activityChart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- User Info Card -->
                <div class="modern-card">
                    <div class="card-header-modern">
                        <div class="card-title-modern">
                            <div class="card-title-icon">
                                <i class="fas fa-info-circle"></i>
                            </div>
                            اطلاعات حساب
                        </div>
                    </div>

                    <div class="space-y-3">
                        <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                            <span class="text-muted">
                                <i class="fas fa-envelope me-2"></i>ایمیل
                            </span>
                            <span class="fw-bold">{{ $user->email }}</span>
                        </div>

                        <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                            <span class="text-muted">
                                <i class="fas fa-calendar-alt me-2"></i>تاریخ عضویت
                            </span>
                            <span class="fw-bold">{{ $user->created_at ? \App\Helpers\DateHelper::formatByLocale($user->created_at) : 'نامشخص' }}</span>
                        </div>

                        <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                            <span class="text-muted">
                                <i class="fas fa-clock me-2"></i>آخرین ورود
                            </span>
                            <span class="fw-bold">{{ $user->last_login ? jdate($user->last_login)->format('Y/m/d H:i') : 'نامشخص' }}</span>
                        </div>

                        @if($user->phone)
                        <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                            <span class="text-muted">
                                <i class="fas fa-phone me-2"></i>شماره تماس
                            </span>
                            <span class="fw-bold">{{ $user->phone }}</span>
                        </div>
                        @endif

                        <div class="d-flex justify-content-between align-items-center py-2">
                            <span class="text-muted">
                                <i class="fas fa-shield-alt me-2"></i>وضعیت تایید
                            </span>
                            <span class="badge {{ $user->email_verified_at ? 'bg-success' : 'bg-warning' }}">
                                {{ $user->email_verified_at ? 'تایید شده' : 'تایید نشده' }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Achievements Card -->
                <div class="modern-card">
                    <div class="card-header-modern">
                        <div class="card-title-modern">
                            <div class="card-title-icon">
                                <i class="fas fa-trophy"></i>
                            </div>
                            دستاوردها
                        </div>
                    </div>

                    @if(count($achievements) > 0)
                    <div class="achievement-grid">
                        @foreach(array_slice($achievements, 0, 4) as $achievement)
                        <div class="achievement-card">
                            <div class="achievement-icon">
                                <i class="{{ $achievement['icon'] }}"></i>
                            </div>
                            <div class="achievement-title">{{ $achievement['title'] }}</div>
                            <div class="achievement-description">{{ $achievement['description'] }}</div>
                            <div class="achievement-date">
                                {{ $achievement['earned_at'] ? jdate($achievement['earned_at'])->format('Y/m/d') : '' }}
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-trophy text-muted" style="font-size: 3rem;"></i>
                        <p class="text-muted mt-3">هنوز دستاوردی کسب نکرده‌اید</p>
                        <small class="text-muted">با ثبت مکان و نظر، دستاوردهای جدید کسب کنید</small>
                    </div>
                    @endif
                </div>

                <!-- Recent Activity -->
                <div class="modern-card">
                    <div class="card-header-modern">
                        <div class="card-title-modern">
                            <div class="card-title-icon">
                                <i class="fas fa-history"></i>
                            </div>
                            فعالیت‌های اخیر
                        </div>
                    </div>

                    @if(count($activityTimeline) > 0)
                    <div class="timeline">
                        @foreach(array_slice($activityTimeline, 0, 5) as $activity)
                        <div class="timeline-item">
                            <div class="timeline-icon">
                                <i class="{{ $activity['icon'] }}"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ $activity['title'] }}</div>
                                <div class="timeline-description">{{ $activity['description'] }}</div>
                                <div class="timeline-date">
                                    @dateRelative($activity['date'])
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-history text-muted" style="font-size: 3rem;"></i>
                        <p class="text-muted mt-3">هنوز فعالیتی ثبت نشده است</p>
                        <a href="{{ route('user.locations.create') }}" class="modern-btn mt-2">
                            <i class="fas fa-plus"></i>
                            ثبت اولین مکان
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Modern Profile Handler
    class ModernProfile {
        constructor() {
            this.init();
        }

        init() {
            this.initializeChart();
            this.initializeAvatarUpload();
            this.initializeFormValidation();
            this.initializeAnimations();
        }

        // Initialize Activity Chart
        initializeChart() {
            const ctx = document.getElementById('activityChart');
            if (!ctx) return;

            const monthlyData = @json($monthlyActivity);

            const labels = monthlyData.map(item => {
                const date = new Date(item.month + '-01');
                return date.toLocaleDateString('fa-IR', { month: 'long', year: 'numeric' });
            });

            const locationsData = monthlyData.map(item => item.locations);
            const ratingsData = monthlyData.map(item => item.ratings);

            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'مکان‌های ثبت شده',
                        data: locationsData,
                        borderColor: '#667eea',
                        backgroundColor: 'rgba(102, 126, 234, 0.1)',
                        borderWidth: 3,
                        fill: true,
                        tension: 0.4,
                        pointBackgroundColor: '#667eea',
                        pointBorderColor: '#ffffff',
                        pointBorderWidth: 2,
                        pointRadius: 6,
                        pointHoverRadius: 8
                    }, {
                        label: 'نظرات ثبت شده',
                        data: ratingsData,
                        borderColor: '#764ba2',
                        backgroundColor: 'rgba(118, 75, 162, 0.1)',
                        borderWidth: 3,
                        fill: true,
                        tension: 0.4,
                        pointBackgroundColor: '#764ba2',
                        pointBorderColor: '#ffffff',
                        pointBorderWidth: 2,
                        pointRadius: 6,
                        pointHoverRadius: 8
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                usePointStyle: true,
                                padding: 20,
                                font: {
                                    family: 'IRANSans',
                                    size: 12
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            titleColor: '#ffffff',
                            bodyColor: '#ffffff',
                            borderColor: '#667eea',
                            borderWidth: 1,
                            cornerRadius: 8,
                            displayColors: true,
                            titleFont: {
                                family: 'IRANSans',
                                size: 14
                            },
                            bodyFont: {
                                family: 'IRANSans',
                                size: 12
                            }
                        }
                    },
                    scales: {
                        x: {
                            grid: {
                                display: false
                            },
                            ticks: {
                                font: {
                                    family: 'IRANSans',
                                    size: 11
                                },
                                color: '#6b7280'
                            }
                        },
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            },
                            ticks: {
                                font: {
                                    family: 'IRANSans',
                                    size: 11
                                },
                                color: '#6b7280'
                            }
                        }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'index'
                    },
                    elements: {
                        point: {
                            hoverBackgroundColor: '#ffffff'
                        }
                    }
                }
            });
        }

        // Initialize Avatar Upload
        initializeAvatarUpload() {
            const avatarUpload = document.getElementById('avatar-upload');
            const avatarImg = document.querySelector('.profile-avatar img');

            if (avatarUpload && avatarImg) {
                avatarUpload.addEventListener('change', (e) => {
                    const file = e.target.files[0];
                    if (file) {
                        if (file.size > 2 * 1024 * 1024) {
                            this.showNotification('حجم فایل نباید بیش از 2MB باشد', 'error');
                            return;
                        }

                        if (!file.type.startsWith('image/')) {
                            this.showNotification('لطفاً یک فایل تصویری انتخاب کنید', 'error');
                            return;
                        }

                        const reader = new FileReader();
                        reader.onload = (e) => {
                            avatarImg.src = e.target.result;
                            this.showNotification('تصویر پروفایل با موفقیت تغییر کرد', 'success');
                        };
                        reader.readAsDataURL(file);
                    }
                });
            }
        }

        // Initialize Form Validation
        initializeFormValidation() {
            const form = document.querySelector('form[action*="profile.update"]');
            if (!form) return;

            const inputs = form.querySelectorAll('.modern-input[required]');

            inputs.forEach(input => {
                input.addEventListener('blur', () => {
                    this.validateField(input);
                });

                input.addEventListener('input', () => {
                    this.clearFieldError(input);
                });
            });

            form.addEventListener('submit', (e) => {
                let isValid = true;

                inputs.forEach(input => {
                    if (!this.validateField(input)) {
                        isValid = false;
                    }
                });

                if (!isValid) {
                    e.preventDefault();
                    this.showNotification('لطفاً خطاهای فرم را برطرف کنید', 'error');
                }
            });
        }

        validateField(field) {
            const value = field.value.trim();
            let isValid = true;

            if (field.hasAttribute('required') && !value) {
                this.showFieldError(field, 'این فیلد الزامی است');
                isValid = false;
            } else if (field.type === 'email' && value && !this.isValidEmail(value)) {
                this.showFieldError(field, 'فرمت ایمیل صحیح نیست');
                isValid = false;
            } else {
                this.clearFieldError(field);
            }

            return isValid;
        }

        showFieldError(field, message) {
            field.classList.add('is-invalid');

            let errorElement = field.parentNode.querySelector('.invalid-feedback');
            if (!errorElement) {
                errorElement = document.createElement('div');
                errorElement.className = 'invalid-feedback';
                field.parentNode.appendChild(errorElement);
            }

            errorElement.textContent = message;
        }

        clearFieldError(field) {
            field.classList.remove('is-invalid');
            const errorElement = field.parentNode.querySelector('.invalid-feedback');
            if (errorElement) {
                errorElement.remove();
            }
        }

        isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        // Initialize Animations
        initializeAnimations() {
            // Animate stats on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        this.animateNumber(entry.target);
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            document.querySelectorAll('.stat-number, .profile-stat-number').forEach(el => {
                observer.observe(el);
            });

            // Hover effects for cards
            document.querySelectorAll('.modern-card, .stat-card, .achievement-card').forEach(card => {
                card.addEventListener('mouseenter', () => {
                    card.style.transform = 'translateY(-5px)';
                });

                card.addEventListener('mouseleave', () => {
                    card.style.transform = 'translateY(0)';
                });
            });
        }

        animateNumber(element) {
            const finalNumber = parseInt(element.textContent.replace(/[^\d]/g, ''));
            const duration = 2000;
            const increment = finalNumber / (duration / 16);
            let current = 0;

            const timer = setInterval(() => {
                current += increment;
                if (current >= finalNumber) {
                    current = finalNumber;
                    clearInterval(timer);
                }

                element.textContent = Math.floor(current).toLocaleString('fa-IR');
            }, 16);
        }

        // Show Notification
        showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `notification notification-${type}`;
            notification.innerHTML = `
                <div class="notification-content">
                    <i class="fas fa-${this.getNotificationIcon(type)}"></i>
                    <span>${message}</span>
                </div>
                <button class="notification-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            `;

            document.body.appendChild(notification);

            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        }

        getNotificationIcon(type) {
            switch (type) {
                case 'success': return 'check-circle';
                case 'error': return 'exclamation-circle';
                case 'warning': return 'exclamation-triangle';
                default: return 'info-circle';
            }
        }
    }

    // Initialize Profile
    new ModernProfile();
});
</script>

<!-- Notification Styles -->
<style>
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    z-index: 10000;
    min-width: 300px;
    animation: slideInRight 0.3s ease;
}

.notification-success {
    border-left: 4px solid #10b981;
}

.notification-error {
    border-left: 4px solid #ef4444;
}

.notification-warning {
    border-left: 4px solid #f59e0b;
}

.notification-info {
    border-left: 4px solid #3b82f6;
}

.notification-content {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.notification-content i {
    font-size: 1.25rem;
}

.notification-success .notification-content i {
    color: #10b981;
}

.notification-error .notification-content i {
    color: #ef4444;
}

.notification-warning .notification-content i {
    color: #f59e0b;
}

.notification-info .notification-content i {
    color: #3b82f6;
}

.notification-close {
    background: none;
    border: none;
    color: #6b7280;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
    transition: all 0.2s ease;
}

.notification-close:hover {
    background: #f3f4f6;
    color: #374151;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

.invalid-feedback {
    display: block;
    width: 100%;
    margin-top: 0.25rem;
    font-size: 0.875rem;
    color: #ef4444;
}

.modern-input.is-invalid {
    border-color: #ef4444;
    box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
}
</style>
@endsection