<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="DENY">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <meta http-equiv="Referrer-Policy" content="strict-origin-when-cross-origin">
    <title>ورود به پنل مدیریت - سیستم مدیریت مکان‌ها</title>
    <meta name="description" content="ورود به پنل مدیریت سیستم مدیریت مکان‌ها و رتبه‌بندی">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin-login-modern.css')); ?>">

    <!-- Preload critical resources -->
    <link rel="preload" href="<?php echo e(asset('css/fonts.css')); ?>" as="style">
    <link rel="preload" href="<?php echo e(asset('css/admin-login-modern.css')); ?>" as="style">

    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 15px 35px rgba(0, 0, 0, 0.1);
            --border-radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><defs><radialGradient id="a" cx="50%" cy="50%"><stop offset="0%" stop-color="%23ffffff" stop-opacity="0.1"/><stop offset="100%" stop-color="%23ffffff" stop-opacity="0"/></radialGradient></defs><circle cx="200" cy="200" r="100" fill="url(%23a)"/><circle cx="800" cy="300" r="150" fill="url(%23a)"/><circle cx="400" cy="700" r="120" fill="url(%23a)"/></svg>') no-repeat center center;
            background-size: cover;
            animation: float 20s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        .main-container {
            display: grid;
            grid-template-columns: 1fr 400px;
            gap: 2rem;
            width: 100%;
            max-width: 1200px;
            padding: 2rem;
            align-items: center;
        }

        /* Stats Panel */
        .stats-panel {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow-light);
            animation: slideInLeft 0.8s ease-out;
        }

        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .stats-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .stats-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .stats-header p {
            opacity: 0.9;
            font-size: 1rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .stat-card:hover::before {
            left: 100%;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .stat-icon {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            color: white;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .stat-number {
            font-size: 1.5rem;
            font-weight: 700;
            color: white;
            margin-bottom: 0.25rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .stat-label {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.9);
            font-weight: 500;
        }

        .system-status {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1rem;
            margin-top: 1rem;
        }

        .status-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            color: white;
            font-size: 0.9rem;
        }

        .status-indicator {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #4ade80;
            box-shadow: 0 0 8px #4ade80;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        /* Login Container */
        .login-container {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInRight 0.8s ease-out;
            position: relative;
            overflow: hidden;
        }

        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .login-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
            pointer-events: none;
        }

        .login-header {
            text-align: center;
            margin-bottom: 2rem;
            position: relative;
            z-index: 1;
        }

        .login-header .icon {
            background: var(--primary-gradient);
            color: white;
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 2rem;
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
            animation: iconPulse 2s ease-in-out infinite;
        }

        @keyframes iconPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        .login-header h1 {
            color: white;
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .login-header p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 1rem;
            margin: 0;
        }

        /* Form Styles */
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .input-group {
            position: relative;
            display: flex;
            align-items: stretch;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1rem 1.25rem;
            font-size: 1rem;
            color: #333;
            transition: var(--transition);
            border-left: none;
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.95);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }

        .form-control::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .input-group-text {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-right: none;
            border-radius: 12px;
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
            padding: 1rem;
            color: #667eea;
            font-size: 1.1rem;
            transition: var(--transition);
        }

        .form-control:focus + .input-group-text {
            border-color: rgba(102, 126, 234, 0.5);
            background: rgba(255, 255, 255, 0.95);
        }

        /* Button Styles */
        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            border-radius: 12px;
            padding: 1rem 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            color: white;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
        }

        .btn-primary:active {
            transform: translateY(0);
        }

        /* Loading State */
        .btn-primary:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }

        .btn-primary.loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            margin: auto;
            border: 2px solid transparent;
            border-top-color: #ffffff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Checkbox Styles */
        .form-check {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .form-check-input {
            width: 18px;
            height: 18px;
            margin-left: 0.5rem;
            border-radius: 4px;
            border: 2px solid rgba(255, 255, 255, 0.5);
            background: rgba(255, 255, 255, 0.1);
        }

        .form-check-input:checked {
            background: var(--primary-gradient);
            border-color: transparent;
        }

        .form-check-label {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
            cursor: pointer;
        }

        /* Alert Styles */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #e8f5e8;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }

        .alert-danger {
            background: rgba(244, 67, 54, 0.2);
            color: #ffebee;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }

        .alert ul {
            margin: 0;
            padding-right: 1rem;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .main-container {
                grid-template-columns: 1fr;
                gap: 1rem;
                padding: 1rem;
            }

            .stats-panel {
                order: 2;
                padding: 1.5rem;
            }

            .login-container {
                padding: 2rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .stats-header h2 {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 480px) {
            .main-container {
                padding: 0.5rem;
            }

            .login-container {
                padding: 1.5rem;
            }

            .stats-panel {
                padding: 1rem;
            }
        }

        /* Developer Credit Styles */
        .developer-credit {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 12px;
            padding: 0.75rem 1rem;
            color: white;
            font-size: 0.85rem;
            font-weight: 500;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: var(--transition);
            cursor: pointer;
            z-index: 1000;
        }

        .developer-credit:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        }

        .developer-credit .dev-icon {
            color: #4facfe;
            margin-left: 0.5rem;
            font-size: 1rem;
        }

        .developer-credit .dev-name {
            font-weight: 600;
            color: #ffffff;
        }

        .developer-credit .dev-role {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-top: 0.25rem;
        }
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            z-index: 1000;
            opacity: 0.8;
            animation: fadeInUp 1s ease-out 2s both;
        }

        .developer-credit:hover {
            opacity: 1;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            background: rgba(255, 255, 255, 0.25);
        }

        .developer-credit .dev-icon {
            display: inline-block;
            margin-left: 0.5rem;
            font-size: 1rem;
            color: #4ade80;
            text-shadow: 0 0 8px rgba(74, 222, 128, 0.5);
            animation: pulse 2s infinite;
        }

        .developer-credit .dev-name {
            font-weight: 600;
            background: linear-gradient(45deg, #4ade80, #22d3ee);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .developer-credit .dev-role {
            opacity: 0.9;
            font-size: 0.8rem;
            margin-top: 0.2rem;
            display: block;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 0.8;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .developer-credit {
                bottom: 10px;
                left: 10px;
                padding: 0.5rem 0.75rem;
                font-size: 0.8rem;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Stats Panel -->
        <div class="stats-panel">
            <div class="stats-header">
                <h2>آمار سیستم</h2>
                <p>وضعیت فعلی پلتفرم</p>
            </div>

            <div class="stats-grid">
                <div class="stat-card interactive-element">
                    <div class="stat-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="stat-number persian-numbers" id="locations-count">
                        <?php echo e($stats['locations'] ?? 0); ?>

                    </div>
                    <div class="stat-label">مکان‌ها</div>
                    <div class="stat-sublabel" style="font-size: 0.7rem; opacity: 0.8;">
                        <?php echo e($stats['active_locations'] ?? 0); ?> فعال
                    </div>
                </div>

                <div class="stat-card interactive-element">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-number persian-numbers" id="users-count">
                        <?php echo e($stats['users'] ?? 0); ?>

                    </div>
                    <div class="stat-label">کاربران</div>
                    <div class="stat-sublabel" style="font-size: 0.7rem; opacity: 0.8;">
                        ثبت‌نام شده
                    </div>
                </div>

                <div class="stat-card interactive-element">
                    <div class="stat-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-number persian-numbers" id="ratings-count">
                        <?php echo e($stats['ratings'] ?? 0); ?>

                    </div>
                    <div class="stat-label">رتبه‌بندی‌ها</div>
                    <div class="stat-sublabel" style="font-size: 0.7rem; opacity: 0.8;">
                        <?php echo e($stats['pending_ratings'] ?? 0); ?> در انتظار
                    </div>
                </div>

                <div class="stat-card interactive-element">
                    <div class="stat-icon">
                        <i class="fas fa-list"></i>
                    </div>
                    <div class="stat-number persian-numbers" id="categories-count">
                        <?php echo e($stats['categories'] ?? 0); ?>

                    </div>
                    <div class="stat-label">دسته‌بندی‌ها</div>
                    <div class="stat-sublabel" style="font-size: 0.7rem; opacity: 0.8;">
                        تعریف شده
                    </div>
                </div>
            </div>

            <div class="system-status">
                <div class="status-item">
                    <span>وضعیت سرور</span>
                    <div class="status-indicator status-<?php echo e($stats['system_status']['server'] ?? 'offline'); ?>"></div>
                </div>
                <div class="status-item">
                    <span>پایگاه داده</span>
                    <div class="status-indicator status-<?php echo e($stats['system_status']['database'] ?? 'offline'); ?>"></div>
                </div>
                <div class="status-item">
                    <span>کش سیستم</span>
                    <div class="status-indicator status-<?php echo e($stats['system_status']['cache'] ?? 'offline'); ?>"></div>
                </div>
                <div class="status-item">
                    <span>آخرین بروزرسانی</span>
                    <span style="font-size: 0.8rem;" id="last-update-time"><?php echo e($stats['last_updated'] ?? now()->format('H:i')); ?></span>
                </div>
            </div>
        </div>

        <!-- Login Form -->
        <div class="login-container">
            <div class="login-header">
                <div class="icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <h1>ورود به پنل مدیریت</h1>
                <p>لطفاً اطلاعات خود را وارد کنید</p>
            </div>

            <?php if(session('status')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('admin.login')); ?>" autocomplete="off" id="login-form">
                <?php echo csrf_field(); ?>

                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-user"></i>
                        </span>
                        <input id="username" type="text"
                               class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               name="username" value="<?php echo e(old('username')); ?>"
                               required autocomplete="username"
                               placeholder="نام کاربری"
                               maxlength="50"
                               pattern="[a-zA-Z0-9_\-]+"
                               title="نام کاربری فقط می‌تواند شامل حروف انگلیسی، اعداد، خط تیره و زیرخط باشد">
                    </div>
                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback d-block" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input id="password" type="password"
                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               name="password" required
                               autocomplete="current-password"
                               placeholder="رمز عبور"
                               minlength="8" maxlength="100">
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback d-block" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-check">
                    <input class="form-check-input" type="checkbox"
                           name="remember" id="remember"
                           <?php echo e(old('remember') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="remember">
                        مرا به خاطر بسپار
                    </label>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary w-100" id="login-button">
                        <span class="button-text">ورود</span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Developer Credit -->
    <div class="developer-credit" onclick="showDeveloperInfo()">
        <div class="d-flex align-items-center">
            <i class="fas fa-code dev-icon"></i>
            <div>
                <div class="dev-name">یوسف رجستری</div>
                <div class="dev-role">طراح و توسعه‌دهنده</div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('js/admin-login-modern.js')); ?>"></script>
    <script>
        // Enhanced login form handling
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('login-form');
            const button = document.getElementById('login-button');
            const buttonText = button.querySelector('.button-text');

            form.addEventListener('submit', function(e) {
                // Add loading state
                button.disabled = true;
                button.classList.add('loading');
                buttonText.textContent = 'در حال ورود...';

                // Add subtle animation to stats
                document.querySelectorAll('.stat-number').forEach(el => {
                    el.style.animation = 'pulse 1s ease-in-out infinite';
                });
            });

            // Auto-update stats (only if modern script not loaded)
            setTimeout(function() {
                if (!window.ModernLoginPage) {
                    console.log('🔄 Using fallback stats updater');
                    let fallbackStatsInterval = setInterval(function() {
                        fetch('/admin/api/quick-stats')
                            .then(response => response.json())
                            .then(data => {
                                if (data.locations) document.getElementById('locations-count').textContent = data.locations;
                                if (data.users) document.getElementById('users-count').textContent = data.users;
                                if (data.ratings) document.getElementById('ratings-count').textContent = data.ratings;
                                if (data.categories) document.getElementById('categories-count').textContent = data.categories;
                                console.log('📊 Fallback stats updated');
                            })
                            .catch(error => console.warn('⚠️ Fallback stats update failed:', error));
                    }, 120000); // 2 minutes for fallback

                    // Cleanup on page unload
                    window.addEventListener('beforeunload', function() {
                        if (fallbackStatsInterval) {
                            clearInterval(fallbackStatsInterval);
                        }
                    });
                }
            }, 2000); // Wait 2 seconds for modern script to load

            // Add input focus animations
            document.querySelectorAll('.form-control').forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.style.transform = 'scale(1.02)';
                });

                input.addEventListener('blur', function() {
                    this.parentElement.style.transform = 'scale(1)';
                });
            });
        });

        // Developer info function
        function showDeveloperInfo() {
            const modal = document.createElement('div');
            modal.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.8);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 10000;
                backdrop-filter: blur(8px);
                animation: fadeIn 0.3s ease;
            `;

            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    border-radius: 20px;
                    padding: 2rem;
                    text-align: center;
                    color: white;
                    max-width: 400px;
                    width: 90%;
                    box-shadow: 0 20px 40px rgba(0,0,0,0.3);
                    transform: scale(0.9);
                    animation: modalPop 0.3s ease forwards;
                ">
                    <div style="font-size: 3rem; margin-bottom: 1rem;">👨‍💻</div>
                    <h3 style="margin-bottom: 0.5rem; font-weight: 700;">یوسف رجستری</h3>
                    <p style="margin-bottom: 0.5rem; font-size: 1.1rem; color: #e0e7ff;">Yousof Rajestary</p>
                    <p style="margin-bottom: 1.5rem; opacity: 0.9;">طراح و توسعه‌دهنده سیستم</p>
                    <div style="background: rgba(255,255,255,0.1); border-radius: 12px; padding: 1rem; margin-bottom: 1.5rem;">
                        <p style="margin: 0; font-size: 0.9rem; line-height: 1.6;">
                            این پروژه از ایده تا پیاده‌سازی کامل توسط یوسف رجستری طراحی و توسعه یافته است.
                            شامل طراحی UI/UX، برنامه‌نویسی Backend و Frontend، و بهینه‌سازی عملکرد.
                        </p>
                    </div>
                    <button onclick="this.closest('div').parentElement.remove()" style="
                        background: rgba(255,255,255,0.2);
                        border: 1px solid rgba(255,255,255,0.3);
                        border-radius: 8px;
                        color: white;
                        padding: 0.5rem 1.5rem;
                        cursor: pointer;
                        transition: all 0.3s ease;
                    " onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                        بستن
                    </button>
                </div>
            `;

            modal.onclick = (e) => {
                if (e.target === modal) modal.remove();
            };

            document.body.appendChild(modal);
        }
    </script>

    <style>
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes modalPop {
            from { transform: scale(0.9); opacity: 0; }
            to { transform: scale(1); opacity: 1; }
        }
    </style>
</body>
</html><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>