

<?php $__env->startSection('title', 'درباره ما'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="about-hero">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="row align-items-center min-vh-50">
            <div class="col-lg-6">
                <div class="hero-content">
                    <h1 class="hero-title">
                        <span class="text-gradient">اَلو ایران</span>
                        <br>
                        <span class="hero-subtitle">مرجع جامع گردشگری ایران</span>
                    </h1>
                    <p class="hero-description">
                        سامانه‌ای مدرن و کامل برای کشف، معرفی و بررسی بهترین مکان‌های گردشگری، تفریحی، اقامتی و خدماتی سراسر ایران
                    </p>
                    <div class="hero-buttons">
                        <a href="<?php echo e(url('/map')); ?>" class="btn btn-primary btn-lg">
                            <i class="fas fa-map-marked-alt me-2"></i>
                            کاوش در نقشه
                        </a>
                        <a href="<?php echo e(url('/categories')); ?>" class="btn btn-outline-light btn-lg">
                            <i class="fas fa-th-large me-2"></i>
                            دسته‌بندی‌ها
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="hero-image">
                    <div class="floating-card">
                        <i class="fas fa-map-marked-alt"></i>
                        <h3><?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian(number_format($stats['total_locations'])) : number_format($stats['total_locations'])); ?></h3>
                        <p>مکان ثبت شده</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="statistics-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">آمار زنده سامانه</h2>
                <p class="section-subtitle">اعداد و ارقام واقعی از عملکرد اَلو ایران</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card modern-card">
                    <div class="stat-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_locations']); ?>">0</h3>
                        <p class="stat-label">مکان ثبت شده</p>
                        <div class="stat-growth">
                            <i class="fas fa-arrow-up"></i>
                            <span><?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($stats['recent_locations']) : $stats['recent_locations']); ?> در ماه گذشته</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card modern-card">
                    <div class="stat-icon">
                        <i class="fas fa-th-large"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_categories']); ?>">0</h3>
                        <p class="stat-label">دسته‌بندی فعال</p>
                        <div class="stat-growth">
                            <i class="fas fa-check-circle"></i>
                            <span>پوشش کامل</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card modern-card">
                    <div class="stat-icon">
                        <i class="fas fa-city"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_cities']); ?>">0</h3>
                        <p class="stat-label">شهر پوشش داده شده</p>
                        <div class="stat-growth">
                            <i class="fas fa-globe"></i>
                            <span><?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($stats['total_provinces']) : $stats['total_provinces']); ?> استان</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card modern-card">
                    <div class="stat-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_ratings']); ?>">0</h3>
                        <p class="stat-label">نظر کاربران</p>
                        <div class="stat-growth">
                            <i class="fas fa-heart"></i>
                            <span>میانگین <?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($stats['average_rating']) : $stats['average_rating']); ?> ستاره</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Stats Row -->
        <div class="row g-4 mt-4">
            <div class="col-lg-4 col-md-6">
                <div class="stat-card modern-card secondary">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_users']); ?>">0</h3>
                        <p class="stat-label">کاربر فعال</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="stat-card modern-card secondary">
                    <div class="stat-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['total_visits']); ?>">0</h3>
                        <p class="stat-label">بازدید کل</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="stat-card modern-card secondary">
                    <div class="stat-icon">
                        <i class="fas fa-gem"></i>
                    </div>
                    <div class="stat-content">
                        <h3 class="stat-number" data-target="<?php echo e($stats['diamond_locations']); ?>">0</h3>
                        <p class="stat-label">مکان الماسی</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Us Section -->
<section class="about-us-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-content">
                    <h2 class="section-title">درباره اَلو ایران</h2>
                    <p class="section-subtitle">داستان ما، ماموریت ما</p>

                    <div class="about-text">
                        <p class="lead">
                            اَلو ایران با هدف ایجاد یک پلتفرم جامع و مدرن برای معرفی زیبایی‌ها و جاذبه‌های گردشگری ایران راه‌اندازی شده است.
                        </p>

                        <p>
                            ما معتقدیم که ایران سرزمینی پر از گنج‌های پنهان، مکان‌های بی‌نظیر و تجربه‌های فراموش‌نشدنی است. هدف ما این است که این زیبایی‌ها را به بهترین شکل ممکن معرفی کنیم و به مسافران کمک کنیم تا بهترین انتخاب‌ها را داشته باشند.
                        </p>

                        <div class="mission-values">
                            <div class="mission-item">
                                <div class="mission-icon">
                                    <i class="fas fa-bullseye"></i>
                                </div>
                                <div class="mission-content">
                                    <h4>ماموریت ما</h4>
                                    <p>ایجاد پلی میان مسافران و بهترین مکان‌های ایران با ارائه اطلاعات دقیق و معتبر</p>
                                </div>
                            </div>

                            <div class="mission-item">
                                <div class="mission-icon">
                                    <i class="fas fa-heart"></i>
                                </div>
                                <div class="mission-content">
                                    <h4>ارزش‌های ما</h4>
                                    <p>صداقت، کیفیت، نوآوری و تعهد به ارائه بهترین خدمات به کاربران</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-visual">
                    <div class="visual-grid">
                        <div class="visual-item">
                            <img src="/images/about/iran-map.jpg" alt="نقشه ایران" class="img-fluid rounded">
                            <div class="visual-overlay">
                                <h5>پوشش سراسری</h5>
                                <p><?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($stats['total_provinces']) : $stats['total_provinces']); ?> استان</p>
                            </div>
                        </div>
                        <div class="visual-item">
                            <div class="feature-highlight">
                                <i class="fas fa-mobile-alt"></i>
                                <h5>دسترسی آسان</h5>
                                <p>در هر زمان و مکان</p>
                            </div>
                        </div>
                        <div class="visual-item">
                            <div class="feature-highlight">
                                <i class="fas fa-shield-alt"></i>
                                <h5>اطلاعات معتبر</h5>
                                <p>تایید شده و به‌روز</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="services-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">خدمات ما</h2>
                <p class="section-subtitle">آنچه اَلو ایران برای شما فراهم می‌کند</p>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-map-marked-alt"></i>
                    </div>
                    <div class="service-content">
                        <h4>نقشه تعاملی</h4>
                        <p>مشاهده دقیق موقعیت مکان‌ها روی نقشه با امکان جستجو و فیلتر پیشرفته</p>
                        <ul class="service-features">
                            <li>نمایش کلاسترینگ مکان‌ها</li>
                            <li>جستجوی پیشرفته</li>
                            <li>فیلتر بر اساس دسته‌بندی</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="service-content">
                        <h4>نظرات و امتیازدهی</h4>
                        <p>سیستم جامع نظرات کاربران با امکان امتیازدهی دقیق و نظرات تخصصی</p>
                        <ul class="service-features">
                            <li>امتیازدهی چندبعدی</li>
                            <li>نظرات تایید شده</li>
                            <li>پاسخ مدیران مکان‌ها</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-images"></i>
                    </div>
                    <div class="service-content">
                        <h4>گالری تصاویر</h4>
                        <p>مجموعه‌ای غنی از تصاویر با کیفیت بالا از هر مکان برای آشنایی بهتر</p>
                        <ul class="service-features">
                            <li>تصاویر با کیفیت بالا</li>
                            <li>نمایش ۳۶۰ درجه</li>
                            <li>گالری کاربران</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-info-circle"></i>
                    </div>
                    <div class="service-content">
                        <h4>اطلاعات کامل</h4>
                        <p>جزئیات دقیق و کامل از ساعات کاری، امکانات، قیمت‌ها و راه‌های دسترسی</p>
                        <ul class="service-features">
                            <li>اطلاعات تماس</li>
                            <li>ساعات کاری</li>
                            <li>امکانات و خدمات</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <div class="service-content">
                        <h4>اپلیکیشن موبایل</h4>
                        <p>دسترسی آسان و سریع از طریق اپلیکیشن موبایل با امکانات پیشرفته</p>
                        <ul class="service-features">
                            <li>رابط کاربری مدرن</li>
                            <li>عملکرد سریع</li>
                            <li>دسترسی آفلاین</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <div class="service-content">
                        <h4>پشتیبانی ۲۴/۷</h4>
                        <p>تیم پشتیبانی حرفه‌ای آماده پاسخگویی به سوالات و راهنمایی شما</p>
                        <ul class="service-features">
                            <li>پشتیبانی تلفنی</li>
                            <li>چت آنلاین</li>
                            <li>راهنمای کامل</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Timeline Section -->
<section class="timeline-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">مسیر پیشرفت ما</h2>
                <p class="section-subtitle">نگاهی به دستاوردها و نقاط عطف اَلو ایران</p>
            </div>
        </div>

        <div class="timeline">
            <?php $__currentLoopData = $achievements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $achievement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="timeline-item <?php echo e($index % 2 == 0 ? 'left' : 'right'); ?>">
                <div class="timeline-content">
                    <div class="timeline-icon">
                        <i class="<?php echo e($achievement['icon']); ?>"></i>
                    </div>
                    <div class="timeline-card">
                        <div class="timeline-date"><?php echo e($achievement['date']); ?></div>
                        <h4><?php echo e($achievement['title']); ?></h4>
                        <p><?php echo e($achievement['description']); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Popular Categories Section -->
<section class="popular-categories-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">دسته‌بندی‌های محبوب</h2>
                <p class="section-subtitle">پربازدیدترین دسته‌بندی‌های مکان‌ها در اَلو ایران</p>
            </div>
        </div>

        <div class="row g-4">
            <?php $__currentLoopData = $popularCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6">
                <div class="category-card">
                    <div class="category-icon">
                        <?php if($category->emoji): ?>
                            <span class="category-emoji"><?php echo e($category->emoji); ?></span>
                        <?php else: ?>
                            <i class="<?php echo e($category->font_icon ?? 'fas fa-map-marker-alt'); ?>"></i>
                        <?php endif; ?>
                    </div>
                    <div class="category-content">
                        <h4><?php echo e($category->category_fa); ?></h4>
                        <p class="category-count">
                            <?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian(number_format($category->locations_count)) : number_format($category->locations_count)); ?> مکان
                        </p>
                        <a href="<?php echo e(url('/categories/' . $category->id)); ?>" class="category-link">
                            مشاهده همه
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Top Provinces Section -->
<section class="top-provinces-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">استان‌های برتر</h2>
                <p class="section-subtitle">استان‌هایی با بیشترین مکان‌های ثبت شده</p>
            </div>
        </div>

        <div class="row g-4">
            <?php $__currentLoopData = $topProvinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-<?php echo e($index < 2 ? '6' : '4'); ?> col-md-6">
                <div class="province-card <?php echo e($index == 0 ? 'featured' : ''); ?>">
                    <div class="province-rank"><?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian($index + 1) : ($index + 1)); ?></div>
                    <div class="province-content">
                        <h4><?php echo e($province->name); ?></h4>
                        <p class="province-stats">
                            <span class="locations-count">
                                <?php echo e(app()->getLocale() === 'fa' ? \App\Helpers\NumberHelper::toPersian(number_format($province->locations_count)) : number_format($province->locations_count)); ?>

                            </span>
                            مکان ثبت شده
                        </p>
                        <?php if($province->center_city_name): ?>
                        <p class="province-center">مرکز: <?php echo e($province->center_city_name); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="province-progress">
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo e(min(100, ($province->locations_count / $topProvinces->first()->locations_count) * 100)); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="contact-content">
                    <h2 class="section-title">تماس با ما</h2>
                    <p class="section-subtitle">ما همیشه آماده شنیدن نظرات و پیشنهادات شما هستیم</p>

                    <div class="contact-info">
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="contact-details">
                                <h5>ایمیل</h5>
                                <p>info@aloiran.com</p>
                            </div>
                        </div>

                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="contact-details">
                                <h5>تلفن پشتیبانی</h5>
                                <p>۰۲۱-۱۲۳۴۵۶۷۸</p>
                            </div>
                        </div>

                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="contact-details">
                                <h5>ساعات کاری</h5>
                                <p>شنبه تا پنج‌شنبه: ۸:۰۰ - ۲۰:۰۰</p>
                            </div>
                        </div>
                    </div>

                    <div class="social-links">
                        <h5>ما را دنبال کنید</h5>
                        <div class="social-icons">
                            <a href="#" class="social-icon">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-telegram"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-linkedin"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-form-wrapper">
                    <form class="contact-form" action="<?php echo e(route('contact.submit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="name">نام و نام خانوادگی</label>
                            <input type="text" id="name" name="name" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="email">ایمیل</label>
                            <input type="email" id="email" name="email" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="phone">شماره تماس</label>
                            <input type="tel" id="phone" name="phone" class="form-control">
                        </div>

                        <div class="form-group">
                            <label for="subject">موضوع</label>
                            <select id="subject" name="subject" class="form-control" required>
                                <option value="">انتخاب کنید</option>
                                <option value="general">سوال عمومی</option>
                                <option value="support">پشتیبانی فنی</option>
                                <option value="business">همکاری تجاری</option>
                                <option value="suggestion">پیشنهاد</option>
                                <option value="complaint">شکایت</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="message">پیام</label>
                            <textarea id="message" name="message" class="form-control" rows="5" required></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg w-100">
                            <i class="fas fa-paper-plane me-2"></i>
                            ارسال پیام
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="cta-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="cta-content">
                    <h2>آماده کشف ایران هستید؟</h2>
                    <p>همین حالا شروع کنید و بهترین مکان‌های ایران را کشف کنید</p>
                    <div class="cta-buttons">
                        <a href="<?php echo e(url('/map')); ?>" class="btn btn-primary btn-lg">
                            <i class="fas fa-map-marked-alt me-2"></i>
                            شروع کاوش
                        </a>
                        <a href="<?php echo e(url('/add-place')); ?>" class="btn btn-outline-primary btn-lg">
                            <i class="fas fa-plus me-2"></i>
                            ثبت مکان جدید
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Modern About Page Styles */
.about-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
    overflow: hidden;
    padding: 100px 0;
    color: white;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.3);
}

.hero-content {
    position: relative;
    z-index: 2;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    line-height: 1.2;
}

.text-gradient {
    background: linear-gradient(45deg, #fff, #f8f9fa);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-subtitle {
    font-size: 1.8rem;
    font-weight: 300;
    opacity: 0.9;
}

.hero-description {
    font-size: 1.2rem;
    margin: 2rem 0;
    opacity: 0.9;
    line-height: 1.6;
}

.hero-buttons {
    margin-top: 2rem;
}

.hero-buttons .btn {
    margin: 0.5rem;
    padding: 12px 30px;
    border-radius: 50px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.floating-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    border: 1px solid rgba(255, 255, 255, 0.2);
    animation: float 6s ease-in-out infinite;
}

.floating-card i {
    font-size: 3rem;
    margin-bottom: 1rem;
    color: #ffd700;
}

.floating-card h3 {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

/* Statistics Section */
.statistics-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 1rem;
}

.section-subtitle {
    font-size: 1.1rem;
    color: #6c757d;
    margin-bottom: 3rem;
}

.stat-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
    height: 100%;
}

.stat-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.stat-card.secondary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.stat-icon {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    color: white;
    font-size: 2rem;
}

.stat-card.secondary .stat-icon {
    background: rgba(255, 255, 255, 0.2);
}

.stat-number {
    font-size: 3rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-family: 'IRANSans', sans-serif;
}

.stat-card.secondary .stat-number {
    color: white;
}

.stat-label {
    font-size: 1.1rem;
    color: #6c757d;
    margin-bottom: 1rem;
}

.stat-card.secondary .stat-label {
    color: rgba(255, 255, 255, 0.9);
}

.stat-growth {
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
    color: #28a745;
}

.stat-card.secondary .stat-growth {
    color: rgba(255, 255, 255, 0.8);
}

.stat-growth i {
    margin-left: 0.5rem;
}

/* About Us Section */
.about-us-section {
    padding: 80px 0;
    background: white;
}

.about-content {
    padding-left: 2rem;
}

.about-text {
    margin-top: 2rem;
}

.about-text .lead {
    font-size: 1.3rem;
    color: #495057;
    margin-bottom: 1.5rem;
}

.about-text p {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #6c757d;
    margin-bottom: 1.5rem;
}

.mission-values {
    margin-top: 3rem;
}

.mission-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 2rem;
}

.mission-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    margin-left: 1.5rem;
    flex-shrink: 0;
}

.mission-content h4 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.mission-content p {
    color: #6c757d;
    margin: 0;
}

/* Visual Grid */
.about-visual {
    padding-right: 2rem;
}

.visual-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
    height: 400px;
}

.visual-item:first-child {
    grid-row: 1 / 3;
    position: relative;
    overflow: hidden;
    border-radius: 15px;
}

.visual-item img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.visual-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
    color: white;
    padding: 1.5rem;
}

.feature-highlight {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    display: flex;
    flex-direction: column;
    justify-content: center;
    height: 100%;
}

.feature-highlight i {
    font-size: 2.5rem;
    color: #667eea;
    margin-bottom: 1rem;
}

.feature-highlight h5 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.feature-highlight p {
    color: #6c757d;
    margin: 0;
}

/* Services Section */
.services-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.service-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    height: 100%;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
}

.service-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.service-icon {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1.5rem;
    color: white;
    font-size: 1.8rem;
}

.service-content h4 {
    color: #2c3e50;
    margin-bottom: 1rem;
    font-weight: 600;
}

.service-content p {
    color: #6c757d;
    margin-bottom: 1.5rem;
    line-height: 1.6;
}

.service-features {
    list-style: none;
    padding: 0;
    margin: 0;
}

.service-features li {
    color: #6c757d;
    margin-bottom: 0.5rem;
    position: relative;
    padding-right: 1.5rem;
}

.service-features li:before {
    content: '✓';
    position: absolute;
    right: 0;
    color: #28a745;
    font-weight: bold;
}

/* Timeline Section */
.timeline-section {
    padding: 80px 0;
    background: white;
}

.timeline {
    position: relative;
    max-width: 1000px;
    margin: 0 auto;
}

.timeline:before {
    content: '';
    position: absolute;
    top: 0;
    right: 50%;
    transform: translateX(50%);
    width: 4px;
    height: 100%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 2px;
}

.timeline-item {
    position: relative;
    margin-bottom: 3rem;
}

.timeline-item.left .timeline-content {
    margin-left: 50%;
    padding-right: 3rem;
}

.timeline-item.right .timeline-content {
    margin-right: 50%;
    padding-left: 3rem;
}

.timeline-icon {
    position: absolute;
    top: 0;
    right: 50%;
    transform: translateX(50%);
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    z-index: 2;
    border: 4px solid white;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.timeline-card {
    background: white;
    border-radius: 15px;
    padding: 2rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
}

.timeline-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
}

.timeline-date {
    color: #667eea;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-family: 'IRANSans', sans-serif;
}

.timeline-card h4 {
    color: #2c3e50;
    margin-bottom: 1rem;
    font-weight: 600;
}

.timeline-card p {
    color: #6c757d;
    margin: 0;
    line-height: 1.6;
}

/* Popular Categories Section */
.popular-categories-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.category-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    height: 100%;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
}

.category-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.category-icon {
    margin-bottom: 1.5rem;
}

.category-emoji {
    font-size: 3rem;
    display: block;
}

.category-icon i {
    font-size: 3rem;
    color: #667eea;
}

.category-content h4 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.category-count {
    color: #6c757d;
    margin-bottom: 1.5rem;
    font-family: 'IRANSans', sans-serif;
}

.category-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.category-link:hover {
    color: #764ba2;
}

.category-link i {
    margin-right: 0.5rem;
    transition: all 0.3s ease;
}

.category-link:hover i {
    transform: translateX(-3px);
}

/* Top Provinces Section */
.top-provinces-section {
    padding: 80px 0;
    background: white;
}

.province-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    height: 100%;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
    position: relative;
    overflow: hidden;
}

.province-card.featured {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.province-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.province-rank {
    position: absolute;
    top: 1rem;
    left: 1rem;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #667eea;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-family: 'IRANSans', sans-serif;
}

.province-card.featured .province-rank {
    background: rgba(255, 255, 255, 0.2);
}

.province-content h4 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.province-card.featured .province-content h4 {
    color: white;
}

.province-stats {
    margin-bottom: 1rem;
}

.locations-count {
    font-size: 1.5rem;
    font-weight: 700;
    color: #667eea;
    font-family: 'IRANSans', sans-serif;
}

.province-card.featured .locations-count {
    color: white;
}

.province-center {
    color: #6c757d;
    font-size: 0.9rem;
    margin: 0;
}

.province-card.featured .province-center {
    color: rgba(255, 255, 255, 0.8);
}

.province-progress {
    margin-top: 1rem;
}

.progress {
    height: 6px;
    background: #e9ecef;
    border-radius: 3px;
    overflow: hidden;
}

.province-card.featured .progress {
    background: rgba(255, 255, 255, 0.2);
}

.progress-bar {
    height: 100%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    transition: width 1s ease;
}

.province-card.featured .progress-bar {
    background: white;
}

/* Contact Section */
.contact-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.contact-content {
    padding-left: 2rem;
}

.contact-info {
    margin: 2rem 0;
}

.contact-item {
    display: flex;
    align-items: center;
    margin-bottom: 2rem;
}

.contact-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    margin-left: 1.5rem;
    flex-shrink: 0;
}

.contact-details h5 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.contact-details p {
    color: #6c757d;
    margin: 0;
    font-family: 'IRANSans', sans-serif;
}

.social-links {
    margin-top: 3rem;
}

.social-links h5 {
    color: #2c3e50;
    margin-bottom: 1rem;
    font-weight: 600;
}

.social-icons {
    display: flex;
    gap: 1rem;
}

.social-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
}

.social-icon:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    color: white;
}

.contact-form-wrapper {
    padding-right: 2rem;
}

.contact-form {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    border: 1px solid #e9ecef;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    color: #2c3e50;
    font-weight: 600;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control {
    border: 2px solid #e9ecef;
    border-radius: 10px;
    padding: 12px 15px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
}

.form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    background: white;
}

/* CTA Section */
.cta-section {
    padding: 80px 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-align: center;
}

.cta-content h2 {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 2rem;
    opacity: 0.9;
}

.cta-buttons {
    display: flex;
    justify-content: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.cta-buttons .btn {
    padding: 12px 30px;
    border-radius: 50px;
    font-weight: 600;
    transition: all 0.3s ease;
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-title {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.4rem;
    }

    .hero-description {
        font-size: 1rem;
    }

    .about-content,
    .about-visual,
    .contact-content,
    .contact-form-wrapper {
        padding: 0;
        margin-bottom: 2rem;
    }

    .visual-grid {
        height: 300px;
    }

    .timeline:before {
        right: 30px;
        transform: none;
    }

    .timeline-item.left .timeline-content,
    .timeline-item.right .timeline-content {
        margin: 0;
        padding-right: 0;
        padding-left: 80px;
    }

    .timeline-icon {
        right: 0;
        transform: none;
    }

    .stat-number {
        font-size: 2.5rem;
    }

    .section-title {
        font-size: 2rem;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .cta-buttons {
        flex-direction: column;
        align-items: center;
    }

    .cta-buttons .btn {
        width: 100%;
        max-width: 300px;
    }
}

@media (max-width: 576px) {
    .hero-title {
        font-size: 2rem;
    }

    .stat-card,
    .service-card,
    .category-card,
    .province-card {
        margin-bottom: 1rem;
    }

    .mission-item {
        flex-direction: column;
        text-align: center;
    }

    .mission-icon {
        margin: 0 0 1rem 0;
    }

    .contact-item {
        flex-direction: column;
        text-align: center;
    }

    .contact-icon {
        margin: 0 0 1rem 0;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Animate statistics on scroll
    const observerOptions = {
        threshold: 0.5,
        rootMargin: '0px 0px -100px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                animateStatNumbers(entry.target);
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);

    // Observe all stat cards
    document.querySelectorAll('.stat-card').forEach(card => {
        observer.observe(card);
    });

    // Animate number counting
    function animateStatNumbers(card) {
        const numberElement = card.querySelector('.stat-number');
        const target = parseInt(numberElement.dataset.target);

        if (!target) return;

        let current = 0;
        const increment = target / 100;
        const duration = 2000;
        const stepTime = duration / 100;

        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }

            // Format number with Persian digits if needed
            const formattedNumber = formatNumber(Math.floor(current));
            numberElement.textContent = formattedNumber;
        }, stepTime);
    }

    // Format numbers based on locale
    function formatNumber(num) {
        const locale = document.documentElement.lang || 'fa';
        if (locale === 'fa') {
            return toPersianNumbers(num.toLocaleString());
        }
        return num.toLocaleString();
    }

    // Convert to Persian numbers
    function toPersianNumbers(str) {
        const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        return str.toString().replace(/[0-9]/g, function(w) {
            return persianDigits[+w];
        });
    }

    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Add animation classes on scroll
    const animateOnScroll = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    });

    // Observe elements for animation
    document.querySelectorAll('.service-card, .category-card, .province-card, .timeline-card').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(30px)';
        el.style.transition = 'all 0.6s ease';
        animateOnScroll.observe(el);
    });

    // Form validation and submission
    const contactForm = document.querySelector('.contact-form');
    if (contactForm) {
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();

            // Basic validation
            const requiredFields = contactForm.querySelectorAll('[required]');
            let isValid = true;

            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.style.borderColor = '#dc3545';
                    isValid = false;
                } else {
                    field.style.borderColor = '#28a745';
                }
            });

            if (isValid) {
                // Show loading state
                const submitBtn = contactForm.querySelector('button[type="submit"]');
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>در حال ارسال...';
                submitBtn.disabled = true;

                // Simulate form submission (replace with actual submission)
                setTimeout(() => {
                    submitBtn.innerHTML = '<i class="fas fa-check me-2"></i>ارسال شد!';
                    submitBtn.style.background = '#28a745';

                    setTimeout(() => {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                        submitBtn.style.background = '';
                        contactForm.reset();
                    }, 2000);
                }, 1500);
            }
        });
    }

    // Progress bar animation
    const progressBars = document.querySelectorAll('.progress-bar');
    const progressObserver = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const progressBar = entry.target;
                const width = progressBar.style.width;
                progressBar.style.width = '0%';
                setTimeout(() => {
                    progressBar.style.width = width;
                }, 500);
                progressObserver.unobserve(progressBar);
            }
        });
    }, { threshold: 0.5 });

    progressBars.forEach(bar => {
        progressObserver.observe(bar);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/templates/about.blade.php ENDPATH**/ ?>