<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CommentHelpfulVote extends Model
{
    use HasFactory;

    protected $table = 'rating_comment_helpful_votes';

    protected $fillable = [
        'comment_id',
        'user_id',
        'ip_address',
        'vote_type'
    ];

    protected $casts = [
        'comment_id' => 'integer',
        'user_id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationships
    public function comment()
    {
        return $this->belongsTo(RatingLocationComment::class, 'comment_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeHelpful($query)
    {
        return $query->where('vote_type', 'helpful');
    }

    public function scopeNotHelpful($query)
    {
        return $query->where('vote_type', 'not_helpful');
    }

    public function scopeForComment($query, $commentId)
    {
        return $query->where('comment_id', $commentId);
    }

    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function scopeForIp($query, $ipAddress)
    {
        return $query->where('ip_address', $ipAddress);
    }
}
