<?php

namespace App\Models;

use App\Traits\HasTranslatedName;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class District extends Model
{
    use HasFactory, SoftDeletes, HasTranslatedName;

    protected $table = 'state4_districts';

    public $timestamps = false;

    protected $fillable = [
        'county_id',
        'name',
        'name_en',
        'code',
        'slug',
        'global_slug',
        'center_city_name',
        'area',
        'population',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'area' => 'decimal:2',
        'population' => 'integer',
        'deleted_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationships
    public function county()
    {
        return $this->belongsTo(County::class);
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function villages()
    {
        return $this->hasMany(Village::class);
    }

    public function locations()
    {
        return $this->hasMany(Location::class);
    }

    // Make name_fa attribute for compatibility
    public function getNameFaAttribute()
    {
        return $this->name;
    }
}
