<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'username',
        'email',
        'password',
        'full_name',
        'role',
        'status',
        'last_login',
        'phone',
        'is_active',
        'last_login_at',
        'last_login_ip',
        'password_updated_at',
        'last_login_user_agent',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'last_login' => 'datetime',
            'is_active' => 'boolean',
            'last_login_at' => 'datetime',
            'password_updated_at' => 'datetime',
        ];
    }

    /**
     * Get the locations submitted by the user.
     */
    public function locations()
    {
        return $this->hasMany(Location::class, 'user_id');
    }

    /**
     * Get the ratings submitted by the user.
     */
    public function ratings()
    {
        return $this->hasMany(Rating::class, 'email', 'email');
    }

    /**
     * Check if the user is active
     */
    public function isActive()
    {
        return $this->status === 'active';
    }

    /**
     * Check if user is an admin
     */
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    /**
     * دریافت بازدیدهای کاربر
     */
    public function visits()
    {
        return $this->hasMany(Visit::class);
    }
}
