<div class="tab-pane fade" id="contentAnalysis" role="tabpanel">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h5 class="card-title">تحلیل محتوای سایت</h5>
        <div class="btn-group">
            <button type="button" class="btn btn-sm btn-outline-primary active" data-content-chart="popular">محتوای محبوب</button>
            <button type="button" class="btn btn-sm btn-outline-primary" data-content-chart="engagement">آمار تعامل</button>
            <button type="button" class="btn btn-sm btn-outline-primary" data-content-chart="categories">دسته‌بندی‌ها</button>
        </div>
    </div>

    <!-- Filters Row -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <h6 class="card-subtitle mb-0">فیلترها</h6>
                        <div class="d-flex">
                            <div class="form-group ml-3 mb-0">
                                <label for="contentTimeRange" class="mr-2">بازه زمانی:</label>
                                <select class="form-control form-control-sm" id="contentTimeRange">
                                    <option value="7">7 روز گذشته</option>
                                    <option value="30" selected>30 روز گذشته</option>
                                    <option value="90">90 روز گذشته</option>
                                    <option value="365">1 سال گذشته</option>
                                </select>
                            </div>
                            <div class="form-group ml-3 mb-0">
                                <label for="contentType" class="mr-2">نوع محتوا:</label>
                                <select class="form-control form-control-sm" id="contentType">
                                    <option value="all" selected>همه</option>
                                    <option value="articles">مقالات</option>
                                    <option value="products">محصولات</option>
                                    <option value="services">خدمات</option>
                                </select>
                            </div>
                            <button id="applyContentFilters" class="btn btn-primary btn-sm">اعمال فیلترها</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <!-- Popular Content Section -->
        <div class="col-md-8 mb-4 content-chart" id="popular-chart-container" data-chart-type="popular">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">محتوای پربازدید</h6>
                    <div id="popular-content-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 content-chart" id="popular-stats-container" data-chart-type="popular">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">محتوای برتر</h6>
                    <div class="top-content-list">
                        <div class="list-group">
                            <a href="#" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">بهترین محصولات سال 1402</h6>
                                    <small>12,543 بازدید</small>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">محصولات / راهنمای خرید</small>
                                    <span class="badge badge-success">+24%</span>
                                </div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">راهنمای جامع انتخاب لپ‌تاپ</h6>
                                    <small>8,721 بازدید</small>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">مقالات / آموزشی</small>
                                    <span class="badge badge-success">+12%</span>
                                </div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">مقایسه گوشی‌های پرچمدار 1402</h6>
                                    <small>7,342 بازدید</small>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">مقالات / مقایسه</small>
                                    <span class="badge badge-success">+8%</span>
                                </div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">بررسی تخصصی آیفون 15 پرو</h6>
                                    <small>6,254 بازدید</small>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">محصولات / نقد و بررسی</small>
                                    <span class="badge badge-danger">-3%</span>
                                </div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">آموزش تعمیر موبایل در منزل</h6>
                                    <small>5,871 بازدید</small>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">خدمات / آموزشی</small>
                                    <span class="badge badge-success">+15%</span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Content Engagement Section -->
        <div class="col-md-8 mb-4 content-chart d-none" id="engagement-chart-container" data-chart-type="engagement">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">میزان تعامل با محتوا</h6>
                    <div id="content-engagement-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 content-chart d-none" id="engagement-stats-container" data-chart-type="engagement">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">آمار تعامل</h6>
                    <div id="engagement-metrics" class="stats-list">
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>میانگین زمان مطالعه:</span>
                                <strong>3 دقیقه و 12 ثانیه</strong>
                            </div>
                        </div>
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>نرخ مشارکت در نظرات:</span>
                                <strong>5.7%</strong>
                            </div>
                        </div>
                        <div class="alert alert-success mb-2">
                            <div class="d-flex justify-content-between">
                                <span>اشتراک‌گذاری محتوا:</span>
                                <strong>2,543 (+18%)</strong>
                            </div>
                        </div>
                        <div class="alert alert-warning mb-2">
                            <div class="d-flex justify-content-between">
                                <span>نرخ خروج از صفحات محتوا:</span>
                                <strong>38.2% (-2.5%)</strong>
                            </div>
                        </div>
                        <div class="alert alert-info mb-2">
                            <div class="d-flex justify-content-between">
                                <span>تعامل در شبکه‌های اجتماعی:</span>
                                <strong>4,872 واکنش</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Content Categories Section -->
        <div class="col-md-8 mb-4 content-chart d-none" id="categories-chart-container" data-chart-type="categories">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">محبوبیت دسته‌بندی‌ها</h6>
                    <div id="categories-chart" class="chart-container"></div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4 content-chart d-none" id="categories-stats-container" data-chart-type="categories">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">آمار دسته‌بندی‌ها</h6>
                    <div id="categories-list" class="stats-list">
                        <div class="progress-container mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>موبایل و لوازم جانبی</span>
                                <strong>32.4%</strong>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div class="progress-bar bg-primary" role="progressbar" style="width: 32.4%"></div>
                            </div>
                        </div>
                        <div class="progress-container mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>لپ‌تاپ و کامپیوتر</span>
                                <strong>27.8%</strong>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div class="progress-bar bg-success" role="progressbar" style="width: 27.8%"></div>
                            </div>
                        </div>
                        <div class="progress-container mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>لوازم خانگی هوشمند</span>
                                <strong>18.3%</strong>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div class="progress-bar bg-info" role="progressbar" style="width: 18.3%"></div>
                            </div>
                        </div>
                        <div class="progress-container mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>گجت‌های پوشیدنی</span>
                                <strong>12.5%</strong>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div class="progress-bar bg-warning" role="progressbar" style="width: 12.5%"></div>
                            </div>
                        </div>
                        <div class="progress-container mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>سایر دسته‌بندی‌ها</span>
                                <strong>9.0%</strong>
                            </div>
                            <div class="progress" style="height: 10px;">
                                <div class="progress-bar bg-secondary" role="progressbar" style="width: 9.0%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Content Performance Metrics -->
    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3">عملکرد محتوا در موتورهای جستجو</h6>
                    <div class="row">
                        <div class="col-md-4 mb-4 mb-md-0">
                            <div class="card h-100 border-0">
                                <div class="card-body text-center">
                                    <i class="fas fa-search fa-3x text-primary mb-3"></i>
                                    <h5 class="mb-2">کلیدواژه‌های برتر</h5>
                                    <div class="mt-3">
                                        <span class="badge badge-primary mr-1 mb-1 p-2">گوشی هوشمند (12.3K)</span>
                                        <span class="badge badge-primary mr-1 mb-1 p-2">لپ‌تاپ گیمینگ (8.7K)</span>
                                        <span class="badge badge-primary mr-1 mb-1 p-2">بهترین موبایل (7.2K)</span>
                                        <span class="badge badge-primary mr-1 mb-1 p-2">آیفون 15 (6.5K)</span>
                                        <span class="badge badge-primary mr-1 mb-1 p-2">هدفون بی‌سیم (4.8K)</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4 mb-md-0">
                            <div class="card h-100 border-0">
                                <div class="card-body text-center">
                                    <i class="fas fa-chart-line fa-3x text-success mb-3"></i>
                                    <h5 class="mb-2">رتبه‌بندی سئو</h5>
                                    <div id="seo-ranking-chart" style="height: 200px;"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card h-100 border-0">
                                <div class="card-body text-center">
                                    <i class="fas fa-link fa-3x text-info mb-3"></i>
                                    <h5 class="mb-2">لینک‌های ورودی</h5>
                                    <div class="mt-3">
                                        <div class="progress-container mb-2">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span>شبکه‌های اجتماعی</span>
                                                <strong>45%</strong>
                                            </div>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-info" role="progressbar" style="width: 45%"></div>
                                            </div>
                                        </div>
                                        <div class="progress-container mb-2">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span>موتورهای جستجو</span>
                                                <strong>32%</strong>
                                            </div>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-success" role="progressbar" style="width: 32%"></div>
                                            </div>
                                        </div>
                                        <div class="progress-container mb-2">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span>سایت‌های معتبر</span>
                                                <strong>18%</strong>
                                            </div>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 18%"></div>
                                            </div>
                                        </div>
                                        <div class="progress-container">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span>سایر منابع</span>
                                                <strong>5%</strong>
                                            </div>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-secondary" role="progressbar" style="width: 5%"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle between different content chart types
    document.querySelectorAll('[data-content-chart]').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('[data-content-chart]').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Add active class to clicked button
            this.classList.add('active');
            
            // Hide all chart containers
            document.querySelectorAll('.content-chart').forEach(container => {
                container.classList.add('d-none');
            });
            
            // Show the selected chart containers
            const chartType = this.getAttribute('data-content-chart');
            document.querySelectorAll(`[data-chart-type="${chartType}"]`).forEach(container => {
                container.classList.remove('d-none');
            });
            
            // Initialize or refresh the visible charts
            initContentCharts(chartType);
        });
    });
    
    // Apply filters button event
    document.getElementById('applyContentFilters').addEventListener('click', function() {
        const timeRange = document.getElementById('contentTimeRange').value;
        const contentType = document.getElementById('contentType').value;
        
        // Get active chart type
        const activeChartType = document.querySelector('[data-content-chart].active').getAttribute('data-content-chart');
        
        // Apply filters by refreshing charts
        initContentCharts(activeChartType, { timeRange, contentType });
    });
    
    // Initialize the default popular content charts on page load
    initContentCharts('popular');
    
    // Initialize SEO ranking chart
    renderSeoRankingChart();
});

function initContentCharts(chartType, filters = {}) {
    // Show loading indicators if needed
    // ...
    
    // In a real application, this would make an AJAX request to fetch data with filters
    // For now, we'll just simulate with sample data
    
    if (chartType === 'popular') {
        renderPopularContentChart(filters);
    } else if (chartType === 'engagement') {
        renderContentEngagementChart(filters);
    } else if (chartType === 'categories') {
        renderCategoriesChart(filters);
    }
}

function renderPopularContentChart(filters = {}) {
    // Sample data for popular content chart
    const options = {
        series: [{
            name: 'بازدید',
            data: [12543, 8721, 7342, 6254, 5871, 4932, 4325, 3987, 3654, 3421]
        }],
        chart: {
            height: 350,
            type: 'bar',
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: true
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                dataLabels: {
                    position: 'top',
                },
            }
        },
        colors: ['#4CAF50'],
        dataLabels: {
            enabled: true,
            offsetX: -6,
            style: {
                fontSize: '12px',
                colors: ['#fff']
            }
        },
        stroke: {
            show: true,
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: [
                'بهترین محصولات سال 1402',
                'راهنمای جامع انتخاب لپ‌تاپ',
                'مقایسه گوشی‌های پرچمدار 1402',
                'بررسی تخصصی آیفون 15 پرو',
                'آموزش تعمیر موبایل در منزل',
                'معرفی بهترین هدفون‌های بی‌سیم',
                'راهنمای خرید ساعت هوشمند',
                'معرفی بهترین لپ‌تاپ‌های 1402',
                'آموزش افزایش سرعت گوشی',
                'مقایسه پردازنده‌های اینتل و AMD'
            ]
        },
        tooltip: {
            y: {
                formatter: function (val) {
                    return val + " بازدید";
                }
            }
        }
    };

    const chart = new ApexCharts(document.querySelector("#popular-content-chart"), options);
    chart.render();
}

function renderContentEngagementChart(filters = {}) {
    // Sample data for content engagement - in a real app, this would come from the server with filters applied
    const contentTypes = ['مقالات آموزشی', 'نقد و بررسی محصول', 'راهنمای خرید', 'اخبار فناوری', 'مقایسه محصولات'];
    
    const options = {
        series: [{
            name: 'میانگین زمان مطالعه (ثانیه)',
            data: [245, 187, 163, 112, 195]
        }, {
            name: 'نرخ تعامل (%)',
            data: [8.4, 6.2, 7.5, 3.8, 5.9]
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            stacked: false,
            toolbar: {
                show: true
            }
        },
        colors: ['#3A5794', '#FF9800'],
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
                endingShape: 'rounded'
            },
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        xaxis: {
            categories: contentTypes
        },
        yaxis: [{
            title: {
                text: 'زمان مطالعه (ثانیه)'
            }
        }, {
            opposite: true,
            title: {
                text: 'نرخ تعامل (%)'
            }
        }],
        fill: {
            opacity: 1
        },
        tooltip: {
            shared: true,
            intersect: false,
            y: [{
                formatter: function (val) {
                    return val + " ثانیه";
                }
            }, {
                formatter: function (val) {
                    return val + "%";
                }
            }]
        }
    };

    const chart = new ApexCharts(document.querySelector("#content-engagement-chart"), options);
    chart.render();
}

function renderCategoriesChart(filters = {}) {
    // Sample data for content categories
    const options = {
        series: [32.4, 27.8, 18.3, 12.5, 9.0],
        chart: {
            height: 350,
            type: 'pie',
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: true
            }
        },
        labels: ['موبایل و لوازم جانبی', 'لپ‌تاپ و کامپیوتر', 'لوازم خانگی هوشمند', 'گجت‌های پوشیدنی', 'سایر دسته‌بندی‌ها'],
        colors: ['#4361ee', '#3a86ff', '#4cc9f0', '#4895ef', '#98c1d9'],
        dataLabels: {
            enabled: true,
            formatter: function (val) {
                return val.toFixed(1) + "%";
            }
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 300
                },
                legend: {
                    position: 'bottom'
                }
            }
        }],
        legend: {
            position: 'bottom'
        }
    };

    const chart = new ApexCharts(document.querySelector("#categories-chart"), options);
    chart.render();
}

function renderSeoRankingChart() {
    // Sample data for SEO ranking chart
    const options = {
        series: [{
            name: "تعداد کلیدواژه",
            data: [12, 19, 28, 47, 91, 173]
        }],
        chart: {
            height: 180,
            type: 'area',
            fontFamily: 'Vazir, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            },
            sparkline: {
                enabled: false
            }
        },
        colors: ['#16c79a'],
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'smooth',
            width: 3
        },
        xaxis: {
            categories: ['رتبه 1', 'رتبه 1-3', 'رتبه 1-5', 'رتبه 1-10', 'رتبه 1-20', 'رتبه 1-50'],
            labels: {
                style: {
                    fontSize: '10px'
                }
            }
        },
        yaxis: {
            show: false
        },
        tooltip: {
            x: {
                show: true
            },
            y: {
                formatter: function (val) {
                    return val + " کلیدواژه";
                }
            }
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.3
            }
        }
    };

    const chart = new ApexCharts(document.querySelector("#seo-ranking-chart"), options);
    chart.render();
}
</script> 