@extends('admin.layouts.app')

@section('title', 'Category Details: ' . $category->category_fa)

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>Category Details</h4>
                <div>
                    <a href="{{ route('admin.categories.edit', $category->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Categories
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 200px;">ID</th>
                            <td>{{ $category->id }}</td>
                        </tr>
                        <tr>
                            <th>Category Key</th>
                            <td>{{ $category->category_key }}</td>
                        </tr>
                        <tr>
                            <th>Persian Name</th>
                            <td>{{ $category->category_fa }}</td>
                        </tr>
                        <tr>
                            <th>English Name</th>
                            <td>{{ $category->category_en }}</td>
                        </tr>
                        <tr>
                            <th>Arabic Name</th>
                            <td>{{ $category->category_ar }}</td>
                        </tr>
                        <tr>
                            <th>Emoji</th>
                            <td>{{ $category->emoji }}</td>
                        </tr>
                        <tr>
                            <th>Icon</th>
                            <td>
                                @if($category->font_icon)
                                    <i class="fas fa-{{ $category->font_icon }}"></i> {{ $category->font_icon }}
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Color</th>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div style="width: 30px; height: 30px; background-color: {{ $category->color }}; border-radius: 4px; margin-right: 10px;"></div>
                                    {{ $category->color }}
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th>Display Order</th>
                            <td>{{ $category->sort_order }}</td>
                        </tr>
                        <tr>
                            <th>Show in Menu</th>
                            <td>
                                <span class="badge {{ $category->show_in_menu ? 'bg-success' : 'bg-danger' }}">
                                    {{ $category->show_in_menu ? 'Yes' : 'No' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Show in Filters</th>
                            <td>
                                <span class="badge {{ $category->show_in_filters ? 'bg-success' : 'bg-danger' }}">
                                    {{ $category->show_in_filters ? 'Yes' : 'No' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Parent Category</th>
                            <td>
                                @if($category->parent_id)
                                    <a href="{{ route('admin.categories.show', $category->parent_id) }}">
                                        {{ $category->parent->category_fa ?? 'Unknown' }}
                                    </a>
                                @else
                                    <span class="text-muted">No parent (Root category)</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{{ $category->description ?? 'No description' }}</td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td>{{ $category->created_at->format('Y-m-d H:i:s') }}</td>
                        </tr>
                        <tr>
                            <th>Updated At</th>
                            <td>{{ $category->updated_at->format('Y-m-d H:i:s') }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">Category Preview</h5>
                        </div>
                        <div class="card-body text-center">
                            <div class="category-preview p-3 mb-3" style="background-color: {{ $category->color }}; border-radius: 8px;">
                                <div class="category-icon mb-2" style="font-size: 3rem;">
                                    {{ $category->emoji }}
                                </div>
                                <h4 class="mb-1">{{ $category->category_fa }}</h4>
                                <div class="text-muted">{{ $category->category_en }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if(isset($subcategories) && $subcategories->count() > 0)
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Subcategories</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Key</th>
                                            <th>Name</th>
                                            <th>English Name</th>
                                            <th>Emoji</th>
                                            <th>Display Order</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($subcategories as $subcategory)
                                        <tr>
                                            <td>{{ $subcategory->id }}</td>
                                            <td>{{ $subcategory->category_key }}</td>
                                            <td>{{ $subcategory->category_fa }}</td>
                                            <td>{{ $subcategory->category_en }}</td>
                                            <td>{{ $subcategory->emoji }}</td>
                                            <td>{{ $subcategory->sort_order }}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="{{ route('admin.categories.show', $subcategory->id) }}" class="btn btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('admin.categories.edit', $subcategory->id) }}" class="btn btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Related Locations</h5>
                        </div>
                        <div class="card-body">
                            @if(isset($locations) && $locations->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Title</th>
                                                <th>Address</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($locations as $location)
                                            <tr>
                                                <td>{{ $location->id }}</td>
                                                <td>{{ $location->title }}</td>
                                                <td>{{ Str::limit($location->address, 50) }}</td>
                                                <td>
                                                    <span class="badge {{ $location->is_active ? 'bg-success' : 'bg-danger' }}">
                                                        {{ $location->is_active ? 'Active' : 'Inactive' }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="{{ route('admin.locations.show', $location->id) }}" class="btn btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info">No locations found in this category.</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 