@extends('admin.layouts.app')

@section('title', 'مدیریت قالب‌های دسته‌بندی')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست قالب‌های دسته‌بندی</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.category-templates.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> ایجاد قالب جدید
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(count($templates) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>نام قالب</th>
                                        <th>دسته‌بندی</th>
                                        <th>نوع قالب</th>
                                        <th>استایل هدر</th>
                                        <th>چیدمان محتوا</th>
                                        <th>وضعیت</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($templates as $template)
                                        <tr>
                                            <td>{{ $template->template_name }}</td>
                                            <td>{{ $template->category->name }}</td>
                                            <td>{{ $template->template_type }}</td>
                                            <td>{{ $template->header_style }}</td>
                                            <td>{{ $template->content_layout }}</td>
                                            <td>
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input status-switch" 
                                                           id="status-{{ $template->id }}" 
                                                           data-id="{{ $template->id }}"
                                                           {{ $template->is_active ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="status-{{ $template->id }}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.category-templates.edit', $template->id) }}" 
                                                   class="btn btn-sm btn-info">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" 
                                                        class="btn btn-sm btn-danger delete-template"
                                                        data-id="{{ $template->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            هیچ قالبی یافت نشد.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تغییر وضعیت فعال/غیرفعال
        $('.status-switch').on('change', function() {
            const templateId = $(this).data('id');
            const isActive = $(this).prop('checked');

            $.ajax({
                url: `/admin/category-templates/${templateId}/toggle-active`,
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error('خطا در تغییر وضعیت قالب');
                    }
                },
                error: function() {
                    toastr.error('خطا در ارتباط با سرور');
                }
            });
        });

        // حذف قالب
        $('.delete-template').on('click', function() {
            const templateId = $(this).data('id');

            Swal.fire({
                title: 'آیا از حذف این قالب اطمینان دارید؟',
                text: 'این عملیات غیرقابل بازگشت است.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله، حذف شود',
                cancelButtonText: 'خیر'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/admin/category-templates/${templateId}`,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            Swal.fire(
                                'حذف شد!',
                                'قالب با موفقیت حذف شد.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function() {
                            Swal.fire(
                                'خطا!',
                                'خطا در حذف قالب.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    });
</script>
@endpush 