@extends('admin.layouts.app')

@section('title', 'افزودن روستای جدید')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>افزودن روستای جدید</h4>
                <a href="{{ route('admin.geography.villages.index') }}" class="btn btn-primary">
                    <i class="fas fa-list"></i> بازگشت به لیست روستاها
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('admin.geography.villages.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="district_id" class="form-label">بخش <span class="text-danger">*</span></label>
                            <select class="form-control @error('district_id') is-invalid @enderror" id="district_id" name="district_id" required>
                                <option value="">انتخاب بخش</option>
                                @foreach($districts as $id => $name)
                                    <option value="{{ $id }}" {{ old('district_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('district_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="county_id" class="form-label">شهرستان <span class="text-danger">*</span></label>
                            <select class="form-control @error('county_id') is-invalid @enderror" id="county_id" name="county_id" required>
                                <option value="">انتخاب شهرستان</option>
                                @foreach($counties as $id => $name)
                                    <option value="{{ $id }}" {{ old('county_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('county_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="city_id" class="form-label">شهر نزدیک</label>
                            <select class="form-control @error('city_id') is-invalid @enderror" id="city_id" name="city_id">
                                <option value="">انتخاب شهر</option>
                                @foreach($cities as $id => $name)
                                    <option value="{{ $id }}" {{ old('city_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('city_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name" class="form-label">نام روستا <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name_en" class="form-label">نام انگلیسی</label>
                            <input type="text" class="form-control @error('name_en') is-invalid @enderror" id="name_en" name="name_en" value="{{ old('name_en') }}">
                            @error('name_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="slug" class="form-label">نامک <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug') }}" required>
                            @error('slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">نامک در URL استفاده می‌شود و فقط شامل حروف، اعداد و خط تیره باشد.</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="code" class="form-label">کد</label>
                            <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code') }}">
                            @error('code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="population" class="form-label">جمعیت</label>
                            <input type="number" class="form-control @error('population') is-invalid @enderror" id="population" name="population" value="{{ old('population') }}">
                            @error('population')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="households" class="form-label">تعداد خانوار</label>
                            <input type="number" class="form-control @error('households') is-invalid @enderror" id="households" name="households" value="{{ old('households') }}">
                            @error('households')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="elevation" class="form-label">ارتفاع از سطح دریا (متر)</label>
                            <input type="number" class="form-control @error('elevation') is-invalid @enderror" id="elevation" name="elevation" value="{{ old('elevation') }}">
                            @error('elevation')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="postal_code" class="form-label">کد پستی</label>
                            <input type="text" class="form-control @error('postal_code') is-invalid @enderror" id="postal_code" name="postal_code" value="{{ old('postal_code') }}">
                            @error('postal_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="phone_code" class="form-label">پیش‌شماره تلفن</label>
                            <input type="text" class="form-control @error('phone_code') is-invalid @enderror" id="phone_code" name="phone_code" value="{{ old('phone_code') }}">
                            @error('phone_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label class="form-label d-block">وضعیت</label>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="is_active" id="status_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label" for="status_active">فعال</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="is_active" id="status_inactive" value="0" {{ old('is_active') == '0' ? 'checked' : '' }}>
                                <label class="form-check-label" for="status_inactive">غیرفعال</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="description" class="form-label">توضیحات</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save"></i> ذخیره روستا
                    </button>
                    <a href="{{ route('admin.geography.villages.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> انصراف
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تولید خودکار نامک از روی نام
        $('#name').on('keyup', function() {
            const name = $(this).val();
            const slug = name.toLowerCase()
                .replace(/\s+/g, '-')           // تبدیل فاصله به خط تیره
                .replace(/[^\w\-]+/g, '')       // حذف کاراکترهای غیرمجاز
                .replace(/\-\-+/g, '-')         // تبدیل چند خط تیره به یک خط تیره
                .replace(/^-+/, '')             // حذف خط تیره از ابتدا
                .replace(/-+$/, '');            // حذف خط تیره از انتها
            
            $('#slug').val(slug);
        });
        
        // بارگذاری بخش‌ها با تغییر شهرستان
        $('#county_id').on('change', function() {
            const countyId = $(this).val();
            if (countyId) {
                $.get(`/admin/geography/counties/${countyId}/districts`, function(data) {
                    let options = '<option value="">انتخاب بخش</option>';
                    data.forEach(function(district) {
                        options += `<option value="${district.id}">${district.name}</option>`;
                    });
                    $('#district_id').html(options);
                });
            } else {
                $('#district_id').html('<option value="">انتخاب بخش</option>');
            }
        });
        
        // بارگذاری شهرها با تغییر بخش
        $('#district_id').on('change', function() {
            const districtId = $(this).val();
            if (districtId) {
                $.get(`/admin/geography/districts/${districtId}/cities`, function(data) {
                    let options = '<option value="">انتخاب شهر</option>';
                    data.forEach(function(city) {
                        options += `<option value="${city.id}">${city.name}</option>`;
                    });
                    $('#city_id').html(options);
                });
            } else {
                $('#city_id').html('<option value="">انتخاب شهر</option>');
            }
        });
    });
</script>
@endsection 