@extends('admin.layouts.app')

@section('title', 'مدیریت مکان‌ها')

@section('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.css">
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.Default.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/lightbox2@2.11.4/dist/css/lightbox.min.css">
<link rel="stylesheet" href="{{ asset('css/admin/modern-locations.css') }}">
<style>
    :root {
        --primary-color: #4e73df;
        --success-color: #1cc88a;
        --warning-color: #f6c23e;
        --danger-color: #e74a3b;
        --info-color: #36b9cc;
        --light-color: #f8f9fc;
        --dark-color: #5a5c69;
        --border-color: #e3e6f0;
        --shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        --border-radius: 0.5rem;
        --transition: all 0.3s ease;
    }

    /* Override Bootstrap default styles */
    .container-fluid {
        padding-left: 1.5rem !important;
        padding-right: 1.5rem !important;
    }

    /* Fix for admin layout */
    .content {
        background-color: #f8f9fc !important;
    }

    .modern-page-header {
        background: linear-gradient(135deg, var(--primary-color) 0%, #3a5ccc 100%);
        color: white;
        padding: 2rem 0;
        margin: -1.5rem -1.5rem 30px -1.5rem;
        border-radius: 0 0 var(--border-radius) var(--border-radius);
        box-shadow: var(--shadow);
    }

    .modern-page-header h1 {
        font-size: 2.5rem;
        font-weight: 700;
        margin: 0;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .modern-page-header .subtitle {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-top: 0.5rem;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .stat-card {
        background: white;
        border-radius: var(--border-radius);
        padding: 1.5rem;
        box-shadow: var(--shadow);
        border: 1px solid var(--border-color);
        transition: var(--transition);
        position: relative;
        overflow: hidden;
        min-height: 120px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--card-color, var(--primary-color));
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 2rem 0 rgba(58, 59, 69, 0.2);
    }

    .stat-card.success::before { background: var(--success-color); }
    .stat-card.warning::before { background: var(--warning-color); }
    .stat-card.danger::before { background: var(--danger-color); }
    .stat-card.info::before { background: var(--info-color); }

    .stat-number {
        font-size: 2.5rem;
        font-weight: 700;
        color: var(--card-color, var(--primary-color));
        line-height: 1;
        margin-bottom: 0.5rem;
    }

    .stat-label {
        color: var(--dark-color);
        font-weight: 600;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .stat-icon {
        position: absolute;
        top: 1.5rem;
        left: 1.5rem;
        font-size: 2rem;
        opacity: 0.1;
        color: var(--card-color, var(--primary-color));
    }

    .filters-section {
        background: white;
        border-radius: var(--border-radius);
        padding: 1.5rem;
        margin-bottom: 2rem;
        box-shadow: var(--shadow);
        border: 1px solid var(--border-color);
    }

    .filters-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--border-color);
    }

    .filters-title {
        font-size: 1.2rem;
        font-weight: 700;
        color: var(--primary-color);
        margin: 0;
    }

    .filter-toggle {
        background: none;
        border: none;
        color: var(--primary-color);
        font-size: 1.1rem;
        cursor: pointer;
        transition: var(--transition);
    }

    .filter-toggle:hover {
        color: var(--dark-color);
    }

    .filters-content {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-top: 1rem;
    }

    .filter-group {
        position: relative;
    }

    .filter-group label {
        font-weight: 600;
        color: var(--dark-color);
        margin-bottom: 0.5rem;
        display: block;
        font-size: 0.9rem;
    }

    .modern-select,
    .modern-input {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 2px solid var(--border-color);
        border-radius: var(--border-radius);
        font-size: 0.9rem;
        transition: var(--transition);
        background: white;
    }

    .modern-select:focus,
    .modern-input:focus {
        outline: none;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
    }

    .action-buttons {
        display: flex;
        gap: 0.5rem;
        flex-wrap: wrap;
        margin-top: 1rem;
    }

    .btn-modern {
        padding: 0.75rem 1.5rem;
        border-radius: var(--border-radius);
        font-weight: 600;
        font-size: 0.9rem;
        border: none;
        cursor: pointer;
        transition: var(--transition);
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
    }

    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 0.25rem 0.75rem rgba(0,0,0,0.1);
    }

    .btn-primary-modern {
        background: var(--primary-color);
        color: white;
    }

    .btn-success-modern {
        background: var(--success-color);
        color: white;
    }

    .btn-warning-modern {
        background: var(--warning-color);
        color: white;
    }

    .btn-danger-modern {
        background: var(--danger-color);
        color: white;
    }

    .btn-outline-modern {
        background: transparent;
        color: var(--primary-color);
        border: 2px solid var(--primary-color);
    }

    .btn-outline-modern:hover {
        background: var(--primary-color);
        color: white;
    }

    /* Content Tabs */
    .content-tabs {
        background: white;
        border-radius: var(--border-radius);
        box-shadow: var(--shadow);
        margin-bottom: 2rem;
        overflow: hidden;
        border: 1px solid var(--border-color);
    }

    .modern-tabs {
        border-bottom: none;
        background: var(--light-color);
        padding: 0;
    }

    .modern-tabs .nav-link {
        border: none;
        background: transparent;
        color: var(--dark-color);
        font-weight: 600;
        padding: 1rem 2rem;
        border-radius: 0;
        transition: var(--transition);
        position: relative;
    }

    .modern-tabs .nav-link:hover {
        background: rgba(78, 115, 223, 0.1);
        color: var(--primary-color);
    }

    .modern-tabs .nav-link.active {
        background: white;
        color: var(--primary-color);
        border-bottom: 3px solid var(--primary-color);
    }

    .modern-tab-content {
        padding: 2rem;
    }

    /* Table Styles */
    .modern-table-container {
        background: white;
        border-radius: var(--border-radius);
        border: 1px solid var(--border-color);
        margin-top: 1rem;
    }

    .table-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem 0 1rem 0;
        border-bottom: 2px solid var(--border-color);
        margin-bottom: 1.5rem;
    }

    .table-title h4 {
        margin: 0;
        color: var(--primary-color);
        font-weight: 700;
    }

    .table-count {
        background: var(--primary-color);
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.8rem;
        font-weight: 600;
        margin-right: 1rem;
    }

    .table-actions {
        display: flex;
        gap: 0.5rem;
    }

    .modern-table {
        margin: 0;
        border: none;
    }

    .modern-table th {
        background: var(--light-color);
        border: none;
        font-weight: 700;
        color: var(--dark-color);
        padding: 1rem 0.75rem;
        white-space: nowrap;
        position: relative;
    }

    .modern-table td {
        border: none;
        padding: 1rem 0.75rem;
        vertical-align: middle;
        border-bottom: 1px solid var(--border-color);
    }

    .modern-table tbody tr:hover {
        background: rgba(78, 115, 223, 0.05);
    }

    /* Table Column Styles */
    .select-column {
        width: 50px;
        text-align: center;
    }

    .image-column {
        width: 80px;
    }

    .location-image {
        position: relative;
        width: 60px;
        height: 60px;
        border-radius: var(--border-radius);
        overflow: hidden;
    }

    .table-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-count {
        position: absolute;
        bottom: 2px;
        right: 2px;
        background: rgba(0,0,0,0.7);
        color: white;
        font-size: 0.7rem;
        padding: 2px 4px;
        border-radius: 2px;
    }

    .no-image {
        width: 60px;
        height: 60px;
        background: var(--light-color);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: var(--border-radius);
        color: var(--dark-color);
        font-size: 1.5rem;
    }

    .id-column {
        width: 80px;
    }

    .location-id {
        font-weight: 700;
        color: var(--primary-color);
        font-family: monospace;
    }

    .title-column {
        min-width: 200px;
    }

    .location-title h6 {
        margin: 0;
        font-weight: 600;
        color: var(--dark-color);
    }

    .location-title small {
        display: block;
        margin-top: 0.25rem;
    }

    .category-column {
        min-width: 150px;
    }

    .category-badge {
        display: inline-block;
        padding: 0.5rem 1rem;
        border-radius: 1rem;
        font-size: 0.8rem;
        font-weight: 600;
        background: var(--primary-color);
        color: white;
    }

    .category-badge.no-category {
        background: var(--border-color);
        color: var(--dark-color);
    }

    .location-column {
        min-width: 150px;
    }

    .location-info .province {
        font-weight: 600;
        color: var(--dark-color);
    }

    .location-info .city {
        font-size: 0.9rem;
        color: var(--dark-color);
        opacity: 0.8;
    }

    .coordinates {
        display: block;
        margin-top: 0.25rem;
        font-family: monospace;
        color: var(--info-color);
    }

    .status-column {
        width: 120px;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 1rem;
        border-radius: 1rem;
        font-size: 0.8rem;
        font-weight: 600;
    }

    .status-badge.active {
        background: var(--success-color);
        color: white;
    }

    .status-badge.inactive {
        background: var(--danger-color);
        color: white;
    }

    .rating-column {
        width: 120px;
    }

    .rating-display {
        text-align: center;
    }

    .stars {
        color: #ffc107;
        margin-bottom: 0.25rem;
    }

    .rating-number {
        font-size: 0.8rem;
        font-weight: 600;
        color: var(--dark-color);
    }

    .no-rating {
        color: var(--dark-color);
        opacity: 0.6;
        font-size: 0.8rem;
    }

    .date-column {
        width: 120px;
    }

    .date-info {
        text-align: center;
    }

    .persian-date {
        font-weight: 600;
        color: var(--dark-color);
    }

    .time {
        color: var(--dark-color);
        opacity: 0.7;
    }

    .actions-column {
        width: 150px;
    }

    .action-buttons-group {
        display: flex;
        gap: 0.25rem;
        justify-content: center;
        flex-wrap: wrap;
    }

    .action-buttons-group .btn {
        margin: 1px;
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }

    .btn-action {
        width: 32px;
        height: 32px;
        border: none;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: var(--transition);
        text-decoration: none;
        font-size: 0.8rem;
        margin: 0 2px;
    }

    .btn-view {
        background: var(--info-color);
        color: white;
    }

    .btn-edit {
        background: var(--warning-color);
        color: white;
    }

    .btn-map {
        background: var(--success-color);
        color: white;
    }

    .btn-toggle {
        background: var(--primary-color);
        color: white;
    }

    .btn-delete {
        background: var(--danger-color);
        color: white;
    }

    .btn-action:hover {
        transform: scale(1.1);
        box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.2);
    }

    /* Empty State */
    .empty-state {
        padding: 3rem;
        text-align: center;
    }

    /* Pagination */
    .modern-pagination {
        padding: 1.5rem 0;
        border-top: 2px solid var(--border-color);
        margin-top: 1.5rem;
    }

    /* Map Styles */
    .map-container {
        background: white;
        border-radius: var(--border-radius);
        height: 100%;
    }

    .map-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem 0 1rem 0;
        border-bottom: 2px solid var(--border-color);
        margin-bottom: 1.5rem;
    }

    .map-header h4 {
        margin: 0;
        color: var(--primary-color);
        font-weight: 700;
    }

    .map-controls {
        display: flex;
        gap: 0.5rem;
    }

    .locations-map {
        height: 600px;
        border-radius: var(--border-radius);
        border: 2px solid var(--border-color);
        margin-bottom: 1rem;
    }

    .map-legend {
        display: flex;
        gap: 2rem;
        justify-content: center;
        padding: 1rem;
        background: var(--light-color);
        border-radius: var(--border-radius);
    }

    .legend-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .legend-marker {
        width: 12px;
        height: 12px;
        border-radius: 50%;
    }

    .legend-marker.active {
        background: var(--success-color);
    }

    .legend-marker.inactive {
        background: var(--danger-color);
    }

    /* Cards Styles */
    .cards-container {
        background: white;
        border-radius: var(--border-radius);
    }

    .cards-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem 0 1rem 0;
        border-bottom: 2px solid var(--border-color);
        margin-bottom: 1.5rem;
    }

    .cards-header h4 {
        margin: 0;
        color: var(--primary-color);
        font-weight: 700;
    }

    .cards-controls {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .quick-search {
        min-width: 200px;
    }

    .quick-search input {
        border-radius: var(--border-radius);
        border: 1px solid var(--border-color);
    }

    .view-options {
        display: flex;
        gap: 0.25rem;
    }

    .view-options .btn-modern.active {
        background: var(--primary-color);
        color: white;
    }

    .locations-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
        gap: 1.25rem;
        margin-bottom: 2rem;
        padding: 1rem 0;
    }

    .location-card {
        background: white;
        border: 1px solid var(--border-color);
        border-radius: var(--border-radius);
        overflow: hidden;
        transition: var(--transition);
        position: relative;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        height: fit-content;
    }

    .location-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        border-color: var(--primary-color);
    }

    .card-header {
        position: relative;
        height: 200px;
        overflow: hidden;
    }

    .card-image {
        width: 100%;
        height: 100%;
        position: relative;
    }

    .card-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .card-image .no-image {
        width: 100%;
        height: 100%;
        background: var(--light-color);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 3rem;
        color: var(--dark-color);
        opacity: 0.5;
    }

    .card-status {
        position: absolute;
        top: 1rem;
        right: 1rem;
    }

    .card-body {
        padding: 1.5rem;
    }

    .card-title h5 {
        margin: 0 0 0.5rem 0;
        font-weight: 700;
        color: var(--dark-color);
    }

    .card-slogan {
        color: var(--dark-color);
        opacity: 0.8;
        margin: 0 0 1rem 0;
        font-size: 0.9rem;
    }

    .card-info {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .info-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.9rem;
        color: var(--dark-color);
    }

    .info-item i {
        width: 16px;
        color: var(--primary-color);
    }

    .card-footer {
        padding: 1rem 1.5rem;
        background: var(--light-color);
        border-top: 1px solid var(--border-color);
    }

    .card-actions {
        display: flex;
        justify-content: center;
        gap: 0.5rem;
        flex-wrap: wrap;
    }

    .btn-card {
        width: 40px;
        height: 40px;
        border: none;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: var(--transition);
        text-decoration: none;
        font-size: 1rem;
    }

    .btn-card:hover {
        transform: scale(1.1);
        box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.2);
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .modern-page-header {
            margin: -20px -15px 30px -15px;
            padding: 1.5rem 0;
        }

        .modern-page-header h1 {
            font-size: 2rem;
        }

        .stats-grid {
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }

        .filters-content {
            grid-template-columns: 1fr;
        }

        .action-buttons {
            flex-direction: column;
        }

        .table-header {
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .locations-grid {
            grid-template-columns: 1fr;
        }

        .modern-tabs .nav-link {
            padding: 0.75rem 1rem;
            font-size: 0.9rem;
        }
    }

    /* Animation Classes */
    .fade-in {
        animation: fadeIn 0.5s ease-in-out forwards;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .slide-in {
        animation: slideIn 0.3s ease-out;
    }

    @keyframes slideIn {
        from { transform: translateX(-100%); }
        to { transform: translateX(0); }
    }

    /* Loading States */
    .loading {
        position: relative;
        pointer-events: none;
    }

    .loading::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255,255,255,0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 10;
    }

    .loading::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 40px;
        height: 40px;
        margin: -20px 0 0 -20px;
        border: 4px solid var(--border-color);
        border-top: 4px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        z-index: 11;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Enhanced Search Suggestions */
    .search-input-wrapper {
        position: relative;
    }

    .search-suggestions {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        border: 2px solid var(--primary-color);
        border-top: none;
        border-radius: 0 0 var(--border-radius) var(--border-radius);
        box-shadow: var(--shadow);
        z-index: 1000;
        max-height: 300px;
        overflow-y: auto;
    }

    .suggestion-item {
        padding: 1rem;
        border-bottom: 1px solid var(--border-color);
        cursor: pointer;
        transition: var(--transition);
    }

    .suggestion-item:hover {
        background: var(--light-color);
    }

    .suggestion-item:last-child {
        border-bottom: none;
    }

    .suggestion-title {
        font-weight: 600;
        color: var(--dark-color);
        margin-bottom: 0.25rem;
    }

    .suggestion-category {
        font-size: 0.8rem;
        color: var(--primary-color);
    }

    /* Date Range Wrapper */
    .date-range-wrapper {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 0.5rem;
    }

    /* Enhanced Button Styles */
    .btn-info-modern {
        background: var(--info-color);
        color: white;
    }

    .btn-info-modern:hover {
        background: #258391;
        color: white;
    }

    /* Number Animation */
    .animate-number {
        animation: numberPulse 0.5s ease-in-out;
    }

    /* Chart loading animation */
    .chart-loading {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 300px;
        font-family: 'IRANSans', sans-serif;
        color: #6c757d;
    }

    .chart-loading i {
        margin-left: 10px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Improved table styles */
    .table-responsive {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .table th {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        font-weight: 600;
        border: none;
        padding: 15px 12px;
    }

    .table td {
        padding: 12px;
        vertical-align: middle;
        border-color: #e9ecef;
    }

    .table tbody tr:hover {
        background-color: #f8f9fa;
        transform: translateY(-1px);
        transition: all 0.2s ease;
    }

    /* Status badges */
    .badge {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
        border-radius: 50px;
    }

    /* Action buttons */
    .btn-sm {
        padding: 0.25rem 0.75rem;
        font-size: 0.875rem;
        border-radius: 6px;
        margin: 0 2px;
    }

    /* Pagination */
    .pagination {
        margin: 0;
    }

    .page-link {
        border-radius: 6px;
        margin: 0 2px;
        border: 1px solid #dee2e6;
    }

    .page-link:hover {
        background-color: #e9ecef;
        border-color: #adb5bd;
    }

    @keyframes numberPulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.1); }
        100% { transform: scale(1); }
    }

    /* Enhanced Loading State */
    body.loading {
        overflow: hidden;
    }

    body.loading::after {
        content: '';
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255, 255, 255, 0.9);
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    body.loading::before {
        content: '';
        position: fixed;
        top: 50%;
        left: 50%;
        width: 60px;
        height: 60px;
        margin: -30px 0 0 -30px;
        border: 6px solid var(--border-color);
        border-top: 6px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        z-index: 10000;
    }

    /* Enhanced Image Lightbox */
    .table-image {
        cursor: pointer;
        transition: var(--transition);
    }

    .table-image:hover {
        transform: scale(1.05);
        box-shadow: var(--shadow);
    }

    /* Improved Responsive Design */
    @media (max-width: 576px) {
        .date-range-wrapper {
            grid-template-columns: 1fr;
        }

        .search-suggestions {
            position: fixed;
            top: auto;
            bottom: 0;
            left: 0;
            right: 0;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
            max-height: 50vh;
        }
    }

    /* Print Styles */
    @media print {
        .modern-page-header,
        .filters-section,
        .action-buttons,
        .bulk-actions,
        .content-tabs .nav-tabs {
            display: none !important;
        }

        .modern-table {
            font-size: 0.8rem;
        }

        .stat-card {
            break-inside: avoid;
        }
    }

    /* High Contrast Mode Support */
    @media (prefers-contrast: high) {
        .stat-card {
            border: 3px solid #000;
        }

        .modern-table th {
            background: #000;
            color: #fff;
        }

        .btn-modern {
            border: 2px solid #000;
        }
    }

    /* Reduced Motion Support */
    @media (prefers-reduced-motion: reduce) {
        .stat-card,
        .location-card,
        .btn-modern,
        .btn-action {
            transition: none;
        }

        .fade-in,
        .slide-in,
        .animate-number {
            animation: none;
        }
    }

    /* Bulk Actions Styles */
    .bulk-actions {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 1rem 1.5rem;
        border-radius: var(--border-radius-md);
        margin-bottom: 1.5rem;
        box-shadow: var(--shadow-md);
        animation: slideDown 0.3s ease;
    }

    .bulk-actions .btn {
        border: 2px solid rgba(255,255,255,0.3);
        color: white;
        font-weight: 600;
        transition: var(--transition-normal);
    }

    .bulk-actions .btn:hover {
        background: rgba(255,255,255,0.2);
        border-color: rgba(255,255,255,0.5);
        transform: translateY(-1px);
    }

    /* Chart Cards */
    .chart-card {
        background: white;
        border-radius: var(--border-radius-md);
        box-shadow: var(--shadow-md);
        border: 1px solid #e3e6f0;
        overflow: hidden;
        transition: var(--transition-normal);
    }

    .chart-card:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-lg);
    }

    .chart-header {
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        padding: 1rem 1.5rem;
        border-bottom: 1px solid #e3e6f0;
    }

    .chart-header h5 {
        margin: 0;
        color: #4e73df;
        font-weight: 700;
        font-size: 1.1rem;
    }

    .chart-body {
        padding: 1.5rem;
        position: relative;
        min-height: 300px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .chart-body canvas {
        max-width: 100%;
        height: auto !important;
    }

    /* Detailed Stats Table */
    .detailed-stats {
        background: white;
        border-radius: var(--border-radius-md);
        box-shadow: var(--shadow-md);
        border: 1px solid #e3e6f0;
        margin-top: 2rem;
        overflow: hidden;
    }

    .stats-table-header {
        background: var(--primary-gradient);
        color: white;
        padding: 1rem 1.5rem;
    }

    .stats-table-header h5 {
        margin: 0;
        font-weight: 700;
    }

    .detailed-stats .table {
        margin: 0;
    }

    .detailed-stats .table th {
        background: #f8f9fc;
        color: #4e73df;
        font-weight: 600;
        border: none;
        padding: 1rem;
    }

    .detailed-stats .table td {
        padding: 1rem;
        border-bottom: 1px solid #e3e6f0;
        vertical-align: middle;
    }

    .detailed-stats .table tbody tr:hover {
        background: #f8f9fc;
    }

    /* Stats Controls */
    .stats-controls {
        display: flex;
        gap: 0.5rem;
    }

    .stats-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #e3e6f0;
    }

    .stats-header h4 {
        margin: 0;
        color: #4e73df;
        font-weight: 700;
        font-size: 1.5rem;
    }

    /* Animation for charts loading */
    .chart-loading {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #6c757d;
        font-size: 1.2rem;
    }

    .chart-loading i {
        animation: spin 1s linear infinite;
        margin-right: 0.5rem;
    }

    /* Dark Mode Support */
    @media (prefers-color-scheme: dark) {
        :root {
            --primary-color: #6c7ae0;
            --success-color: #28a745;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
            --info-color: #17a2b8;
            --light-color: #2d2d2d;
            --dark-color: #e0e0e0;
            --border-color: #444;
            --shadow: 0 0.15rem 1.75rem 0 rgba(0, 0, 0, 0.3);
        }

        body {
            background-color: #1a1a1a;
            color: #e0e0e0;
        }

        .modern-table,
        .stat-card,
        .filters-section,
        .content-tabs,
        .location-card,
        .chart-card,
        .detailed-stats {
            background-color: #2d2d2d;
            color: #e0e0e0;
            border-color: #444;
        }

        .chart-header,
        .stats-table-header {
            background: #444;
            color: #e0e0e0;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid" style="padding: 0;">
    <!-- Modern Page Header -->
    <div class="modern-page-header">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1><i class="fas fa-map-marker-alt me-3"></i>مدیریت مکان‌ها</h1>
                    <p class="subtitle mb-0">مدیریت کامل مکان‌ها، دسته‌بندی‌ها و اطلاعات جغرافیایی</p>
                </div>
                <div class="col-md-4 text-end">
                    <a href="{{ route('admin.locations.create') }}" class="btn btn-light btn-lg">
                        <i class="fas fa-plus me-2"></i>افزودن مکان جدید
                    </a>
                </div>
            </div>
        </div>
    </div>

<div class="container-fluid" style="padding: 1.5rem;">
    <!-- Enhanced Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card total" onclick="filterByStatus('all')">
            <div class="card-content">
                <div class="icon">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <div class="info">
                    <div class="number" id="totalLocations">{{ number_format($stats['total'] ?? 0) }}</div>
                    <div class="label">کل مکان‌ها</div>
                    <div class="trend up">
                        <i class="fas fa-arrow-up"></i>
                        <span>+{{ number_format($stats['this_month'] ?? 0) }} این ماه</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card active" onclick="filterByStatus('active')">
            <div class="card-content">
                <div class="icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="info">
                    <div class="number" id="activeLocations">{{ number_format($stats['active'] ?? 0) }}</div>
                    <div class="label">مکان‌های فعال</div>
                    <div class="trend up">
                        <i class="fas fa-percentage"></i>
                        <span>{{ $stats['total'] > 0 ? round(($stats['active'] / $stats['total']) * 100, 1) : 0 }}% از کل</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card inactive" onclick="filterByStatus('inactive')">
            <div class="card-content">
                <div class="icon">
                    <i class="fas fa-times-circle"></i>
                </div>
                <div class="info">
                    <div class="number" id="inactiveLocations">{{ number_format($stats['inactive'] ?? 0) }}</div>
                    <div class="label">مکان‌های غیرفعال</div>
                    <div class="trend down">
                        <i class="fas fa-percentage"></i>
                        <span>{{ $stats['total'] > 0 ? round(($stats['inactive'] / $stats['total']) * 100, 1) : 0 }}% از کل</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card coordinates" onclick="filterByCoordinates()">
            <div class="card-content">
                <div class="icon">
                    <i class="fas fa-globe"></i>
                </div>
                <div class="info">
                    <div class="number" id="withCoordinates">{{ number_format($stats['with_coordinates'] ?? 0) }}</div>
                    <div class="label">دارای مختصات</div>
                    <div class="trend up">
                        <i class="fas fa-percentage"></i>
                        <span>{{ $stats['total'] > 0 ? round(($stats['with_coordinates'] / $stats['total']) * 100, 1) : 0 }}% از کل</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="stat-card today" onclick="filterByDate('today')">
            <div class="card-content">
                <div class="icon">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="info">
                    <div class="number" id="todayLocations">{{ number_format($stats['today'] ?? 0) }}</div>
                    <div class="label">امروز</div>
                    <div class="trend">
                        <i class="fas fa-clock"></i>
                        <span>{{ number_format($stats['this_week'] ?? 0) }} این هفته</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters -->
    <div class="filters-section">
        <div class="filters-header">
            <h3 class="filters-title">
                <i class="fas fa-filter me-2"></i>فیلترهای پیشرفته
            </h3>
            <button class="filter-toggle" id="toggleFilters">
                <i class="fas fa-chevron-down"></i>
            </button>
        </div>

        <div class="filters-content" id="filtersContent" style="display: block;">
            <div class="filter-group">
                <label for="categoryFilter">
                    <i class="fas fa-tags me-1"></i>دسته‌بندی
                </label>
                <select class="modern-select" id="categoryFilter" name="category_id">
                    <option value="">همه دسته‌بندی‌ها</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                            @if($category->emoji){{ $category->emoji }} @endif
                            {{ $category->getTranslatedName(app()->getLocale()) }}
                            @if($category->locations_count ?? 0)
                                ({{ number_format($category->locations_count) }})
                            @endif
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="filter-group">
                <label for="statusFilter">
                    <i class="fas fa-toggle-on me-1"></i>وضعیت
                </label>
                <select class="modern-select" id="statusFilter" name="is_active">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="1" {{ request('is_active') == '1' ? 'selected' : '' }}>فعال</option>
                    <option value="0" {{ request('is_active') == '0' ? 'selected' : '' }}>غیرفعال</option>
                </select>
            </div>

            <div class="filter-group">
                <label for="provinceFilter">
                    <i class="fas fa-map me-1"></i>استان
                </label>
                <select class="modern-select" id="provinceFilter" name="province_id">
                    <option value="">همه استان‌ها</option>
                    <!-- Will be populated via AJAX -->
                </select>
            </div>

            <div class="filter-group">
                <label for="cityFilter">
                    <i class="fas fa-city me-1"></i>شهر
                </label>
                <select class="modern-select" id="cityFilter" name="city_id">
                    <option value="">همه شهرها</option>
                    <!-- Will be populated via AJAX -->
                </select>
            </div>

            <div class="filter-group">
                <label for="searchFilter">
                    <i class="fas fa-search me-1"></i>جستجوی زنده
                </label>
                <div class="search-input-wrapper">
                    <input type="text" class="modern-input" id="searchFilter" name="search"
                           placeholder="جستجو در عنوان، توضیحات، آدرس..."
                           value="{{ request('search') }}">
                    <div class="search-suggestions" id="searchSuggestions" style="display: none;"></div>
                </div>
            </div>

            <div class="filter-group">
                <label for="dateRangeFilter">
                    <i class="fas fa-calendar-alt me-1"></i>بازه تاریخ
                </label>
                <div class="date-range-wrapper">
                    <input type="date" class="modern-input" id="dateFromFilter" name="date_from"
                           placeholder="از تاریخ" value="{{ request('date_from') }}">
                    <input type="date" class="modern-input" id="dateToFilter" name="date_to"
                           placeholder="تا تاریخ" value="{{ request('date_to') }}">
                </div>
            </div>

            <div class="filter-group">
                <label for="coordinatesFilter">
                    <i class="fas fa-globe me-1"></i>مختصات جغرافیایی
                </label>
                <select class="modern-select" id="coordinatesFilter" name="has_coordinates">
                    <option value="">همه مکان‌ها</option>
                    <option value="1" {{ request('has_coordinates') == '1' ? 'selected' : '' }}>دارای مختصات</option>
                    <option value="0" {{ request('has_coordinates') == '0' ? 'selected' : '' }}>بدون مختصات</option>
                </select>
            </div>

            <div class="filter-group">
                <label for="ratingFilter">
                    <i class="fas fa-star me-1"></i>امتیاز
                </label>
                <select class="modern-select" id="ratingFilter" name="min_rating">
                    <option value="">همه امتیازها</option>
                    <option value="5" {{ request('min_rating') == '5' ? 'selected' : '' }}>5 ستاره</option>
                    <option value="4" {{ request('min_rating') == '4' ? 'selected' : '' }}>4+ ستاره</option>
                    <option value="3" {{ request('min_rating') == '3' ? 'selected' : '' }}>3+ ستاره</option>
                    <option value="2" {{ request('min_rating') == '2' ? 'selected' : '' }}>2+ ستاره</option>
                    <option value="1" {{ request('min_rating') == '1' ? 'selected' : '' }}>1+ ستاره</option>
                </select>
            </div>
        </div>

        <div class="action-buttons">
            <button class="btn-modern btn-primary-modern" id="applyFilters">
                <i class="fas fa-search"></i>اعمال فیلترها
            </button>
            <button class="btn-modern btn-outline-modern" id="clearFilters">
                <i class="fas fa-eraser"></i>پاک کردن فیلترها
            </button>
            <button class="btn-modern btn-success-modern" id="exportExcel">
                <i class="fas fa-file-excel"></i>خروجی اکسل
            </button>
            <button class="btn-modern btn-info-modern" id="exportPDF">
                <i class="fas fa-file-pdf"></i>خروجی PDF
            </button>
            <button class="btn-modern btn-warning-modern" id="bulkActions">
                <i class="fas fa-tasks"></i>عملیات گروهی
            </button>
            <button class="btn-modern btn-outline-modern" id="refreshStats">
                <i class="fas fa-sync-alt"></i>بروزرسانی آمار
            </button>
        </div>
    </div>

    <!-- Bulk Actions Panel -->
    <div class="filters-section" id="bulkActionsPanel" style="display: none;">
        <div class="filters-header">
            <h3 class="filters-title">
                <i class="fas fa-tasks me-2"></i>عملیات گروهی
            </h3>
            <span class="badge bg-primary" id="selectedCount">0 مورد انتخاب شده</span>
        </div>

        <div class="action-buttons">
            <button class="btn-modern btn-success-modern" id="bulkActivate">
                <i class="fas fa-check"></i>فعال کردن
            </button>
            <button class="btn-modern btn-warning-modern" id="bulkDeactivate">
                <i class="fas fa-times"></i>غیرفعال کردن
            </button>
            <button class="btn-modern btn-danger-modern" id="bulkDelete">
                <i class="fas fa-trash"></i>حذف
            </button>
            <button class="btn-modern btn-outline-modern" id="cancelBulk">
                <i class="fas fa-times"></i>انصراف
            </button>
        </div>
    </div>

    <!-- Bulk Actions Panel -->
    <div class="bulk-actions" id="bulkActionsPanel" style="display: none;">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <span id="selectedCount" class="fw-bold text-primary">0 مورد انتخاب شده</span>
            </div>
            <div class="d-flex gap-2">
                <button class="btn btn-success btn-sm" id="bulkActivate">
                    <i class="fas fa-check"></i> فعال کردن
                </button>
                <button class="btn btn-warning btn-sm" id="bulkDeactivate">
                    <i class="fas fa-times"></i> غیرفعال کردن
                </button>
                <button class="btn btn-danger btn-sm" id="bulkDelete">
                    <i class="fas fa-trash"></i> حذف
                </button>
                <button class="btn btn-secondary btn-sm" id="cancelBulk">
                    <i class="fas fa-times"></i> انصراف
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content Tabs -->
    <div class="content-tabs">
        <ul class="nav nav-tabs modern-tabs" id="contentTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="table-tab" data-bs-toggle="tab" data-bs-target="#table-content" type="button" role="tab" aria-controls="table-content" aria-selected="true">
                    <i class="fas fa-table me-2"></i>جدول مکان‌ها
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="map-tab" data-bs-toggle="tab" data-bs-target="#map-content" type="button" role="tab" aria-controls="map-content" aria-selected="false">
                    <i class="fas fa-map me-2"></i>نمایش نقشه
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="cards-tab" data-bs-toggle="tab" data-bs-target="#cards-content" type="button" role="tab" aria-controls="cards-content" aria-selected="false">
                    <i class="fas fa-th-large me-2"></i>نمایش کارتی
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="stats-tab" data-bs-toggle="tab" data-bs-target="#stats-content" type="button" role="tab" aria-controls="stats-content" aria-selected="false">
                    <i class="fas fa-chart-pie me-2"></i>آمار و نمودار
                </button>
            </li>
        </ul>

        <div class="tab-content modern-tab-content" id="contentTabsContent">
            <!-- Table View -->
            <div class="tab-pane fade show active" id="table-content" role="tabpanel">
                <div class="modern-table-container">
                    <div class="table-header">
                        <div class="table-title">
                            <h4><i class="fas fa-list me-2"></i>لیست مکان‌ها</h4>
                            <span class="table-count">{{ number_format($locations->total()) }} مکان</span>
                        </div>
                        <div class="table-actions">
                            <button class="btn-modern btn-outline-modern btn-sm" id="refreshTable">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn-modern btn-outline-modern btn-sm" id="columnSettings">
                                <i class="fas fa-columns"></i>
                            </button>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table modern-table" id="locationsTable">
                            <thead>
                                <tr>
                                    <th class="select-column">
                                        <input type="checkbox" id="selectAll" class="form-check-input">
                                    </th>
                                    <th>تصویر</th>
                                    <th>شناسه</th>
                                    <th>عنوان</th>
                                    <th>دسته‌بندی</th>
                                    <th>موقعیت</th>
                                    <th>وضعیت</th>
                                    <th>امتیاز</th>
                                    <th>تاریخ ایجاد</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($locations as $location)
                                    <tr data-id="{{ $location->id }}">
                                        <td class="select-column">
                                            <input type="checkbox" class="form-check-input row-select" value="{{ $location->id }}">
                                        </td>
                                        <td class="image-column">
                                            @php
                                                $images = $location->images;
                                                if (is_string($images)) {
                                                    $images = json_decode($images, true);
                                                }
                                                $hasImages = is_array($images) && count($images) > 0;
                                            @endphp
                                            @if($hasImages)
                                                <div class="location-image">
                                                    <img src="{{ asset('storage/' . $images[0]) }}" alt="{{ $location->title }}" class="table-image" onerror="this.parentElement.innerHTML='<div class=\'no-image\'><i class=\'fas fa-image\'></i></div>'">
                                                    @if(count($images) > 1)
                                                        <span class="image-count">+{{ count($images) - 1 }}</span>
                                                    @endif
                                                </div>
                                            @else
                                                <div class="no-image">
                                                    <i class="fas fa-image"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td class="id-column">
                                            <span class="location-id">#{{ $location->id }}</span>
                                        </td>
                                        <td class="title-column">
                                            <div class="location-title">
                                                <h6>{{ $location->title }}</h6>
                                                @if($location->Slogan)
                                                    <small class="text-muted">{{ Str::limit($location->Slogan, 50) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="category-column">
                                            @if($location->category_id && is_object($location->categoryRelation))
                                                <span class="category-badge" style="background-color: {{ $location->categoryRelation->color ?? '#4e73df' }}20; color: {{ $location->categoryRelation->color ?? '#4e73df' }};">
                                                    @if($location->categoryRelation->emoji)
                                                        {{ $location->categoryRelation->emoji }}
                                                    @endif
                                                    {{ $location->categoryRelation->getTranslatedName(app()->getLocale()) }}
                                                </span>
                                            @elseif($location->category_fa)
                                                <span class="category-badge">{{ $location->category_fa }}</span>
                                            @else
                                                <span class="category-badge no-category">بدون دسته‌بندی</span>
                                            @endif
                                        </td>
                                        <td class="location-column">
                                            <div class="location-info">
                                                @if($location->province_id)
                                                    <div class="province">{{ $location->province->name ?? '-' }}</div>
                                                    @if($location->city_id)
                                                        <div class="city">{{ $location->city->name ?? '' }}</div>
                                                    @endif
                                                @else
                                                    <span class="text-muted">نامشخص</span>
                                                @endif
                                                @if($location->lat && $location->lng)
                                                    <small class="coordinates">
                                                        <i class="fas fa-map-marker-alt"></i>
                                                        {{ number_format($location->lat, 4) }}, {{ number_format($location->lng, 4) }}
                                                    </small>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="status-column">
                                            <div class="status-toggle">
                                                @if($location->is_active)
                                                    <span class="status-badge active">
                                                        <i class="fas fa-check-circle"></i>فعال
                                                    </span>
                                                @else
                                                    <span class="status-badge inactive">
                                                        <i class="fas fa-times-circle"></i>غیرفعال
                                                    </span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="rating-column">
                                            @if($location->star_rating)
                                                <div class="rating-display">
                                                    <div class="stars">
                                                        @for($i = 1; $i <= 5; $i++)
                                                            @if($i <= $location->star_rating)
                                                                <i class="fas fa-star"></i>
                                                            @else
                                                                <i class="far fa-star"></i>
                                                            @endif
                                                        @endfor
                                                    </div>
                                                    <span class="rating-number">{{ $location->star_rating }}/5</span>
                                                </div>
                                            @else
                                                <span class="no-rating">بدون امتیاز</span>
                                            @endif
                                        </td>
                                        <td class="date-column">
                                            @if($location->created_at)
                                                <div class="date-info">
                                                    <div class="persian-date">
                                                        {{ \Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d') }}
                                                    </div>
                                                    <small class="time">
                                                        {{ \Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('H:i') }}
                                                    </small>
                                                </div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="actions-column">
                                            <div class="action-buttons-group">
                                                <a href="{{ route('admin.locations.show', $location->id) }}" class="btn btn-sm btn-info" title="مشاهده">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.locations.edit', $location->id) }}" class="btn btn-sm btn-warning" title="ویرایش">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @if($location->lat && $location->lng)
                                                    <button class="btn btn-sm btn-success" title="نمایش در نقشه" onclick="showOnMap({{ $location->lat }}, {{ $location->lng }}, '{{ addslashes($location->title) }}')">
                                                        <i class="fas fa-map-marker-alt"></i>
                                                    </button>
                                                @endif
                                                <button class="btn btn-sm btn-{{ $location->is_active ? 'secondary' : 'primary' }}" title="تغییر وضعیت" onclick="toggleStatus({{ $location->id }})">
                                                    <i class="fas fa-toggle-{{ $location->is_active ? 'on' : 'off' }}"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger" title="حذف" onclick="deleteLocation({{ $location->id }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center py-5">
                                            <div class="empty-state">
                                                <i class="fas fa-map-marker-alt fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">هیچ مکانی یافت نشد</h5>
                                                <p class="text-muted">برای شروع، مکان جدیدی اضافه کنید</p>
                                                <a href="{{ route('admin.locations.create') }}" class="btn-modern btn-primary-modern">
                                                    <i class="fas fa-plus me-2"></i>افزودن مکان جدید
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="modern-pagination">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="pagination-info">
                                <small class="text-muted">
                                    نمایش {{ $locations->firstItem() ?? 0 }} تا {{ $locations->lastItem() ?? 0 }} از {{ $locations->total() }} مورد
                                </small>
                            </div>
                            <div class="pagination-links">
                                {{ $locations->appends(request()->query())->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Map View -->
            <div class="tab-pane fade" id="map-content" role="tabpanel">
                <div class="map-container">
                    <div class="map-header">
                        <h4><i class="fas fa-map me-2"></i>نقشه مکان‌ها</h4>
                        <div class="map-controls">
                            <button class="btn-modern btn-outline-modern btn-sm" id="fitAllMarkers">
                                <i class="fas fa-expand-arrows-alt"></i>نمایش همه
                            </button>
                            <button class="btn-modern btn-outline-modern btn-sm" id="toggleClustering">
                                <i class="fas fa-layer-group"></i>خوشه‌بندی
                            </button>
                            <button class="btn-modern btn-outline-modern btn-sm" id="toggleHeatmap">
                                <i class="fas fa-fire"></i>نقشه حرارتی
                            </button>
                        </div>
                    </div>
                    <div id="locationsMap" class="locations-map"></div>
                    <div class="map-legend">
                        <div class="legend-item">
                            <span class="legend-marker active"></span>
                            <span>مکان‌های فعال</span>
                        </div>
                        <div class="legend-item">
                            <span class="legend-marker inactive"></span>
                            <span>مکان‌های غیرفعال</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cards View -->
            <div class="tab-pane fade" id="cards-content" role="tabpanel">
                <div class="cards-container">
                    <div class="cards-header">
                        <h4><i class="fas fa-th-large me-2"></i>نمایش کارتی مکان‌ها</h4>
                        <div class="cards-controls">
                            <div class="quick-search">
                                <input type="text" class="form-control form-control-sm" id="quickSearch" placeholder="جستجو سریع...">
                            </div>
                            <div class="view-options">
                                <button class="btn-modern btn-outline-modern btn-sm" data-view="grid" title="نمایش شبکه‌ای">
                                    <i class="fas fa-th"></i>
                                </button>
                                <button class="btn-modern btn-outline-modern btn-sm active" data-view="list" title="نمایش لیستی">
                                    <i class="fas fa-list"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="locations-grid" id="locationsGrid">
                        @foreach($locations as $location)
                            <div class="location-card fade-in" data-id="{{ $location->id }}" style="animation-delay: {{ $loop->index * 0.1 }}s;">
                                <div class="card-header">
                                    <div class="card-image">
                                        @if($location->images && is_array($location->images) && count($location->images) > 0)
                                            <img src="{{ asset('storage/' . $location->images[0]) }}" alt="{{ $location->title }}">
                                            @if(count($location->images) > 1)
                                                <span class="image-count">+{{ count($location->images) - 1 }}</span>
                                            @endif
                                        @else
                                            <div class="no-image">
                                                <i class="fas fa-image"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="card-status">
                                        @if($location->is_active)
                                            <span class="status-badge active">فعال</span>
                                        @else
                                            <span class="status-badge inactive">غیرفعال</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="card-title">
                                        <h5>{{ $location->title }}</h5>
                                        @if($location->Slogan)
                                            <p class="card-slogan">{{ $location->Slogan }}</p>
                                        @endif
                                    </div>

                                    <div class="card-info">
                                        <div class="info-item">
                                            <i class="fas fa-tag"></i>
                                            @if($location->category_id && is_object($location->categoryRelation))
                                                <span>{{ $location->categoryRelation->getTranslatedName(app()->getLocale()) }}</span>
                                            @else
                                                <span>بدون دسته‌بندی</span>
                                            @endif
                                        </div>

                                        <div class="info-item">
                                            <i class="fas fa-map-marker-alt"></i>
                                            @if($location->province_id)
                                                <span>{{ $location->province->name ?? '-' }}@if($location->city_id), {{ $location->city->name ?? '' }}@endif</span>
                                            @else
                                                <span>نامشخص</span>
                                            @endif
                                        </div>

                                        @if($location->star_rating)
                                            <div class="info-item">
                                                <i class="fas fa-star"></i>
                                                <span>{{ $location->star_rating }}/5</span>
                                            </div>
                                        @endif

                                        <div class="info-item">
                                            <i class="fas fa-calendar"></i>
                                            <span>{{ \Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer">
                                    <div class="card-actions">
                                        <a href="{{ route('admin.locations.show', $location->id) }}" class="btn-card btn-view">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.locations.edit', $location->id) }}" class="btn-card btn-edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if($location->lat && $location->lng)
                                            <button class="btn-card btn-map" onclick="showOnMap({{ $location->lat }}, {{ $location->lng }}, '{{ $location->title }}')">
                                                <i class="fas fa-map-marker-alt"></i>
                                            </button>
                                        @endif
                                        <button class="btn-card btn-toggle" onclick="toggleStatus({{ $location->id }})">
                                            <i class="fas fa-toggle-{{ $location->is_active ? 'on' : 'off' }}"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Cards Pagination -->
                    <div class="modern-pagination">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="pagination-info">
                                <small class="text-muted">
                                    نمایش {{ $locations->firstItem() ?? 0 }} تا {{ $locations->lastItem() ?? 0 }} از {{ $locations->total() }} مورد
                                </small>
                            </div>
                            <div class="pagination-links">
                                {{ $locations->appends(request()->query())->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics and Charts View -->
            <div class="tab-pane fade" id="stats-content" role="tabpanel">
                <div class="stats-container">
                    <div class="stats-header">
                        <h4><i class="fas fa-chart-pie me-2"></i>آمار و تحلیل مکان‌ها</h4>
                        <div class="stats-controls">
                            <button class="btn-modern btn-outline-modern btn-sm" id="refreshCharts">
                                <i class="fas fa-sync-alt"></i>بروزرسانی
                            </button>
                            <button class="btn-modern btn-outline-modern btn-sm" id="exportCharts">
                                <i class="fas fa-download"></i>دانلود نمودار
                            </button>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Status Distribution Chart -->
                        <div class="col-md-6 mb-4">
                            <div class="chart-card">
                                <div class="chart-header">
                                    <h5><i class="fas fa-pie-chart me-2"></i>توزیع وضعیت مکان‌ها</h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="statusChart" width="400" height="300"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Category Distribution Chart -->
                        <div class="col-md-6 mb-4">
                            <div class="chart-card">
                                <div class="chart-header">
                                    <h5><i class="fas fa-bar-chart me-2"></i>توزیع دسته‌بندی‌ها</h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="categoryChart" width="400" height="300"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Monthly Growth Chart -->
                        <div class="col-md-12 mb-4">
                            <div class="chart-card">
                                <div class="chart-header">
                                    <h5><i class="fas fa-line-chart me-2"></i>رشد ماهانه مکان‌ها</h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="growthChart" width="800" height="400"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Geographic Distribution -->
                        <div class="col-md-6 mb-4">
                            <div class="chart-card">
                                <div class="chart-header">
                                    <h5><i class="fas fa-map me-2"></i>توزیع جغرافیایی</h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="geoChart" width="400" height="300"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- Rating Distribution -->
                        <div class="col-md-6 mb-4">
                            <div class="chart-card">
                                <div class="chart-header">
                                    <h5><i class="fas fa-star me-2"></i>توزیع امتیازات</h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="ratingChart" width="400" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detailed Statistics Table -->
                    <div class="detailed-stats">
                        <div class="stats-table-header">
                            <h5><i class="fas fa-table me-2"></i>آمار تفصیلی</h5>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>شاخص</th>
                                        <th>مقدار</th>
                                        <th>درصد</th>
                                        <th>تغییر نسبت به ماه قبل</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><i class="fas fa-map-marker-alt text-primary"></i> کل مکان‌ها</td>
                                        <td>{{ number_format($stats['total'] ?? 0) }}</td>
                                        <td>100%</td>
                                        <td><span class="text-success"><i class="fas fa-arrow-up"></i> +{{ number_format($stats['this_month'] ?? 0) }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fas fa-check-circle text-success"></i> مکان‌های فعال</td>
                                        <td>{{ number_format($stats['active'] ?? 0) }}</td>
                                        <td>{{ $stats['total'] > 0 ? round(($stats['active'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        <td><span class="text-success"><i class="fas fa-arrow-up"></i> +5.2%</span></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fas fa-times-circle text-danger"></i> مکان‌های غیرفعال</td>
                                        <td>{{ number_format($stats['inactive'] ?? 0) }}</td>
                                        <td>{{ $stats['total'] > 0 ? round(($stats['inactive'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        <td><span class="text-danger"><i class="fas fa-arrow-down"></i> -2.1%</span></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fas fa-globe text-info"></i> دارای مختصات</td>
                                        <td>{{ number_format($stats['with_coordinates'] ?? 0) }}</td>
                                        <td>{{ $stats['total'] > 0 ? round(($stats['with_coordinates'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        <td><span class="text-success"><i class="fas fa-arrow-up"></i> +3.8%</span></td>
                                    </tr>
                                    <tr>
                                        <td><i class="fas fa-calendar-day text-warning"></i> امروز</td>
                                        <td>{{ number_format($stats['today'] ?? 0) }}</td>
                                        <td>{{ $stats['total'] > 0 ? round(($stats['today'] / $stats['total']) * 100, 2) : 0 }}%</td>
                                        <td><span class="text-info"><i class="fas fa-clock"></i> جدید</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://unpkg.com/leaflet.markercluster@1.4.1/dist/leaflet.markercluster.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/lightbox2@2.11.4/dist/js/lightbox.min.js"></script>
<script src="{{ asset('js/admin/modern-locations.js') }}"></script>
<script>
// Enhanced JavaScript for Modern Locations Management
$(document).ready(function() {
    // Check if external script is loaded
    if (typeof initializeModernLocations === 'function') {
        initializeModernLocations();
    } else {
        // Fallback initialization
        console.warn('modern-locations.js not loaded, using fallback initialization');
        initializeFallback();
    }
});

// Fallback initialization function
function initializeFallback() {
    // Basic initialization without external dependencies
    console.log('Initializing locations page with fallback methods...');

    // Initialize basic components
    initializeFilters();
    initializeBulkActions();
    initializeStatistics();
}

    // Add location markers to map if map is initialized
    if (typeof markersGroup !== 'undefined' && markersGroup) {
        @if(isset($locations) && $locations->count() > 0)
            @foreach($locations as $location)
                @if($location->lat && $location->lng)
                    addLocationMarker(
                        {{ $location->lat }},
                        {{ $location->lng }},
                        '{{ addslashes($location->title) }}',
                        '{{ $location->is_active ? "active" : "inactive" }}',
                        {{ $location->id }}
                    );
                @endif
            @endforeach
        @endif
    }

    // Initialize live search
    initializeLiveSearch();

    // Initialize filter interactions
    initializeFilters();

    // Initialize bulk actions
    initializeBulkActions();

    // Initialize statistics interactions
    initializeStatistics();
}

// Initialize modern locations functionality
function initializeModernLocations() {
    // Animate statistics cards on load
    $('.stat-card').each(function(index) {
        $(this).css('animation-delay', (index * 0.1) + 's').addClass('fade-in');
    });

    // Initialize tooltips
    $('[title]').tooltip();

    // Initialize lightbox for images
    lightbox.option({
        'resizeDuration': 200,
        'wrapAround': true,
        'albumLabel': 'تصویر %1 از %2'
    });
}

// Live search functionality
function initializeLiveSearch() {
    let searchTimeout;

    $('#searchFilter').on('input', function() {
        clearTimeout(searchTimeout);
        const query = $(this).val();

        if (query.length >= 2) {
            searchTimeout = setTimeout(() => {
                performLiveSearch(query);
            }, 300);
        } else if (query.length === 0) {
            $('#searchSuggestions').hide();
        }
    });
}

function performLiveSearch(query) {
    $.ajax({
        url: '/fa/admin/locations/search',
        method: 'GET',
        data: { q: query },
        success: function(response) {
            displaySearchSuggestions(response.suggestions);
        },
        error: function() {
            console.log('خطا در جستجو');
        }
    });
}

function displaySearchSuggestions(suggestions) {
    const container = $('#searchSuggestions');
    container.empty();

    if (suggestions.length > 0) {
        suggestions.forEach(suggestion => {
            const item = $(`
                <div class="suggestion-item" data-id="${suggestion.id}">
                    <div class="suggestion-title">${suggestion.title}</div>
                    <div class="suggestion-category">${suggestion.category}</div>
                </div>
            `);

            item.on('click', function() {
                $('#searchFilter').val(suggestion.title);
                container.hide();
                applyFilters();
            });

            container.append(item);
        });

        container.show();
    } else {
        container.hide();
    }
}

// Initialize filters functionality
function initializeFilters() {
    // Filter toggle
    $('#toggleFilters').on('click', function() {
        const content = $('#filtersContent');
        const icon = $(this).find('i');

        if (content.is(':visible')) {
            content.slideUp();
            icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
        } else {
            content.slideDown();
            icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
        }
    });

    // Apply filters
    $('#applyFilters').on('click', applyFilters);

    // Clear filters
    $('#clearFilters').on('click', clearFilters);

    // Auto-apply filters on change
    $('.modern-select, .modern-input').on('change', function() {
        if ($(this).attr('id') !== 'searchFilter') {
            applyFilters();
        }
    });

    // Province/City cascade
    $('#provinceFilter').on('change', function() {
        loadCities($(this).val());
    });
}

function applyFilters() {
    const filters = {
        category_id: $('#categoryFilter').val(),
        is_active: $('#statusFilter').val(),
        province_id: $('#provinceFilter').val(),
        city_id: $('#cityFilter').val(),
        search: $('#searchFilter').val(),
        date_from: $('#dateFromFilter').val(),
        date_to: $('#dateToFilter').val(),
        has_coordinates: $('#coordinatesFilter').val(),
        min_rating: $('#ratingFilter').val()
    };

    // Show loading
    showLoading();

    // Build URL with filters
    const url = new URL(window.location.href);
    Object.keys(filters).forEach(key => {
        if (filters[key]) {
            url.searchParams.set(key, filters[key]);
        } else {
            url.searchParams.delete(key);
        }
    });

    // Redirect with filters
    window.location.href = url.toString();
}

function clearFilters() {
    $('.modern-select').val('');
    $('.modern-input').val('');
    $('#cityFilter').empty().append('<option value="">همه شهرها</option>');

    // Redirect without filters
    window.location.href = window.location.pathname;
}

function loadCities(provinceId) {
    const citySelect = $('#cityFilter');

    if (!provinceId) {
        citySelect.empty().append('<option value="">همه شهرها</option>');
        return;
    }

    // Simple AJAX call with error handling
    $.ajax({
        url: `/fa/admin/locations/cities/${provinceId}`,
        method: 'GET',
        success: function(cities) {
            citySelect.empty().append('<option value="">همه شهرها</option>');
            if (Array.isArray(cities)) {
                cities.forEach(city => {
                    citySelect.append(`<option value="${city.id}">${city.name}</option>`);
                });
            }
        },
        error: function() {
            citySelect.empty().append('<option value="">همه شهرها</option>');
            console.log('خطا در بارگذاری شهرها');
        }
    });
}

// Initialize bulk actions
function initializeBulkActions() {
    // Toggle bulk actions panel
    $('#bulkActions').on('click', function() {
        $('#bulkActionsPanel').slideToggle();
    });

    // Select all checkbox
    $('#selectAll').on('change', function() {
        const isChecked = $(this).is(':checked');
        $('.row-select').prop('checked', isChecked);
        updateSelectedCount();
    });

    // Individual row selection
    $(document).on('change', '.row-select', function() {
        updateSelectedCount();

        // Update select all checkbox
        const totalRows = $('.row-select').length;
        const selectedRows = $('.row-select:checked').length;
        $('#selectAll').prop('checked', selectedRows === totalRows);
    });

    // Bulk action buttons
    $('#bulkActivate').on('click', () => performBulkAction('activate'));
    $('#bulkDeactivate').on('click', () => performBulkAction('deactivate'));
    $('#bulkDelete').on('click', () => performBulkAction('delete'));
    $('#cancelBulk').on('click', cancelBulkActions);
}

function updateSelectedCount() {
    const count = $('.row-select:checked').length;
    $('#selectedCount').text(`${count} مورد انتخاب شده`);

    if (count > 0) {
        $('#bulkActionsPanel').slideDown();
    } else {
        $('#bulkActionsPanel').slideUp();
    }
}

function performBulkAction(action) {
    const selectedIds = $('.row-select:checked').map(function() {
        return $(this).val();
    }).get();

    if (selectedIds.length === 0) {
        showAlert('هیچ موردی انتخاب نشده است', 'warning');
        return;
    }

    const actionText = {
        'activate': 'فعال کردن',
        'deactivate': 'غیرفعال کردن',
        'delete': 'حذف'
    };

    Swal.fire({
        title: `${actionText[action]} ${selectedIds.length} مورد؟`,
        text: 'این عملیات قابل بازگشت نیست',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'بله، ادامه دهید',
        cancelButtonText: 'انصراف'
    }).then((result) => {
        if (result.isConfirmed) {
            executeBulkAction(action, selectedIds);
        }
    });
}

function executeBulkAction(action, ids) {
    const endpoints = {
        'activate': '/fa/admin/locations/bulk-activate',
        'deactivate': '/fa/admin/locations/bulk-deactivate',
        'delete': '/fa/admin/locations/bulk-delete'
    };

    showLoading();

    $.ajax({
        url: endpoints[action],
        method: 'POST',
        data: {
            ids: ids,
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            hideLoading();
            if (response.success) {
                showAlert(response.message, 'success');
                setTimeout(() => window.location.reload(), 1500);
            } else {
                showAlert(response.message, 'error');
            }
        },
        error: function() {
            hideLoading();
            showAlert('خطا در انجام عملیات', 'error');
        }
    });
}

function cancelBulkActions() {
    $('.row-select, #selectAll').prop('checked', false);
    $('#bulkActionsPanel').slideUp();
    updateSelectedCount();
}

// Add location marker function
function addLocationMarker(lat, lng, title, status, id) {
    if (typeof markersGroup === 'undefined') return;

    const iconColor = status === 'active' ? '#1cc88a' : '#e74a3b';

    const customIcon = L.divIcon({
        className: 'custom-marker',
        html: `<div style="background-color: ${iconColor}; width: 24px; height: 24px; border-radius: 50%; border: 3px solid white; box-shadow: 0 2px 8px rgba(0,0,0,0.3);"></div>`,
        iconSize: [24, 24],
        iconAnchor: [12, 12]
    });

    const marker = L.marker([lat, lng], { icon: customIcon });

    marker.bindPopup(`
        <div class="marker-popup">
            <h6>${title}</h6>
            <p>وضعیت: <span class="badge bg-${status === 'active' ? 'success' : 'danger'}">${status === 'active' ? 'فعال' : 'غیرفعال'}</span></p>
            <div class="popup-actions">
                <a href="/fa/admin/locations/${id}" class="btn btn-sm btn-primary">مشاهده</a>
                <a href="/fa/admin/locations/${id}/edit" class="btn btn-sm btn-warning">ویرایش</a>
            </div>
        </div>
    `);

    markersGroup.addLayer(marker);
}




// Initialize statistics interactions
function initializeStatistics() {
    // Refresh stats button
    $('#refreshStats').on('click', refreshStatistics);

    // Export buttons
    $('#exportExcel').on('click', () => exportData('excel'));
    $('#exportPDF').on('click', () => exportData('pdf'));
}

function refreshStatistics() {
    // Use static data for now
    const stats = {!! json_encode($stats) !!};
    updateStatistics(stats);
    showAlert('آمار بروزرسانی شد', 'success');
}

function updateStatistics(stats) {
    $('#totalLocations').text(numberFormat(stats.total));
    $('#activeLocations').text(numberFormat(stats.active));
    $('#inactiveLocations').text(numberFormat(stats.inactive));
    $('#withCoordinates').text(numberFormat(stats.with_coordinates));
    $('#todayLocations').text(numberFormat(stats.today));

    // Animate numbers
    $('.stat-card .number').each(function() {
        $(this).addClass('animate-number');
        setTimeout(() => $(this).removeClass('animate-number'), 500);
    });
}

function exportData(format) {
    const filters = getCurrentFilters();
    const url = format === 'excel'
        ? '/fa/admin/locations/export/excel'
        : '/fa/admin/locations/export/pdf';

    // Create form and submit
    const form = $('<form>', {
        method: 'GET',
        action: url
    });

    Object.keys(filters).forEach(key => {
        if (filters[key]) {
            form.append($('<input>', {
                type: 'hidden',
                name: key,
                value: filters[key]
            }));
        }
    });

    $('body').append(form);
    form.submit();
    form.remove();

    showAlert(`در حال تولید فایل ${format.toUpperCase()}...`, 'info');
}

function getCurrentFilters() {
    return {
        category_id: $('#categoryFilter').val(),
        is_active: $('#statusFilter').val(),
        province_id: $('#provinceFilter').val(),
        city_id: $('#cityFilter').val(),
        search: $('#searchFilter').val(),
        date_from: $('#dateFromFilter').val(),
        date_to: $('#dateToFilter').val(),
        has_coordinates: $('#coordinatesFilter').val(),
        min_rating: $('#ratingFilter').val()
    };
}

// Statistics card click handlers
function filterByStatus(status) {
    if (status === 'all') {
        $('#statusFilter').val('');
    } else {
        $('#statusFilter').val(status === 'active' ? '1' : '0');
    }
    applyFilters();
}

function filterByCoordinates() {
    $('#coordinatesFilter').val('1');
    applyFilters();
}

function filterByDate(period) {
    const today = new Date();
    let fromDate = '';

    if (period === 'today') {
        fromDate = today.toISOString().split('T')[0];
        $('#dateFromFilter').val(fromDate);
        $('#dateToFilter').val(fromDate);
    }

    applyFilters();
}

// Individual action functions
function toggleStatus(id) {
    Swal.fire({
        title: 'تغییر وضعیت مکان؟',
        text: 'وضعیت این مکان تغییر خواهد کرد',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'بله، تغییر دهید',
        cancelButtonText: 'انصراف'
    }).then((result) => {
        if (result.isConfirmed) {
            executeToggleStatus(id);
        }
    });
}

function executeToggleStatus(id) {
    $.ajax({
        url: `/fa/admin/locations/${id}/toggle-status`,
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                showAlert(response.message, 'success');
                setTimeout(() => window.location.reload(), 1000);
            } else {
                showAlert(response.message, 'error');
            }
        },
        error: function() {
            showAlert('خطا در تغییر وضعیت', 'error');
        }
    });
}

function deleteLocation(id) {
    Swal.fire({
        title: 'حذف مکان؟',
        text: 'این عملیات قابل بازگشت نیست',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'بله، حذف کنید',
        cancelButtonText: 'انصراف',
        confirmButtonColor: '#e74a3b'
    }).then((result) => {
        if (result.isConfirmed) {
            executeDeleteLocation(id);
        }
    });
}

function executeDeleteLocation(id) {
    $.ajax({
        url: `/fa/admin/locations/${id}`,
        method: 'DELETE',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                showAlert('مکان با موفقیت حذف شد', 'success');
                setTimeout(() => window.location.reload(), 1000);
            } else {
                showAlert('خطا در حذف مکان', 'error');
            }
        },
        error: function() {
            showAlert('خطا در حذف مکان', 'error');
        }
    });
}

function showOnMap(lat, lng, title) {
    // Switch to map tab
    $('#map-tab').tab('show');

    // Wait for map to be visible then center on location
    setTimeout(() => {
        if (typeof locationsMap !== 'undefined') {
            locationsMap.setView([lat, lng], 15);

            // Find and open popup for this marker
            markersGroup.eachLayer(function(layer) {
                if (layer.getLatLng().lat === lat && layer.getLatLng().lng === lng) {
                    layer.openPopup();
                }
            });
        }
    }, 300);
}

// Utility functions
function showLoading() {
    $('body').addClass('loading');
}

function hideLoading() {
    $('body').removeClass('loading');
}

function showAlert(message, type) {
    const icon = type === 'success' ? 'success' : type === 'error' ? 'error' : 'info';

    Swal.fire({
        title: message,
        icon: icon,
        timer: 3000,
        showConfirmButton: false,
        toast: true,
        position: 'top-end'
    });
}

function numberFormat(num) {
    return new Intl.NumberFormat('fa-IR').format(num);
}

// Load provinces on page load
$(document).ready(function() {
    loadProvinces();
});

function loadProvinces() {
    // Use static data for now to avoid AJAX issues
    const provinces = {!! json_encode(\App\Models\Province::orderBy('name')->select('id', 'name')->get()) !!};

    const select = $('#provinceFilter');
    provinces.forEach(province => {
        select.append(`<option value="${province.id}">${province.name}</option>`);
    });

    // Set selected province if exists in URL
    const urlParams = new URLSearchParams(window.location.search);
    const selectedProvince = urlParams.get('province_id');
    if (selectedProvince) {
        select.val(selectedProvince);
        loadCities(selectedProvince);
    }
}

// Initialize charts when stats tab is shown
$('#stats-tab').on('shown.bs.tab', function() {
    setTimeout(() => {
        initializeCharts();
    }, 100);
});

// Chart initialization
function initializeCharts() {
    // Check if Chart.js is loaded
    if (typeof Chart === 'undefined') {
        console.warn('Chart.js is not loaded yet, retrying in 500ms...');
        setTimeout(initializeCharts, 500);
        return;
    }

    // Status Distribution Chart
    const statusCtx = document.getElementById('statusChart');
    if (statusCtx && !statusCtx.chart) {
        statusCtx.chart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['فعال', 'غیرفعال'],
                datasets: [{
                    data: [
                        {{ $stats['active'] ?? 0 }},
                        {{ $stats['inactive'] ?? 0 }}
                    ],
                    backgroundColor: ['#1cc88a', '#e74a3b'],
                    borderWidth: 3,
                    borderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: { family: 'IRANSans' },
                            padding: 20
                        }
                    }
                }
            }
        });
    }

    // Category Distribution Chart
    const categoryCtx = document.getElementById('categoryChart');
    if (categoryCtx && !categoryCtx.chart) {
        const categoryData = {!! json_encode($categories->take(10)->map(function($cat) {
            return [
                'name' => $cat->getTranslatedName(app()->getLocale()),
                'count' => $cat->locations_count ?? 0,
                'color' => $cat->color ?? '#4e73df'
            ];
        })->values()) !!};

        categoryCtx.chart = new Chart(categoryCtx, {
            type: 'bar',
            data: {
                labels: categoryData.map(cat => cat.name),
                datasets: [{
                    label: 'تعداد مکان‌ها',
                    data: categoryData.map(cat => cat.count),
                    backgroundColor: categoryData.map(cat => cat.color + '80'),
                    borderColor: categoryData.map(cat => cat.color),
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: { family: 'IRANSans' }
                        }
                    },
                    x: {
                        ticks: {
                            font: { family: 'IRANSans' },
                            maxRotation: 45
                        }
                    }
                }
            }
        });
    }

    // Monthly Growth Chart
    const growthCtx = document.getElementById('growthChart');
    if (growthCtx && !growthCtx.chart) {
        // Use real data from database
        const monthlyData = {!! json_encode($chartData['monthly'] ?? []) !!};

        const months = [];
        const data = [];

        // Generate last 12 months
        for (let i = 11; i >= 0; i--) {
            const date = new Date();
            date.setMonth(date.getMonth() - i);
            const year = date.getFullYear();
            const month = date.getMonth() + 1;

            months.push(date.toLocaleDateString('fa-IR', { year: 'numeric', month: 'long' }));

            // Find data for this month
            const monthData = monthlyData.find(item => item.year == year && item.month == month);
            data.push(monthData ? monthData.count : 0);
        }

        growthCtx.chart = new Chart(growthCtx, {
            type: 'line',
            data: {
                labels: months,
                datasets: [{
                    label: 'مکان‌های جدید',
                    data: data,
                    borderColor: '#4e73df',
                    backgroundColor: '#4e73df20',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        labels: {
                            font: { family: 'IRANSans' }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: { family: 'IRANSans' }
                        }
                    },
                    x: {
                        ticks: {
                            font: { family: 'IRANSans' }
                        }
                    }
                }
            }
        });
    }

    // Geographic Distribution Chart
    const geoCtx = document.getElementById('geoChart');
    if (geoCtx && !geoCtx.chart) {
        // Use real province data from database
        const provinceData = {!! json_encode($chartData['provinces'] ?? []) !!};

        geoCtx.chart = new Chart(geoCtx, {
            type: 'polarArea',
            data: {
                labels: provinceData.map(p => p.name),
                datasets: [{
                    data: provinceData.map(p => p.count),
                    backgroundColor: [
                        '#4e73df80',
                        '#1cc88a80',
                        '#36b9cc80',
                        '#f6c23e80',
                        '#e74a3b80'
                    ],
                    borderColor: [
                        '#4e73df',
                        '#1cc88a',
                        '#36b9cc',
                        '#f6c23e',
                        '#e74a3b'
                    ],
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: { family: 'IRANSans' }
                        }
                    }
                }
            }
        });
    }

    // Rating Distribution Chart
    const ratingCtx = document.getElementById('ratingChart');
    if (ratingCtx && !ratingCtx.chart) {
        ratingCtx.chart = new Chart(ratingCtx, {
            type: 'bar',
            data: {
                labels: ['1 ستاره', '2 ستاره', '3 ستاره', '4 ستاره', '5 ستاره'],
                datasets: [{
                    label: 'تعداد مکان‌ها',
                    data: {!! json_encode($chartData['ratings'] ?? [0, 0, 0, 0, 0]) !!},
                    backgroundColor: [
                        '#e74a3b80',
                        '#f6c23e80',
                        '#36b9cc80',
                        '#1cc88a80',
                        '#28a74580'
                    ],
                    borderColor: [
                        '#e74a3b',
                        '#f6c23e',
                        '#36b9cc',
                        '#1cc88a',
                        '#28a745'
                    ],
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: { family: 'IRANSans' }
                        }
                    },
                    x: {
                        ticks: {
                            font: { family: 'IRANSans' }
                        }
                    }
                }
            }
        });
    }
}

// Refresh charts
$('#refreshCharts').on('click', function() {
    $('.chart-body').html('<div class="chart-loading"><i class="fas fa-spinner"></i>در حال بارگذاری...</div>');
    setTimeout(() => {
        location.reload();
    }, 1000);
});

// Export charts
$('#exportCharts').on('click', function() {
    showAlert('قابلیت دانلود نمودار به زودی اضافه خواهد شد', 'info');
});

// Helper functions
function numberFormat(num) {
    return new Intl.NumberFormat('fa-IR').format(num);
}

function showLoading() {
    if (!$('#loadingOverlay').length) {
        $('body').append(`
            <div id="loadingOverlay" style="
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                display: flex;
                justify-content: center;
                align-items: center;
                z-index: 9999;
            ">
                <div style="
                    background: white;
                    padding: 20px;
                    border-radius: 10px;
                    text-align: center;
                ">
                    <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
                    <div style="margin-top: 10px;">در حال پردازش...</div>
                </div>
            </div>
        `);
    }
}

function hideLoading() {
    $('#loadingOverlay').remove();
}

function showAlert(message, type = 'info') {
    const icon = {
        'success': 'success',
        'error': 'error',
        'warning': 'warning',
        'info': 'info'
    };

    Swal.fire({
        title: message,
        icon: icon[type] || 'info',
        timer: 3000,
        showConfirmButton: false,
        toast: true,
        position: 'top-end'
    });
}
</script>
@endsection