@extends('admin.layouts.app')

@section('title', 'مدیریت منوها')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت منوهای سایت</h1>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.menu-management.create', ['lang' => $languageCode]) }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> افزودن منو جدید
            </a>
        </div>
    </div>

    <!-- Language Selector -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <label for="language-select" class="form-label">انتخاب زبان:</label>
                    <select id="language-select" class="form-select" onchange="changeLanguage(this.value)">
                        @foreach($languages as $language)
                            <option value="{{ $language->code }}" {{ $languageCode == $language->code ? 'selected' : '' }}>
                                {{ $language->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 text-end">
                    <button type="button" class="btn btn-info btn-sm" onclick="toggleSortMode()">
                        <i class="fas fa-sort"></i> حالت مرتب‌سازی
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Menus Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">لیست منوها</h6>
        </div>
        <div class="card-body">
            @if($menus->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" id="menusTable">
                        <thead>
                            <tr>
                                <th width="50">ترتیب</th>
                                <th>عنوان</th>
                                <th>آدرس</th>
                                <th>آیکون</th>
                                <th>منوی والد</th>
                                <th>وضعیت</th>
                                <th>نمایش برای</th>
                                <th width="150">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="sortable-menus">
                            @foreach($menus as $menu)
                                <tr data-id="{{ $menu->id }}" data-order="{{ $menu->sort_order }}">
                                    <td class="text-center">
                                        <span class="sort-handle" style="cursor: move;">
                                            <i class="fas fa-grip-vertical"></i>
                                        </span>
                                        <span class="order-number">{{ $menu->sort_order }}</span>
                                    </td>
                                    <td>
                                        @if($menu->icon)
                                            <i class="{{ $menu->icon }}"></i>
                                        @endif
                                        {{ $menu->title }}
                                        @if($menu->children->count() > 0)
                                            <span class="badge badge-info">{{ $menu->children->count() }} زیرمنو</span>
                                        @endif
                                    </td>
                                    <td>
                                        <code>{{ $menu->url }}</code>
                                        @if($menu->target == '_blank')
                                            <i class="fas fa-external-link-alt text-info" title="باز شدن در تب جدید"></i>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if($menu->icon)
                                            <i class="{{ $menu->icon }} fa-lg"></i>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($menu->parent)
                                            <span class="badge badge-secondary">{{ $menu->parent->title }}</span>
                                        @else
                                            <span class="text-muted">منوی اصلی</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <button type="button" 
                                                class="btn btn-sm {{ $menu->is_active ? 'btn-success' : 'btn-secondary' }}"
                                                onclick="toggleStatus({{ $menu->id }})">
                                            <i class="fas {{ $menu->is_active ? 'fa-check' : 'fa-times' }}"></i>
                                            {{ $menu->is_active ? 'فعال' : 'غیرفعال' }}
                                        </button>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex flex-column gap-1">
                                            @if($menu->show_for_guests)
                                                <span class="badge badge-primary">مهمان‌ها</span>
                                            @endif
                                            @if($menu->show_for_users)
                                                <span class="badge badge-success">کاربران</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.menu-management.edit', $menu) }}" 
                                               class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" 
                                                    class="btn btn-sm btn-danger"
                                                    onclick="deleteMenu({{ $menu->id }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                @if($menu->children->count() > 0)
                                    @foreach($menu->children as $child)
                                        <tr data-id="{{ $child->id }}" data-order="{{ $child->sort_order }}" class="child-menu">
                                            <td class="text-center">
                                                <span class="sort-handle" style="cursor: move;">
                                                    <i class="fas fa-grip-vertical"></i>
                                                </span>
                                                <span class="order-number">{{ $child->sort_order }}</span>
                                            </td>
                                            <td style="padding-right: 30px;">
                                                <i class="fas fa-level-up-alt fa-rotate-90 text-muted"></i>
                                                @if($child->icon)
                                                    <i class="{{ $child->icon }}"></i>
                                                @endif
                                                {{ $child->title }}
                                            </td>
                                            <td>
                                                <code>{{ $child->url }}</code>
                                                @if($child->target == '_blank')
                                                    <i class="fas fa-external-link-alt text-info" title="باز شدن در تب جدید"></i>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @if($child->icon)
                                                    <i class="{{ $child->icon }} fa-lg"></i>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="badge badge-secondary">{{ $menu->title }}</span>
                                            </td>
                                            <td class="text-center">
                                                <button type="button" 
                                                        class="btn btn-sm {{ $child->is_active ? 'btn-success' : 'btn-secondary' }}"
                                                        onclick="toggleStatus({{ $child->id }})">
                                                    <i class="fas {{ $child->is_active ? 'fa-check' : 'fa-times' }}"></i>
                                                    {{ $child->is_active ? 'فعال' : 'غیرفعال' }}
                                                </button>
                                            </td>
                                            <td class="text-center">
                                                <div class="d-flex flex-column gap-1">
                                                    @if($child->show_for_guests)
                                                        <span class="badge badge-primary">مهمان‌ها</span>
                                                    @endif
                                                    @if($child->show_for_users)
                                                        <span class="badge badge-success">کاربران</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('admin.menu-management.edit', $child) }}" 
                                                       class="btn btn-sm btn-warning">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-danger"
                                                            onclick="deleteMenu({{ $child->id }})">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $menus->appends(['lang' => $languageCode])->links() }}
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-list fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">هیچ منویی یافت نشد</h5>
                    <p class="text-muted">برای شروع، اولین منو را ایجاد کنید.</p>
                    <a href="{{ route('admin.menu-management.create', ['lang' => $languageCode]) }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> ایجاد منو جدید
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأیید حذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                آیا از حذف این منو اطمینان دارید؟ این عمل قابل بازگشت نیست.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">حذف</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/ui-lightness/jquery-ui.css">
<style>
.child-menu {
    background-color: #f8f9fa;
}
.sort-handle {
    color: #6c757d;
}
.sortable-placeholder {
    background-color: #e9ecef;
    height: 50px;
}
#sortable-menus tr.ui-sortable-helper {
    background-color: #fff;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}
</style>
@endpush

@push('scripts')
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
<script>
let sortMode = false;

function changeLanguage(langCode) {
    window.location.href = '{{ route("admin.menu-management.index") }}?lang=' + langCode;
}

function toggleSortMode() {
    sortMode = !sortMode;
    if (sortMode) {
        enableSorting();
    } else {
        disableSorting();
    }
}

function enableSorting() {
    $("#sortable-menus").sortable({
        handle: '.sort-handle',
        placeholder: 'sortable-placeholder',
        update: function(event, ui) {
            updateMenuOrder();
        }
    });
    $('.sort-handle').show();
    alert('حالت مرتب‌سازی فعال شد. منوها را با کشیدن مرتب کنید.');
}

function disableSorting() {
    $("#sortable-menus").sortable('destroy');
    $('.sort-handle').hide();
}

function updateMenuOrder() {
    let menuOrder = [];
    $('#sortable-menus tr').each(function(index) {
        let menuId = $(this).data('id');
        if (menuId) {
            menuOrder.push({
                id: menuId,
                sort_order: index + 1
            });
        }
    });

    $.ajax({
        url: '{{ route("admin.menu-management.update-order") }}',
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            menus: menuOrder,
            language_code: '{{ $languageCode }}'
        },
        success: function(response) {
            if (response.success) {
                // Update order numbers in table
                $('#sortable-menus tr').each(function(index) {
                    $(this).find('.order-number').text(index + 1);
                });
                
                showAlert('success', response.message);
            }
        },
        error: function() {
            showAlert('error', 'خطا در به‌روزرسانی ترتیب منوها');
        }
    });
}

function toggleStatus(menuId) {
    $.ajax({
        url: `/admin/menu-management/${menuId}/toggle-status`,
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                location.reload();
            }
        },
        error: function() {
            showAlert('error', 'خطا در تغییر وضعیت منو');
        }
    });
}

let deleteMenuId = null;

function deleteMenu(menuId) {
    deleteMenuId = menuId;
    $('#deleteModal').modal('show');
}

$('#confirmDelete').click(function() {
    if (deleteMenuId) {
        $.ajax({
            url: `/admin/menu-management/${deleteMenuId}`,
            method: 'DELETE',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                $('#deleteModal').modal('hide');
                location.reload();
            },
            error: function() {
                showAlert('error', 'خطا در حذف منو');
            }
        });
    }
});

function showAlert(type, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    $('.container-fluid').prepend(alertHtml);
}

$(document).ready(function() {
    $('.sort-handle').hide();
});
</script>
@endpush
