@extends('admin.layouts.app')

@section('title', 'تنظیمات اعلان‌ها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات اعلان‌ها</h3>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <form action="{{ route('admin.notifications.settings.update') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نحوه دریافت اعلان‌ها</label>
                                    <div class="custom-control custom-switch mb-2">
                                        <input type="checkbox" class="custom-control-input" id="email_notifications" 
                                            name="email_notifications" value="1" 
                                            {{ old('email_notifications', $settings->email_notifications ?? false) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="email_notifications">اعلان‌های ایمیلی</label>
                                    </div>
                                    
                                    <div class="custom-control custom-switch mb-2">
                                        <input type="checkbox" class="custom-control-input" id="sms_notifications" 
                                            name="sms_notifications" value="1" 
                                            {{ old('sms_notifications', $settings->sms_notifications ?? false) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="sms_notifications">اعلان‌های پیامکی</label>
                                    </div>
                                    
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="push_notifications" 
                                            name="push_notifications" value="1" 
                                            {{ old('push_notifications', $settings->push_notifications ?? false) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="push_notifications">اعلان‌های مرورگر</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>انواع اعلان‌ها</label>
                                    <div class="custom-control custom-checkbox mb-2">
                                        <input type="checkbox" class="custom-control-input" id="notification_type_new_user" 
                                            name="notification_types[]" value="new_user" 
                                            {{ in_array('new_user', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notification_type_new_user">ثبت نام کاربر جدید</label>
                                    </div>
                                    
                                    <div class="custom-control custom-checkbox mb-2">
                                        <input type="checkbox" class="custom-control-input" id="notification_type_new_location" 
                                            name="notification_types[]" value="new_location" 
                                            {{ in_array('new_location', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notification_type_new_location">ثبت مکان جدید</label>
                                    </div>
                                    
                                    <div class="custom-control custom-checkbox mb-2">
                                        <input type="checkbox" class="custom-control-input" id="notification_type_new_comment" 
                                            name="notification_types[]" value="new_comment" 
                                            {{ in_array('new_comment', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notification_type_new_comment">نظر جدید</label>
                                    </div>
                                    
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="notification_type_new_rating" 
                                            name="notification_types[]" value="new_rating" 
                                            {{ in_array('new_rating', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notification_type_new_rating">امتیاز جدید</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // تغییر وضعیت تنظیمات با AJAX
    $('.custom-control-input').change(function() {
        if ($(this).attr('name') === 'notification_types[]') return;
        
        $.ajax({
            url: '{{ route("admin.notifications.settings.toggle") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                setting: $(this).attr('name'),
                value: $(this).prop('checked')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                }
            },
            error: function() {
                toastr.error('خطا در بروزرسانی تنظیمات');
            }
        });
    });
});
</script>
@endpush
@endsection 