@extends('layouts.admin')

@section('title', 'مدیریت پکیج‌های تبلیغاتی')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت پکیج‌های تبلیغاتی</h1>
        <a href="{{ route('admin.packages.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> ایجاد پکیج جدید
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">لیست پکیج‌های تبلیغاتی</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>نام پکیج</th>
                            <th>کلید</th>
                            <th>قیمت (ریال)</th>
                            <th>مدت (روز)</th>
                            <th>متن نشان</th>
                            <th>طراحی کارت</th>
                            <th>اولویت</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($packages as $package)
                            <tr>
                                <td>{{ $package->name }}</td>
                                <td>{{ $package->package_key }}</td>
                                <td>{{ number_format($package->price) }}</td>
                                <td>{{ $package->duration_days }}</td>
                                <td>
                                    @if($package->badge_text)
                                        <span class="badge" style="background-color: {{ $package->badge_color }}; color: white;">
                                            {{ $package->badge_text }}
                                        </span>
                                    @endif
                                </td>
                                <td>{{ $package->card_design }}</td>
                                <td>{{ $package->priority }}</td>
                                <td>
                                    @if($package->is_active)
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.packages.edit', $package->id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i> ویرایش
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection 