@extends('admin.layouts.app')

@section('title', __('مشاهده نظر') . ' #' . $review->id)

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('مشاهده جزئیات نظر') }} #{{ $review->id }}</h1>
        <a href="{{ route('admin.reviews.index') }}" class="btn btn-sm btn-secondary">
            <i class="fas fa-arrow-left fa-sm"></i> {{ __('بازگشت به لیست') }}
        </a>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('اطلاعات نظر') }}</h6>
                    <div>
                        @if($review->is_approved)
                            <span class="badge bg-success">{{ __('تایید شده') }}</span>
                        @else
                            <span class="badge bg-warning">{{ __('در انتظار تایید') }}</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th style="width: 150px;">{{ __('مکان') }}</th>
                                    <td>
                                        <a href="{{ route('locations.show', $review->location_id) }}" target="_blank">
                                            {{ $review->location->title ?? __('نامشخص') }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>{{ __('نام') }}</th>
                                    <td>{{ $review->name }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('ایمیل') }}</th>
                                    <td>{{ $review->email ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('نوع سفر') }}</th>
                                    <td>{{ $review->trip_type ? __($review->trip_type) : '-' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th style="width: 150px;">{{ __('تاریخ ثبت') }}</th>
                                    <td>{{ $review->created_at->format('Y/m/d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('آخرین به‌روزرسانی') }}</th>
                                    <td>{{ $review->updated_at->format('Y/m/d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('شناسه کاربر') }}</th>
                                    <td>{{ $review->user_id ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('امتیاز کلی') }}</th>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">{{ $review->rating }}/5</span>
                                            <div>
                                                @for ($i = 1; $i <= 5; $i++)
                                                    @if ($i <= $review->rating)
                                                        <i class="fas fa-star text-warning"></i>
                                                    @else
                                                        <i class="far fa-star text-warning"></i>
                                                    @endif
                                                @endfor
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="font-weight-bold">{{ __('امتیازات جزئی') }}</h6>
                            <div class="d-flex flex-wrap">
                                @if($review->service_rating)
                                    <div class="me-4 mb-2">
                                        <label class="form-label d-block">{{ __('خدمات') }}: {{ $review->service_rating }}/5</label>
                                        <div class="progress" style="height: 8px; width: 120px;">
                                            <div class="progress-bar bg-info" role="progressbar" style="width: {{ ($review->service_rating/5)*100 }}%" aria-valuenow="{{ $review->service_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                        </div>
                                    </div>
                                @endif
                                
                                @if($review->cleanliness_rating)
                                    <div class="me-4 mb-2">
                                        <label class="form-label d-block">{{ __('نظافت') }}: {{ $review->cleanliness_rating }}/5</label>
                                        <div class="progress" style="height: 8px; width: 120px;">
                                            <div class="progress-bar bg-info" role="progressbar" style="width: {{ ($review->cleanliness_rating/5)*100 }}%" aria-valuenow="{{ $review->cleanliness_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                        </div>
                                    </div>
                                @endif
                                
                                @if($review->location_rating)
                                    <div class="me-4 mb-2">
                                        <label class="form-label d-block">{{ __('موقعیت') }}: {{ $review->location_rating }}/5</label>
                                        <div class="progress" style="height: 8px; width: 120px;">
                                            <div class="progress-bar bg-info" role="progressbar" style="width: {{ ($review->location_rating/5)*100 }}%" aria-valuenow="{{ $review->location_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                        </div>
                                    </div>
                                @endif
                                
                                @if($review->value_rating)
                                    <div class="me-4 mb-2">
                                        <label class="form-label d-block">{{ __('ارزش') }}: {{ $review->value_rating }}/5</label>
                                        <div class="progress" style="height: 8px; width: 120px;">
                                            <div class="progress-bar bg-info" role="progressbar" style="width: {{ ($review->value_rating/5)*100 }}%" aria-valuenow="{{ $review->value_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                        </div>
                                    </div>
                                @endif
                                
                                @if(!$review->service_rating && !$review->cleanliness_rating && !$review->location_rating && !$review->value_rating)
                                    <p class="text-muted">{{ __('امتیاز جزئی ثبت نشده است.') }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-2">
                        <div class="col-12">
                            <h6 class="font-weight-bold">{{ __('نظرات') }}</h6>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <i class="fas fa-plus-circle text-success me-1"></i> {{ __('نکات مثبت') }}
                                </div>
                                <div class="card-body">
                                    {{ $review->positive_comment ?? __('چیزی ثبت نشده است.') }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <i class="fas fa-minus-circle text-danger me-1"></i> {{ __('نکات منفی') }}
                                </div>
                                <div class="card-body">
                                    {{ $review->negative_comment ?? __('چیزی ثبت نشده است.') }}
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($review->comment)
                        <div class="row mt-2">
                            <div class="col-12">
                                <div class="card bg-light">
                                    <div class="card-header">
                                        <i class="fas fa-comment me-1"></i> {{ __('نظر کلی') }}
                                    </div>
                                    <div class="card-body">
                                        {{ $review->comment }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('مدیریت نظر') }}</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2 mb-4">
                        @if(!$review->is_approved)
                            <form action="{{ route('admin.reviews.approve', $review->id) }}" method="post">
                                @csrf
                                <button type="submit" class="btn btn-success btn-block" onclick="return confirm('{{ __('آیا از تایید این نظر مطمئن هستید؟') }}')">
                                    <i class="fas fa-check me-1"></i> {{ __('تایید نظر') }}
                                </button>
                            </form>
                        @else
                            <form action="{{ route('admin.reviews.reject', $review->id) }}" method="post">
                                @csrf
                                <button type="submit" class="btn btn-warning btn-block" onclick="return confirm('{{ __('آیا از رد این نظر مطمئن هستید؟') }}')">
                                    <i class="fas fa-times me-1"></i> {{ __('رد نظر') }}
                                </button>
                            </form>
                        @endif
                        
                        <form action="{{ route('admin.reviews.destroy', $review->id) }}" method="post">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-block mt-2" onclick="return confirm('{{ __('آیا از حذف این نظر مطمئن هستید؟ این عمل قابل بازگشت نیست.') }}')">
                                <i class="fas fa-trash me-1"></i> {{ __('حذف نظر') }}
                            </button>
                        </form>
                    </div>
                    
                    <hr>
                    
                    <form action="{{ route('admin.reviews.updateNote', $review->id) }}" method="post">
                        @csrf
                        <div class="mb-3">
                            <label for="admin_note" class="form-label">{{ __('یادداشت مدیر (داخلی)') }}</label>
                            <textarea class="form-control" id="admin_note" name="admin_note" rows="4">{{ $review->admin_note }}</textarea>
                            <div class="form-text">{{ __('این یادداشت فقط برای مدیران قابل مشاهده است.') }}</div>
                        </div>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fas fa-save me-1"></i> {{ __('ذخیره یادداشت') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mt-4" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
</div>
@endsection 