@extends('admin.layouts.app')

@section('title', 'آمار و گزارشات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ $totalUsers }}</h3>
                    <p>کاربران</p>
                </div>
                <div class="icon">
                    <i class="fa fa-users"></i>
                </div>
                <a href="{{ route('admin.statistics.users') }}" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ $totalLocations }}</h3>
                    <p>مکان‌ها</p>
                </div>
                <div class="icon">
                    <i class="fa fa-map-marker"></i>
                </div>
                <a href="{{ route('admin.statistics.locations') }}" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $totalVisits }}</h3>
                    <p>بازدیدها</p>
                </div>
                <div class="icon">
                    <i class="fa fa-eye"></i>
                </div>
                <a href="{{ route('admin.statistics.visits') }}" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آخرین بازدیدها</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>کاربر</th>
                                    <th>مکان</th>
                                    <th>تاریخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentVisits as $visit)
                                <tr>
                                    <td>{{ $visit->user->name }}</td>
                                    <td>{{ $visit->location->name }}</td>
                                    <td>@dateTimeByLocale($visit->created_at)</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center">هیچ بازدیدی ثبت نشده است.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // نمودارها و گراف‌های آماری می‌توانند اینجا اضافه شوند
</script>
@endpush 