@extends('admin.layouts.app')

@section('title', 'آمار مکان‌ها')

@section('content')
<div class="container-fluid">
    <!-- آمار کلی -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آمار کلی مکان‌ها</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-map-marker-alt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">کل مکان‌ها</span>
                                    <span class="info-box-number">{{ $locationStats['total'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مکان‌های فعال</span>
                                    <span class="info-box-number">{{ $locationStats['active'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-map"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مکان‌های با مختصات</span>
                                    <span class="info-box-number">{{ $locationStats['with_coordinates'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-times-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مکان‌های غیرفعال</span>
                                    <span class="info-box-number">{{ $locationStats['inactive'] }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- مکان‌های پربازدید -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مکان‌های پربازدید</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>مکان</th>
                                    <th>تعداد بازدید</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($popularLocations as $location)
                                <tr>
                                    <td>{{ $location->title }}</td>
                                    <td>{{ $location->visits_count }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="2" class="text-center">هیچ مکان پربازدیدی یافت نشد.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- توزیع مکان‌ها بر اساس دسته‌بندی -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">توزیع مکان‌ها بر اساس دسته‌بندی</h3>
                </div>
                <div class="card-body">
                    <canvas id="categoriesChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- نمودار مکان‌های جدید در 30 روز گذشته -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مکان‌های جدید در 30 روز گذشته</h3>
                </div>
                <div class="card-body">
                    <canvas id="recentLocationsChart"></canvas>
                </div>
            </div>
        </div>

        <!-- توزیع مکان‌ها بر اساس استان -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">توزیع مکان‌ها بر اساس استان</h3>
                </div>
                <div class="card-body">
                    <canvas id="provincesChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- توزیع مکان‌ها بر اساس امتیاز -->
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">توزیع مکان‌ها بر اساس امتیاز</h3>
                </div>
                <div class="card-body">
                    <canvas id="ratingsChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // نمودار دسته‌بندی‌ها
    const categoriesCtx = document.getElementById('categoriesChart').getContext('2d');
    const categoriesData = @json($locationsByCategory);
    new Chart(categoriesCtx, {
        type: 'pie',
        data: {
            labels: categoriesData.map(item => item.name),
            datasets: [{
                data: categoriesData.map(item => item.count),
                backgroundColor: [
                    'rgb(255, 99, 132)',
                    'rgb(54, 162, 235)',
                    'rgb(255, 205, 86)',
                    'rgb(75, 192, 192)',
                    'rgb(153, 102, 255)',
                    'rgb(255, 159, 64)'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: true,
                    text: 'توزیع مکان‌ها بر اساس دسته‌بندی'
                }
            }
        }
    });

    // نمودار مکان‌های جدید
    const recentCtx = document.getElementById('recentLocationsChart').getContext('2d');
    const recentData = @json($recentLocations);
    new Chart(recentCtx, {
        type: 'line',
        data: {
            labels: recentData.map(item => item.date),
            datasets: [{
                label: 'تعداد مکان‌های جدید',
                data: recentData.map(item => item.count),
                borderColor: 'rgb(75, 192, 192)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: true,
                    text: 'مکان‌های جدید در 30 روز گذشته'
                }
            }
        }
    });

    // نمودار استان‌ها
    const provincesCtx = document.getElementById('provincesChart').getContext('2d');
    const provincesData = @json($locationsByProvince);
    new Chart(provincesCtx, {
        type: 'bar',
        data: {
            labels: provincesData.map(item => item.province ? item.province.name : 'بدون استان'),
            datasets: [{
                label: 'تعداد مکان‌ها',
                data: provincesData.map(item => item.count),
                backgroundColor: 'rgb(54, 162, 235)'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: true,
                    text: 'توزیع مکان‌ها بر اساس استان'
                }
            }
        }
    });

    // نمودار امتیازات
    const ratingsCtx = document.getElementById('ratingsChart').getContext('2d');
    const ratingsData = @json($locationsByRating);
    new Chart(ratingsCtx, {
        type: 'bar',
        data: {
            labels: ratingsData.map(item => item.avg_rating + ' ستاره'),
            datasets: [{
                label: 'تعداد مکان‌ها',
                data: ratingsData.map(item => item.count),
                backgroundColor: 'rgb(255, 205, 86)'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: true,
                    text: 'توزیع مکان‌ها بر اساس امتیاز'
                }
            }
        }
    });
</script>
@endpush