@extends('admin.layouts.app')

@section('title', 'آمار کاربران')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آمار کاربران</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">کاربران فعال</h3>
                                </div>
                                <div class="card-body">
                                    <div class="small-box bg-success">
                                        <div class="inner">
                                            <h3>{{ $activeUsers }}</h3>
                                            <p>کاربران فعال در 30 روز گذشته</p>
                                        </div>
                                        <div class="icon">
                                            <i class="fa fa-users"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">نمودار ثبت‌نام کاربران</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="usersChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('js/locale-date-manager.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('usersChart').getContext('2d');
    const usersData = @json($usersByMonth);
    const locale = document.documentElement.lang || 'fa';

    // فرمت کردن نام ماه‌ها بر اساس زبان
    const formatMonthLabels = (data) => {
        return data.map(item => {
            if (window.localeDateManager) {
                return window.localeDateManager.formatMonthForChart(item.month);
            } else {
                // Fallback
                if (locale === 'fa') {
                    const months = ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
                    return months[item.month - 1];
                } else {
                    const date = new Date(2000, item.month - 1, 1);
                    return date.toLocaleDateString(locale, { month: 'long' });
                }
            }
        });
    };

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: formatMonthLabels(usersData),
            datasets: [{
                label: locale === 'fa' ? 'تعداد کاربران جدید' : 'New Users',
                data: usersData.map(item => item.count),
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                tension: 0.1,
                fill: true,
                pointBackgroundColor: 'rgb(75, 192, 192)',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 5
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: locale === 'fa'
                },
                title: {
                    display: true,
                    text: locale === 'fa' ? 'نمودار ثبت‌نام کاربران در سال جاری' : 'User Registrations - Current Year'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const value = context.parsed.y;
                            const formattedValue = window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                            return `${context.dataset.label}: ${formattedValue}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush