@props(['location'])

<div class="location-card card mb-4">
    <div class="row g-0">
        <div class="col-md-4">
            @if (!empty($location->images))
                @php
                    $images = is_array($location->images) ? $location->images : (json_decode($location->images, true) ?? []);
                    $firstImage = !empty($images) ? $images[0] : null;
                @endphp

                @if (!empty($firstImage))
                    <img src="{{ asset('storage/' . $firstImage) }}" class="img-fluid rounded-start h-100" style="object-fit: cover;" alt="{{ $location->title }}">
                @endif
            @endif
        </div>

        <div class="col-md-8">
            <div class="card-body">
                <h5 class="card-title">
                    <a href="{{ route('locations.show', $location->id) }}" class="text-decoration-none">
                        {{ $location->title }}
                    </a>
                </h5>

                @if (!empty($location->category_fa))
                    <div class="mb-2 text-muted">
                        <i class="fas fa-tag me-1"></i> {{ $location->category_fa }}
                    </div>
                @endif

                @if (!empty($location->Slogan))
                    <p class="card-text text-secondary">{{ $location->Slogan }}</p>
                @endif

                <div class="location-details">
                    @if (!empty($location->address))
                        <div class="mb-2">
                            <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                            {{ $location->getStructuredAddress(app()->getLocale()) }}
                        </div>
                    @endif

                    @if (!empty($location->phone))
                        <div class="mb-2">
                            <i class="fas fa-phone me-2 text-primary"></i>
                            <a href="tel:{{ $location->phone }}" class="text-decoration-none">
                                {{ $location->phone }}
                            </a>
                        </div>
                    @endif

                    @if (!empty($location->url))
                        <div class="mb-2">
                            <i class="fas fa-globe me-2 text-primary"></i>
                            <a href="{{ $location->url }}" target="_blank" class="text-decoration-none">
                                {{ $location->url }}
                            </a>
                        </div>
                    @endif

                    @if (!empty($location->open_hours) || !empty($location->closing_hours))
                        <div>
                            <i class="far fa-clock me-2 text-primary"></i>
                            {{ __('ساعت کار') }}:
                            @if (!empty($location->open_hours) && !empty($location->closing_hours))
                                {{ $location->open_hours }} {{ __('الی') }} {{ $location->closing_hours }}
                            @elseif (!empty($location->open_hours))
                                {{ __('از') }} {{ $location->open_hours }}
                            @elseif (!empty($location->closing_hours))
                                {{ __('تا') }} {{ $location->closing_hours }}
                            @endif
                        </div>
                    @endif
                </div>

                @if ($location->categoryRelation &&
                     $location->categoryRelation->activeTemplateRelation &&
                     is_object($location->categoryRelation->activeTemplateRelation) &&
                     method_exists($location->categoryRelation->activeTemplateRelation, 'isFeatureEnabled') &&
                     $location->categoryRelation->activeTemplateRelation->isFeatureEnabled('ratings'))
                    <div class="mt-3">
                        <x-ratings-widget :locationId="$location->id" size="small" />
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>