@extends('layouts.user')

@section('title', $location->title)

@section('styles')
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<style>
    #mapid {
        height: 300px;
        border-radius: 10px;
    }
    .location-image {
        border-radius: 10px;
        height: 150px;
        width: 100%;
        object-fit: cover;
    }
    .location-image-container {
        position: relative;
        margin-bottom: 15px;
    }
    .image-gallery {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        margin-bottom: 20px;
    }
    .info-section {
        margin-bottom: 30px;
    }
    .section-title {
        border-bottom: 1px solid #e0e0e0;
        padding-bottom: 10px;
        margin-bottom: 20px;
        font-weight: 600;
    }
    .status-badge {
        font-size: 0.8rem;
        padding: 5px 10px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12 mb-4">
            <div class="card">
                <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                    <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                        <div class="d-flex justify-content-between align-items-center px-3">
                            <h6 class="text-white text-capitalize pe-3">مشاهده مکان</h6>
                            <div>
                                <a href="{{ route('user.locations.index') }}" class="btn btn-sm btn-light me-2">
                                    <i class="material-icons text-sm">arrow_back</i>
                                    بازگشت به لیست
                                </a>
                                <a href="{{ route('user.locations.edit', $location->id) }}" class="btn btn-sm btn-warning">
                                    <i class="material-icons text-sm">edit</i>
                                    ویرایش
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body p-4">
                    @if(session('success'))
                        <div class="alert alert-success text-white">
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Status Badge -->
                    <div class="mb-4 text-end">
                        @if($location->status == 'approved')
                            <span class="badge bg-gradient-success status-badge">تایید شده</span>
                        @elseif($location->status == 'pending')
                            <span class="badge bg-gradient-warning status-badge">در انتظار تایید</span>
                            <p class="text-sm text-muted mt-2">مکان شما در انتظار بررسی توسط مدیران سایت است.</p>
                        @elseif($location->status == 'rejected')
                            <span class="badge bg-gradient-danger status-badge">رد شده</span>
                            @if($location->rejection_reason)
                                <p class="text-sm text-danger mt-2">دلیل رد: {{ $location->rejection_reason }}</p>
                            @endif
                        @endif
                    </div>

                    <!-- Main Info Section -->
                    <div class="info-section">
                        <h5 class="section-title">اطلاعات اصلی</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>عنوان:</strong> {{ $location->title }}</p>
                                <p><strong>دسته‌بندی:</strong> {{ $location->categoryRelation ? $location->categoryRelation->getTranslatedName() : 'نامشخص' }}</p>
                                <p><strong>تاریخ ثبت:</strong> @dateTimeByLocale($location->created_at)</p>
                                <p><strong>تعداد بازدید:</strong> {{ $location->views_count }}</p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>تلفن:</strong> {{ $location->phone ?? 'ثبت نشده' }}</p>
                                <p><strong>وب‌سایت:</strong> {{ $location->website ?? 'ثبت نشده' }}</p>
                                <p><strong>ساعات کاری:</strong> {{ $location->working_hours ?? 'ثبت نشده' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Description Section -->
                    <div class="info-section">
                        <h5 class="section-title">توضیحات</h5>
                        <div class="row">
                            <div class="col-md-12">
                                <p>{{ $location->description ?? 'بدون توضیحات' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Location Section -->
                    <div class="info-section">
                        <h5 class="section-title">موقعیت</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>استان:</strong> {{ $location->province ? $location->province->getTranslatedName() : 'نامشخص' }}</p>
                                <p><strong>شهرستان:</strong> {{ $location->county ? $location->county->getTranslatedName() : 'نامشخص' }}</p>
                                <p><strong>شهر:</strong> {{ $location->city ? $location->city->getTranslatedName() : 'نامشخص' }}</p>
                                <p><strong>آدرس:</strong> {{ $location->getStructuredAddress(app()->getLocale()) ?? 'ثبت نشده' }}</p>
                                <p>
                                    <strong>مختصات:</strong>
                                    @if($location->latitude && $location->longitude)
                                        {{ $location->latitude }}, {{ $location->longitude }}
                                    @else
                                        ثبت نشده
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-6">
                                @if($location->latitude && $location->longitude)
                                    <div id="mapid"></div>
                                @else
                                    <div class="alert alert-info">
                                        موقعیت جغرافیایی برای این مکان ثبت نشده است.
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Images Section -->
                    <div class="info-section">
                        <h5 class="section-title">تصاویر</h5>
                        @php
                            $images = $location->images_array;
                        @endphp
                        @if(count($images) > 0)
                            <div class="image-gallery">
                                @foreach($images as $image)
                                    @if(!empty($image) && is_string($image))
                                    <div class="location-image-container">
                                        <img src="{{ asset('storage/' . $image) }}" alt="{{ $location->title }}" class="location-image">
                                    </div>
                                    @endif
                                @endforeach
                            </div>
                        @else
                            <div class="alert alert-info">
                                تصویری برای این مکان ثبت نشده است.
                            </div>
                        @endif
                    </div>

                    <!-- Additional Info Section -->
                    <div class="info-section">
                        <h5 class="section-title">اطلاعات تکمیلی</h5>
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>امکانات:</strong>
                                    @if($location->facilities && !empty(json_decode($location->facilities)))
                                        @foreach(json_decode($location->facilities) as $facility)
                                            <span class="badge bg-info me-1">{{ $facility }}</span>
                                        @endforeach
                                    @else
                                        امکاناتی ثبت نشده است.
                                    @endif
                                </p>
                                <p><strong>قوانین:</strong> {{ $location->rules ?? 'ثبت نشده' }}</p>
                                <p><strong>هزینه ورودی:</strong> {{ $location->entrance_fee ?? 'ثبت نشده' }}</p>
                                <p><strong>بهترین زمان بازدید:</strong> {{ $location->best_time_to_visit ?? 'ثبت نشده' }}</p>
                                <p><strong>زمان مورد نیاز برای بازدید:</strong> {{ $location->visit_duration ?? 'ثبت نشده' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Related Features -->
                    @if($location->features && count($location->features) > 0)
                        <div class="info-section">
                            <h5 class="section-title">ویژگی‌ها</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    @foreach($location->features as $feature)
                                        <span class="badge bg-primary me-1 mb-1">{{ $feature->title_fa }}</span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Related Tags -->
                    @if($location->tags && count($location->tags) > 0)
                        <div class="info-section">
                            <h5 class="section-title">برچسب‌ها</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    @foreach($location->tags as $tag)
                                        <span class="badge bg-dark me-1 mb-1">{{ $tag->title_fa }}</span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
<script>
    @if($location->latitude && $location->longitude)
        document.addEventListener('DOMContentLoaded', function() {
            var mymap = L.map('mapid').setView([{{ $location->latitude }}, {{ $location->longitude }}], 13);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(mymap);

            var marker = L.marker([{{ $location->latitude }}, {{ $location->longitude }}]).addTo(mymap)
                .bindPopup("{{ $location->title }}").openPopup();
        });
    @endif
</script>
@endsection