

<?php $__env->startSection('title', 'مدیریت دسته‌بندی‌ها'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت دسته‌بندی‌ها</h1>
        <a href="<?php echo e(route('admin.categories.create')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50 ml-1"></i> افزودن دسته‌بندی جدید
        </a>
    </div>

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">لیست دسته‌بندی‌ها</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                    <a class="dropdown-item" href="#" id="export-csv">
                        <i class="fas fa-file-csv fa-sm fa-fw ml-1"></i> خروجی CSV
                    </a>
                    <a class="dropdown-item" href="#" id="export-excel">
                        <i class="fas fa-file-excel fa-sm fa-fw ml-1"></i> خروجی اکسل
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="#" id="refresh-list">
                        <i class="fas fa-sync fa-sm fa-fw ml-1"></i> بروزرسانی لیست
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- فیلترهای جستجو -->
            <div class="mb-4">
                <form action="<?php echo e(route('admin.categories.index')); ?>" method="GET" class="row" id="search-form">
                    <div class="col-md-3 mb-2">
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" placeholder="جستجو..." value="<?php echo e(request('search')); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-search fa-sm"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-2">
                        <select class="form-control" name="parent_id" onchange="document.getElementById('search-form').submit()">
                            <option value="">همه دسته‌بندی‌ها</option>
                            <option value="only_parent" <?php echo e(request('parent_id') == 'only_parent' ? 'selected' : ''); ?>>فقط دسته‌های اصلی</option>
                            <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($id); ?>" <?php echo e(request('parent_id') == $id ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <select class="form-control" name="show_in_menu" onchange="document.getElementById('search-form').submit()">
                            <option value="">وضعیت نمایش در منو</option>
                            <option value="1" <?php echo e(request('show_in_menu') == '1' ? 'selected' : ''); ?>>نمایش در منو</option>
                            <option value="0" <?php echo e(request('show_in_menu') == '0' ? 'selected' : ''); ?>>عدم نمایش در منو</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <select class="form-control" name="show_in_filters" onchange="document.getElementById('search-form').submit()">
                            <option value="">وضعیت نمایش در فیلتر</option>
                            <option value="1" <?php echo e(request('show_in_filters') == '1' ? 'selected' : ''); ?>>نمایش در فیلتر</option>
                            <option value="0" <?php echo e(request('show_in_filters') == '0' ? 'selected' : ''); ?>>عدم نمایش در فیلتر</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <a href="<?php echo e(route('admin.categories.index')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-redo-alt"></i> حذف فیلترها
                        </a>
                    </div>
                </form>
            </div>
            
            <!-- جدول اطلاعات -->
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="categories-table" width="100%" cellspacing="0">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th width="40">آیکون</th>
                            <th>نام دسته‌بندی</th>
                            <th>کلید</th>
                            <th>والد</th>
                            <th width="80">اولویت</th>
                            <th width="100">وضعیت نمایش</th>
                            <th width="150">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="text-center">
                                    <?php if($category->emoji): ?>
                                        <span class="emoji-icon"><?php echo e($category->emoji); ?></span>
                                    <?php elseif($category->font_icon): ?>
                                        <i class="fa fa-<?php echo e($category->font_icon); ?>" style="color: <?php echo e($category->color ?: '#666'); ?>"></i>
                                    <?php else: ?>
                                        <i class="fa fa-folder"></i>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?php echo e($category->getTranslatedName(app()->getLocale())); ?></strong>
                                    <?php if($category->category_en): ?>
                                        <br>
                                        <small class="text-muted"><?php echo e($category->category_en); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><code><?php echo e($category->category_key); ?></code></td>
                                <td>
                                    <?php if($category->parent): ?>
                                        <?php echo e($category->parent->getTranslatedName(app()->getLocale())); ?>

                                    <?php else: ?>
                                        <span class="badge badge-secondary">دسته‌بندی اصلی</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo e($category->sort_order); ?></td>
                                <td>
                                    <div class="mb-1">
                                        <?php if($category->show_in_menu): ?>
                                            <span class="badge badge-success">نمایش در منو</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">عدم نمایش در منو</span>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <?php if($category->show_in_filters): ?>
                                            <span class="badge badge-success">نمایش در فیلتر</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">عدم نمایش در فیلتر</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('admin.categories.edit', $category->id)); ?>" class="btn btn-sm btn-primary" title="ویرایش">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.categories.show', $category->id)); ?>" class="btn btn-sm btn-info" title="نمایش جزئیات">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.categories.destroy', $category->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این دسته‌بندی اطمینان دارید؟')" title="حذف">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="alert alert-warning mb-0">
                                        <i class="fas fa-exclamation-triangle ml-1"></i>
                                        هیچ دسته‌بندی یافت نشد!
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- پاگینیشن -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($categories->appends(request()->query())->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // اسکریپت مربوط به صادر کردن داده‌ها
    $(document).ready(function() {
        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            window.location.href = '<?php echo e(route("admin.categories.index")); ?>' + '?export=csv&' + $('#search-form').serialize();
        });
        
        $('#export-excel').on('click', function(e) {
            e.preventDefault();
            window.location.href = '<?php echo e(route("admin.categories.index")); ?>' + '?export=excel&' + $('#search-form').serialize();
        });
        
        $('#refresh-list').on('click', function(e) {
            e.preventDefault();
            window.location.href = '<?php echo e(route("admin.categories.index")); ?>' + '?' + $('#search-form').serialize();
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>